/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediaeffect;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.serenegiant.glutils.GLHelper;
import com.serenegiant.glutils.TextureOffscreen;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class MediaEffectDrawer {
    protected TextureOffscreen mOutputOffscreen;
    protected boolean mEnabled = true;
    private static final String FRAGMENT_SHADER_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nvoid main() {\ngl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    protected static final String FRAGMENT_SHADER_2D = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nvoid main() {\ngl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n", "", "sampler2D");
    protected static final String FRAGMENT_SHADER_EXT = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nvoid main() {\ngl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");
    private static final float[] VERTICES = new float[]{1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f};
    private static final float[] TEXCOORD = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
    private static final int FLOAT_SZ = 4;
    private static final int VERTEX_NUM = 4;
    private static final int VERTEX_SZ = 8;
    protected final Object mSync = new Object();
    private final int mTexTarget;
    private final int muMVPMatrixLoc;
    private final int muTexMatrixLoc;
    private final float[] mMvpMatrix = new float[16];
    private int hProgram;

    public MediaEffectDrawer() {
        this(false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", FRAGMENT_SHADER_2D);
    }

    public MediaEffectDrawer(String fss) {
        this(false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    public MediaEffectDrawer(boolean isOES, String fss) {
        this(isOES, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    public MediaEffectDrawer(boolean isOES, String vss, String fss) {
        this.mTexTarget = isOES ? 36197 : 3553;
        FloatBuffer pVertex = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
        pVertex.put(VERTICES);
        pVertex.flip();
        FloatBuffer pTexCoord = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
        pTexCoord.put(TEXCOORD);
        pTexCoord.flip();
        this.hProgram = GLHelper.loadShader(vss, fss);
        GLES20.glUseProgram((int)this.hProgram);
        int maPositionLoc = GLES20.glGetAttribLocation((int)this.hProgram, (String)"aPosition");
        int maTextureCoordLoc = GLES20.glGetAttribLocation((int)this.hProgram, (String)"aTextureCoord");
        this.muMVPMatrixLoc = GLES20.glGetUniformLocation((int)this.hProgram, (String)"uMVPMatrix");
        this.muTexMatrixLoc = GLES20.glGetUniformLocation((int)this.hProgram, (String)"uTexMatrix");
        Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
        if (this.muMVPMatrixLoc >= 0) {
            GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])this.mMvpMatrix, (int)0);
        }
        if (this.muTexMatrixLoc >= 0) {
            GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])this.mMvpMatrix, (int)0);
        }
        GLES20.glVertexAttribPointer((int)maPositionLoc, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)pVertex);
        GLES20.glEnableVertexAttribArray((int)maPositionLoc);
        GLES20.glVertexAttribPointer((int)maTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)pTexCoord);
        GLES20.glEnableVertexAttribArray((int)maTextureCoordLoc);
    }

    public void release() {
        GLES20.glUseProgram((int)0);
        if (this.hProgram >= 0) {
            GLES20.glDeleteProgram((int)this.hProgram);
        }
        this.hProgram = -1;
    }

    protected int getProgram() {
        return this.hProgram;
    }

    public float[] getMvpMatrix() {
        return this.mMvpMatrix;
    }

    public void setTexSize(int width, int height) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMvpMatrix(float[] matrix, int offset) {
        Object object = this.mSync;
        synchronized (object) {
            System.arraycopy(matrix, offset, this.mMvpMatrix, 0, this.mMvpMatrix.length);
        }
    }

    public void getMvpMatrix(float[] matrix, int offset) {
        System.arraycopy(this.mMvpMatrix, 0, matrix, offset, this.mMvpMatrix.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(int tex_id, float[] tex_matrix, int offset) {
        Object object = this.mSync;
        synchronized (object) {
            GLES20.glUseProgram((int)this.hProgram);
            this.preDraw(tex_id, tex_matrix, offset);
            this.draw(tex_id, tex_matrix, offset);
            this.postDraw();
        }
    }

    protected void preDraw(int tex_id, float[] tex_matrix, int offset) {
        if (this.muTexMatrixLoc >= 0 && tex_matrix != null) {
            GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])tex_matrix, (int)offset);
        }
        if (this.muMVPMatrixLoc >= 0) {
            GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])this.mMvpMatrix, (int)0);
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)this.mTexTarget, (int)tex_id);
    }

    protected void draw(int tex_id, float[] tex_matrix, int offset) {
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    protected void postDraw() {
        GLES20.glBindTexture((int)this.mTexTarget, (int)0);
        GLES20.glUseProgram((int)0);
    }
}

