/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import com.serenegiant.media.AbstractRecorder;
import com.serenegiant.media.IMediaCodec;
import com.serenegiant.media.IMediaCodecCallback;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public abstract class MediaEncoder
implements IMediaCodec {
    private static final boolean DEBUG = false;
    private final String TAG = this.getClass().getSimpleName();
    protected final boolean mIsAudio;
    protected final Object mSync = new Object();
    protected boolean mIsPrepared;
    protected volatile boolean mIsCapturing;
    private int mRequestDrain;
    protected volatile boolean mRequestStop;
    protected boolean mIsEOS;
    protected boolean mMuxerStarted;
    protected int mTrackIndex;
    protected MediaCodec mMediaCodec;
    protected final WeakReference<AbstractRecorder> mWeakMuxer;
    private MediaCodec.BufferInfo mBufferInfo;
    private final IMediaCodecCallback mCallback;
    private final Runnable mEncodeTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Object object2 = MediaEncoder.this.mSync;
            synchronized (object2) {
                MediaEncoder.this.mRequestStop = false;
                MediaEncoder.this.mRequestDrain = 0;
                MediaEncoder.this.mSync.notify();
                try {
                    MediaEncoder.this.mSync.wait();
                    MediaEncoder.this.callOnStart();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            while (true) {
                boolean localRequestDrain;
                boolean localRequestStop;
                object = MediaEncoder.this.mSync;
                synchronized (object) {
                    localRequestStop = MediaEncoder.this.mRequestStop;
                    boolean bl = localRequestDrain = MediaEncoder.this.mRequestDrain > 0;
                    if (localRequestDrain) {
                        MediaEncoder.this.mRequestDrain--;
                    }
                    if (!localRequestDrain && !localRequestStop) {
                        try {
                            MediaEncoder.this.mSync.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
                if (localRequestStop) {
                    MediaEncoder.this.callOnStop();
                    MediaEncoder.this.drain();
                    MediaEncoder.this.signalEndOfInputStream();
                    MediaEncoder.this.drain();
                    break;
                }
                if (!localRequestDrain) continue;
                MediaEncoder.this.drain();
            }
            MediaEncoder.this.release();
            object = MediaEncoder.this.mSync;
            synchronized (object) {
                MediaEncoder.this.mRequestStop = true;
                MediaEncoder.this.mIsCapturing = false;
            }
        }
    };
    private long prevOutputPTSUs = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaEncoder(boolean is_audio, AbstractRecorder muxer, IMediaCodecCallback listener) {
        if (listener == null) {
            throw new NullPointerException("MediaEncoderListener is null");
        }
        if (muxer == null) {
            throw new NullPointerException("MediaMuxerWrapper is null");
        }
        this.mIsAudio = is_audio;
        this.mWeakMuxer = new WeakReference<AbstractRecorder>(muxer);
        muxer.addEncoder(this);
        this.mCallback = listener;
        Object object = this.mSync;
        synchronized (object) {
            this.mBufferInfo = new MediaCodec.BufferInfo();
            new Thread(this.mEncodeTask, this.getClass().getSimpleName()).start();
            try {
                this.mSync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.mSync;
        synchronized (object) {
            this.mIsCapturing = true;
            this.mRequestStop = false;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
            this.mRequestStop = true;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean frameAvailableSoon() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return false;
            }
            ++this.mRequestDrain;
            this.mSync.notifyAll();
        }
        return true;
    }

    @Override
    public boolean isPrepared() {
        return this.mIsPrepared;
    }

    @Override
    public boolean isRunning() {
        return this.mIsCapturing;
    }

    public boolean isAudio() {
        return this.mIsAudio;
    }

    protected boolean callErrorHandler(Exception e) {
        return this.mCallback != null && this.mCallback.onError(this, e);
    }

    protected void callOnPrepared() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onPrepared(this);
            }
            catch (Exception e) {
                Log.w((String)this.TAG, (String)"callOnPrepared", (Throwable)e);
            }
        }
    }

    protected void callOnStart() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onStart(this);
            }
            catch (Exception e) {
                Log.w((String)this.TAG, (String)"callOnStart", (Throwable)e);
            }
        }
    }

    protected void callOnStop() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onStop(this);
            }
            catch (Exception e) {
                Log.w((String)this.TAG, (String)"callOnStop", (Throwable)e);
            }
        }
    }

    protected void callOnRelease() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onRelease(this);
            }
            catch (Exception e) {
                Log.w((String)this.TAG, (String)"callOnRelease", (Throwable)e);
            }
        }
    }

    @Override
    public void release() {
        block7: {
            AbstractRecorder muxer;
            block6: {
                this.mIsCapturing = false;
                if (this.mMediaCodec != null) {
                    try {
                        this.mMediaCodec.stop();
                        this.mMediaCodec.release();
                        this.mMediaCodec = null;
                    }
                    catch (Exception e) {
                        boolean handled = this.callErrorHandler(e);
                        if (handled) break block6;
                        Log.e((String)this.TAG, (String)"failed releasing MediaCodec", (Throwable)e);
                    }
                }
            }
            if (this.mMuxerStarted && (muxer = (AbstractRecorder)this.mWeakMuxer.get()) != null) {
                try {
                    muxer.stop();
                }
                catch (Exception e) {
                    boolean handled = this.callErrorHandler(e);
                    if (handled) break block7;
                    Log.e((String)this.TAG, (String)"failed stopping muxer", (Throwable)e);
                }
            }
        }
        this.mBufferInfo = null;
        this.callOnRelease();
    }

    protected void signalEndOfInputStream() {
        this.encode(null, 0, this.getPTSUs());
    }

    protected void encode(ByteBuffer buffer, int length, long presentationTimeUs) {
        if (!this.mIsCapturing || this.mRequestStop || this.mMediaCodec == null) {
            return;
        }
        ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
        while (this.mIsCapturing) {
            int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(10000L);
            if (inputBufferIndex >= 0) {
                ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
                inputBuffer.clear();
                if (buffer != null) {
                    inputBuffer.put(buffer);
                }
                if (length > 0) {
                    this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, length, presentationTimeUs, 0);
                    break;
                }
                this.mIsEOS = true;
                this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                break;
            }
            if (inputBufferIndex != -1) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drain() {
        if (this.mMediaCodec == null) {
            return;
        }
        ByteBuffer[] encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
        int count = 0;
        AbstractRecorder muxer = (AbstractRecorder)this.mWeakMuxer.get();
        if (muxer == null) {
            Log.w((String)this.TAG, (String)"muxer is unexpectedly null");
            return;
        }
        block7: while (this.mIsCapturing) {
            try {
                RuntimeException e;
                boolean handled;
                int encoderStatus = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 10000L);
                if (encoderStatus == -1) {
                    if (this.mIsEOS || ++count <= 5) continue;
                    break;
                }
                if (encoderStatus == -3) {
                    encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
                    continue;
                }
                if (encoderStatus == -2) {
                    RuntimeException e2;
                    boolean handled22;
                    if (this.mMuxerStarted && !(handled22 = this.callErrorHandler(e2 = new RuntimeException("format changed twice")))) {
                        throw e2;
                    }
                    MediaFormat format = this.mMediaCodec.getOutputFormat();
                    this.mTrackIndex = muxer.addTrack(format);
                    this.mMuxerStarted = true;
                    if (muxer.start()) continue;
                    AbstractRecorder handled22 = muxer;
                    synchronized (handled22) {
                        while (!muxer.isStarted() && this.mIsCapturing) {
                            try {
                                muxer.wait(100L);
                            }
                            catch (InterruptedException e3) {
                                break block7;
                            }
                        }
                        continue;
                    }
                }
                if (encoderStatus < 0) continue;
                ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
                if (encodedData == null && !(handled = this.callErrorHandler(e = new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null")))) {
                    throw e;
                }
                if ((this.mBufferInfo.flags & 2) != 0) {
                    this.mBufferInfo.size = 0;
                }
                if (this.mBufferInfo.size != 0) {
                    count = 0;
                    if (!this.mMuxerStarted) {
                        throw new RuntimeException("drain:muxer hasn't started");
                    }
                    this.mBufferInfo.presentationTimeUs = this.getPTSUs();
                    muxer.writeSampleData(this.mTrackIndex, encodedData, this.mBufferInfo);
                    this.prevOutputPTSUs = this.mBufferInfo.presentationTimeUs;
                }
                this.mMediaCodec.releaseOutputBuffer(encoderStatus, false);
                if ((this.mBufferInfo.flags & 4) == 0) continue;
                this.mIsCapturing = false;
            }
            catch (Exception e) {
                this.callErrorHandler(e);
            }
            break;
        }
    }

    protected long getPTSUs() {
        long result = System.nanoTime() / 1000L;
        if (result < this.prevOutputPTSUs) {
            result = this.prevOutputPTSUs - result + result;
        }
        return result;
    }
}

