/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.os.Process;
import android.util.Log;
import com.serenegiant.media.AudioData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class IAudioSampler {
    private final String TAG = this.getClass().getSimpleName();
    private final int MAX_POOL_SIZE = 200;
    private final int MAX_QUEUE_SIZE = 200;
    private final LinkedBlockingQueue<AudioData> mPool = new LinkedBlockingQueue(200);
    private final LinkedBlockingQueue<AudioData> mAudioQueue = new LinkedBlockingQueue(200);
    private CallbackThread mCallbackThread;
    private final Object mCallbackSync = new Object();
    private final List<SoundSamplerCallback> mCallbacks = new ArrayList<SoundSamplerCallback>();
    protected volatile boolean mIsCapturing;
    protected int mDefaultBufferSize = 1024;
    private int mBufferNum = 0;
    private long prevInputPTSUs = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.isStarted()) {
            this.stop();
        }
        Object object = this.mCallbackSync;
        synchronized (object) {
            this.mCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        Object object = this.mCallbackSync;
        synchronized (object) {
            if (this.mCallbackThread == null) {
                this.mIsCapturing = true;
                this.mCallbackThread = new CallbackThread();
                this.mCallbackThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        Object object = this.mCallbackSync;
        synchronized (object) {
            boolean capturing = this.mIsCapturing;
            this.mIsCapturing = false;
            this.mCallbackThread = null;
            if (capturing) {
                try {
                    this.mCallbackSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(SoundSamplerCallback callback) {
        Object object = this.mCallbackSync;
        synchronized (object) {
            this.mCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(SoundSamplerCallback callback) {
        Object object = this.mCallbackSync;
        synchronized (object) {
            while (this.mCallbacks.remove(callback)) {
            }
        }
    }

    public boolean isStarted() {
        return this.mIsCapturing;
    }

    public abstract int getAudioSource();

    public abstract int getChannels();

    public abstract int getSamplingFrequency();

    public abstract int getBitResolution();

    public int getBufferSize() {
        return this.mDefaultBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOnData(AudioData data) {
        Object object = this.mCallbackSync;
        synchronized (object) {
            for (SoundSamplerCallback callback : this.mCallbacks) {
                try {
                    data.mBuffer.rewind();
                    callback.onData(data.mBuffer, data.size, data.presentationTimeUs);
                }
                catch (Exception e) {
                    Log.w((String)this.TAG, (String)"callOnData:", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callOnError(Exception e) {
        Object object = this.mCallbackSync;
        synchronized (object) {
            for (SoundSamplerCallback callback : this.mCallbacks) {
                try {
                    callback.onError(e);
                }
                catch (Exception e1) {
                    Log.w((String)this.TAG, (String)"callOnError:", (Throwable)e1);
                }
            }
        }
    }

    protected void init_pool(int default_buffer_size) {
        this.mDefaultBufferSize = default_buffer_size;
        this.mAudioQueue.clear();
        this.mPool.clear();
        for (int i = 0; i < 8; ++i) {
            this.mPool.add(new AudioData(default_buffer_size));
        }
    }

    protected AudioData obtain() {
        AudioData result = null;
        if (!this.mPool.isEmpty()) {
            result = this.mPool.poll();
        } else if (this.mBufferNum < 200) {
            result = new AudioData(this.mDefaultBufferSize);
            ++this.mBufferNum;
        }
        if (result != null) {
            result.size = 0;
        }
        return result;
    }

    protected void recycle(AudioData data) {
        if (!this.mPool.offer(data)) {
            --this.mBufferNum;
        }
    }

    protected void addAudioData(AudioData data) {
        this.mAudioQueue.offer(data);
    }

    protected AudioData pollAudioData(long timout_msec) throws InterruptedException {
        return this.mAudioQueue.poll(timout_msec, TimeUnit.MILLISECONDS);
    }

    protected long getInputPTSUs() {
        long result = System.nanoTime() / 1000L;
        if (result <= this.prevInputPTSUs) {
            result = this.prevInputPTSUs + 9643L;
        }
        this.prevInputPTSUs = result;
        return result;
    }

    private final class CallbackThread
    extends Thread {
        public CallbackThread() {
            super("AudioSampler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Process.setThreadPriority((int)-16);
            while (IAudioSampler.this.mIsCapturing) {
                AudioData data;
                try {
                    data = IAudioSampler.this.pollAudioData(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (data == null) continue;
                IAudioSampler.this.callOnData(data);
                IAudioSampler.this.recycle(data);
            }
            Object object = IAudioSampler.this.mCallbackSync;
            synchronized (object) {
                IAudioSampler.this.mCallbackSync.notifyAll();
            }
        }
    }

    public static interface SoundSamplerCallback {
        public void onData(ByteBuffer var1, int var2, long var3);

        public void onError(Exception var1);
    }
}

