/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.serenegiant.glutils.EGLBase;
import com.serenegiant.glutils.EglTask;
import com.serenegiant.glutils.GLDrawer2D;
import com.serenegiant.glutils.GLHelper;
import com.serenegiant.glutils.IRendererHolder;
import com.serenegiant.glutils.RenderHolderCallback;
import com.serenegiant.glutils.RendererSurfaceRec;
import com.serenegiant.utils.BuildCheck;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RendererHolder
implements IRendererHolder {
    private static final String TAG = RendererHolder.class.getSimpleName();
    private final Object mSync = new Object();
    private final RenderHolderCallback mCallback;
    private volatile boolean isRunning;
    private File mCaptureFile;
    private final RendererTask mRendererTask;
    private static final int REQUEST_DRAW = 1;
    private static final int REQUEST_UPDATE_SIZE = 2;
    private static final int REQUEST_ADD_SURFACE = 3;
    private static final int REQUEST_REMOVE_SURFACE = 4;
    private static final int REQUEST_RECREATE_MASTER_SURFACE = 5;
    private static final int REQUEST_MIRROR = 6;
    private final Runnable mCaptureTask = new Runnable(){
        EGLBase eglBase;
        EGLBase.IEglSurface captureSurface;
        GLDrawer2D drawer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = RendererHolder.this.mSync;
            synchronized (object) {
                if (!RendererHolder.this.isRunning) {
                    try {
                        RendererHolder.this.mSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.init();
            if (this.eglBase.getGlVersion() > 2) {
                this.captureLoopGLES3();
            } else {
                this.captureLoopGLES2();
            }
            this.release();
        }

        private final void init() {
            this.eglBase = EGLBase.createFrom(3, RendererHolder.this.mRendererTask.getContext(), false, 0, false);
            this.captureSurface = this.eglBase.createOffscreen(RendererHolder.this.mRendererTask.mVideoWidth, RendererHolder.this.mRendererTask.mVideoHeight);
            this.drawer = new GLDrawer2D(true);
            float[] fArray = this.drawer.getMvpMatrix();
            fArray[5] = fArray[5] * -1.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void captureLoopGLES2() {
            int width = -1;
            int height = -1;
            ByteBuffer buf = null;
            File captureFile = null;
            while (RendererHolder.this.isRunning) {
                Object object = RendererHolder.this.mSync;
                synchronized (object) {
                    if (captureFile == null) {
                        if (RendererHolder.this.mCaptureFile == null) {
                            try {
                                RendererHolder.this.mSync.wait();
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                        if (RendererHolder.this.mCaptureFile != null) {
                            captureFile = RendererHolder.this.mCaptureFile;
                            RendererHolder.this.mCaptureFile = null;
                        }
                        continue;
                    }
                    if (buf == null | width != RendererHolder.this.mRendererTask.mVideoWidth || height != RendererHolder.this.mRendererTask.mVideoHeight) {
                        width = RendererHolder.this.mRendererTask.mVideoWidth;
                        height = RendererHolder.this.mRendererTask.mVideoHeight;
                        buf = ByteBuffer.allocateDirect(width * height * 4);
                        buf.order(ByteOrder.LITTLE_ENDIAN);
                        if (this.captureSurface != null) {
                            this.captureSurface.release();
                            this.captureSurface = null;
                        }
                        this.captureSurface = this.eglBase.createOffscreen(width, height);
                    }
                    if (RendererHolder.this.isRunning) {
                        this.captureSurface.makeCurrent();
                        this.drawer.draw(RendererHolder.this.mRendererTask.mTexId, ((RendererHolder)RendererHolder.this).mRendererTask.mTexMatrix, 0);
                        this.captureSurface.swap();
                        buf.clear();
                        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
                        Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
                        if (captureFile.toString().endsWith(".jpg")) {
                            compressFormat = Bitmap.CompressFormat.JPEG;
                        }
                        FilterOutputStream os = null;
                        try {
                            try {
                                os = new BufferedOutputStream(new FileOutputStream(captureFile));
                                Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                buf.clear();
                                bmp.copyPixelsFromBuffer((Buffer)buf);
                                bmp.compress(compressFormat, 90, (OutputStream)os);
                                bmp.recycle();
                                ((BufferedOutputStream)os).flush();
                            }
                            finally {
                                if (os != null) {
                                    os.close();
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            Log.w((String)TAG, (String)"failed to save file", (Throwable)e);
                        }
                        catch (IOException e) {
                            Log.w((String)TAG, (String)"failed to save file", (Throwable)e);
                        }
                    }
                    captureFile = null;
                    RendererHolder.this.mSync.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void captureLoopGLES3() {
            int width = -1;
            int height = -1;
            ByteBuffer buf = null;
            File captureFile = null;
            while (RendererHolder.this.isRunning) {
                Object object = RendererHolder.this.mSync;
                synchronized (object) {
                    if (captureFile == null) {
                        if (RendererHolder.this.mCaptureFile == null) {
                            try {
                                RendererHolder.this.mSync.wait();
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                        if (RendererHolder.this.mCaptureFile != null) {
                            captureFile = RendererHolder.this.mCaptureFile;
                            RendererHolder.this.mCaptureFile = null;
                        }
                        continue;
                    }
                    if (buf == null | width != RendererHolder.this.mRendererTask.mVideoWidth || height != RendererHolder.this.mRendererTask.mVideoHeight) {
                        width = RendererHolder.this.mRendererTask.mVideoWidth;
                        height = RendererHolder.this.mRendererTask.mVideoHeight;
                        buf = ByteBuffer.allocateDirect(width * height * 4);
                        buf.order(ByteOrder.LITTLE_ENDIAN);
                        if (this.captureSurface != null) {
                            this.captureSurface.release();
                            this.captureSurface = null;
                        }
                        this.captureSurface = this.eglBase.createOffscreen(width, height);
                    }
                    if (RendererHolder.this.isRunning) {
                        this.captureSurface.makeCurrent();
                        this.drawer.draw(RendererHolder.this.mRendererTask.mTexId, ((RendererHolder)RendererHolder.this).mRendererTask.mTexMatrix, 0);
                        this.captureSurface.swap();
                        buf.clear();
                        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
                        Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
                        if (captureFile.toString().endsWith(".jpg")) {
                            compressFormat = Bitmap.CompressFormat.JPEG;
                        }
                        FilterOutputStream os = null;
                        try {
                            try {
                                os = new BufferedOutputStream(new FileOutputStream(captureFile));
                                Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                buf.clear();
                                bmp.copyPixelsFromBuffer((Buffer)buf);
                                bmp.compress(compressFormat, 90, (OutputStream)os);
                                bmp.recycle();
                                ((BufferedOutputStream)os).flush();
                            }
                            finally {
                                if (os != null) {
                                    os.close();
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            Log.w((String)TAG, (String)"failed to save file", (Throwable)e);
                        }
                        catch (IOException e) {
                            Log.w((String)TAG, (String)"failed to save file", (Throwable)e);
                        }
                    }
                    captureFile = null;
                    RendererHolder.this.mSync.notifyAll();
                }
            }
        }

        private final void release() {
            if (this.captureSurface != null) {
                this.captureSurface.makeCurrent();
                if (this.drawer != null) {
                    this.drawer.release();
                }
                this.captureSurface.release();
                this.captureSurface = null;
            }
            if (this.drawer != null) {
                this.drawer.release();
                this.drawer = null;
            }
            if (this.eglBase != null) {
                this.eglBase.release();
                this.eglBase = null;
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RendererHolder(int width, int height, @Nullable RenderHolderCallback callback) {
        this.mCallback = callback;
        this.mRendererTask = new RendererTask(this, width, height);
        new Thread((Runnable)this.mRendererTask, TAG).start();
        if (!this.mRendererTask.waitReady()) {
            throw new RuntimeException("failed to start renderer thread");
        }
        new Thread(this.mCaptureTask, "CaptureTask").start();
        Object object = this.mSync;
        synchronized (object) {
            if (!this.isRunning) {
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.mRendererTask.release();
        Object object = this.mSync;
        synchronized (object) {
            this.isRunning = false;
            this.mSync.notifyAll();
        }
    }

    @Override
    public Surface getSurface() {
        return this.mRendererTask.getSurface();
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.mRendererTask.getSurfaceTexture();
    }

    @Override
    public void reset() {
        this.mRendererTask.checkMasterSurface();
    }

    @Override
    public void resize(int width, int height) {
        this.mRendererTask.resize(width, height);
    }

    @Override
    public void setMirror(int mirror) {
        this.mRendererTask.mirror(mirror % 4);
    }

    @Override
    public void addSurface(int id2, Object surface, boolean isRecordable) {
        this.mRendererTask.addSurface(id2, surface);
    }

    @Override
    public void addSurface(int id2, Object surface, boolean isRecordable, int maxFps) {
        this.mRendererTask.addSurface(id2, surface, maxFps);
    }

    @Override
    public void removeSurface(int id2) {
        this.mRendererTask.removeSurface(id2);
    }

    @Override
    public void requestFrame() {
        this.mRendererTask.removeRequest(1);
        this.mRendererTask.offer(1);
    }

    @Override
    public int getCount() {
        return this.mRendererTask.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void captureStillAsync(String path) {
        File file = new File(path);
        Object object = this.mSync;
        synchronized (object) {
            this.mCaptureFile = file;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void captureStill(String path) {
        File file = new File(path);
        Object object = this.mSync;
        synchronized (object) {
            this.mCaptureFile = file;
            this.mSync.notifyAll();
            try {
                this.mSync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static final class RendererTask
    extends EglTask {
        private final Object mClientSync = new Object();
        private final SparseArray<RendererSurfaceRec> mClients = new SparseArray();
        private final RendererHolder mParent;
        private GLDrawer2D mDrawer;
        private int mTexId;
        private SurfaceTexture mMasterTexture;
        final float[] mTexMatrix = new float[16];
        private Surface mMasterSurface;
        private int mVideoWidth;
        private int mVideoHeight;
        private int mMirror = -1;
        private final SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                RendererTask.this.offer(1);
            }
        };

        public RendererTask(RendererHolder parent, int width, int height) {
            super(3, null, 2);
            this.mParent = parent;
            this.mVideoWidth = width;
            this.mVideoHeight = height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onStart() {
            this.mDrawer = new GLDrawer2D(true);
            this.handleReCreateMasterSurface();
            Object object = this.mParent.mSync;
            synchronized (object) {
                this.mParent.isRunning = true;
                this.mParent.mSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onStop() {
            Object object = this.mParent.mSync;
            synchronized (object) {
                this.mParent.isRunning = false;
                this.mParent.mSync.notifyAll();
            }
            this.makeCurrent();
            if (this.mDrawer != null) {
                this.mDrawer.release();
                this.mDrawer = null;
            }
            this.handleReleaseMasterSurface();
            this.handleRemoveAll();
        }

        @Override
        protected boolean onError(Exception e) {
            return false;
        }

        @Override
        protected Object processRequest(int request, int arg1, int arg2, Object obj) {
            switch (request) {
                case 1: {
                    this.handleDraw();
                    break;
                }
                case 2: {
                    this.handleResize(arg1, arg2);
                    break;
                }
                case 3: {
                    this.handleAddSurface(arg1, obj, arg2);
                    break;
                }
                case 4: {
                    this.handleRemoveSurface(arg1);
                    break;
                }
                case 5: {
                    this.handleReCreateMasterSurface();
                    break;
                }
                case 6: {
                    this.handleMirror(arg1);
                }
            }
            return null;
        }

        public Surface getSurface() {
            this.checkMasterSurface();
            return this.mMasterSurface;
        }

        public SurfaceTexture getSurfaceTexture() {
            this.checkMasterSurface();
            return this.mMasterTexture;
        }

        public void addSurface(int id2, Object surface) {
            this.addSurface(id2, surface, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSurface(int id2, Object surface, int maxFps) {
            this.checkFinished();
            if (!(surface instanceof SurfaceTexture || surface instanceof Surface || surface instanceof SurfaceHolder)) {
                throw new IllegalArgumentException("Surface should be one of Surface, SurfaceTexture or SurfaceHolder");
            }
            Object object = this.mClientSync;
            synchronized (object) {
                if (surface != null && this.mClients.get(id2) == null) {
                    while (true) {
                        if (this.offer(3, id2, maxFps, surface)) {
                            try {
                                this.mClientSync.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                        try {
                            this.mClientSync.wait(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSurface(int id2) {
            Object object = this.mClientSync;
            synchronized (object) {
                if (this.mClients.get(id2) != null) {
                    while (true) {
                        if (this.offer(4, id2)) {
                            try {
                                this.mClientSync.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                        try {
                            this.mClientSync.wait(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getCount() {
            Object object = this.mClientSync;
            synchronized (object) {
                return this.mClients.size();
            }
        }

        public void resize(int width, int height) {
            this.checkFinished();
            if (this.mVideoWidth != width || this.mVideoHeight != height) {
                this.offer(2, width, height);
            }
        }

        public void mirror(int mirror) {
            this.checkFinished();
            if (this.mMirror != mirror) {
                this.offer(6, mirror);
            }
        }

        public void checkMasterSurface() {
            this.checkFinished();
            if (this.mMasterSurface == null || !this.mMasterSurface.isValid()) {
                Log.d((String)TAG, (String)"checkMasterSurface:invalid master surface");
                this.offerAndWait(5, 0, 0, null);
            }
        }

        private void checkFinished() {
            if (this.isFinished()) {
                throw new RuntimeException("already finished");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleDraw() {
            if (this.mMasterSurface == null || !this.mMasterSurface.isValid()) {
                Log.w((String)TAG, (String)"checkMasterSurface:invalid master surface");
                this.offer(5);
                return;
            }
            try {
                this.makeCurrent();
                this.mMasterTexture.updateTexImage();
                this.mMasterTexture.getTransformMatrix(this.mTexMatrix);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("draw:thread id =" + Thread.currentThread().getId()), (Throwable)e);
                this.offer(5);
                return;
            }
            Object object = this.mParent.mCaptureTask;
            synchronized (object) {
                this.mParent.mCaptureTask.notify();
            }
            object = this.mClientSync;
            synchronized (object) {
                int n = this.mClients.size();
                for (int i = n - 1; i >= 0; --i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null || !client.canDraw()) continue;
                    try {
                        client.draw(this.mDrawer, this.mTexId, this.mTexMatrix);
                        continue;
                    }
                    catch (Exception e) {
                        this.mClients.removeAt(i);
                        client.release();
                    }
                }
            }
            if (this.mParent.mCallback != null) {
                try {
                    this.mParent.mCallback.onFrameAvailable();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            GLES20.glClear((int)16384);
            GLES20.glFlush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleAddSurface(int id2, Object surface, int maxFps) {
            this.checkSurface();
            Object object = this.mClientSync;
            synchronized (object) {
                RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.get(id2);
                if (client == null) {
                    try {
                        client = RendererSurfaceRec.newInstance(this.getEgl(), surface, maxFps);
                        this.setMirror(client, this.mMirror);
                        this.mClients.append(id2, (Object)client);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (String)("invalid surface: surface=" + surface), (Throwable)e);
                    }
                } else {
                    Log.w((String)TAG, (String)("surface is already added: id=" + id2));
                }
                this.mClientSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRemoveSurface(int id2) {
            Object object = this.mClientSync;
            synchronized (object) {
                RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.get(id2);
                if (client != null) {
                    this.mClients.remove(id2);
                    client.release();
                }
                this.checkSurface();
                this.mClientSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRemoveAll() {
            Object object = this.mClientSync;
            synchronized (object) {
                int n = this.mClients.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null) continue;
                    this.makeCurrent();
                    client.release();
                }
                this.mClients.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkSurface() {
            Object object = this.mClientSync;
            synchronized (object) {
                int n = this.mClients.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null || client.isValid()) continue;
                    int id2 = this.mClients.keyAt(i);
                    ((RendererSurfaceRec)this.mClients.valueAt(i)).release();
                    this.mClients.remove(id2);
                }
            }
        }

        @SuppressLint(value={"NewApi"})
        private void handleReCreateMasterSurface() {
            this.makeCurrent();
            this.handleReleaseMasterSurface();
            this.makeCurrent();
            this.mTexId = GLHelper.initTex(36197, 9728);
            this.mMasterTexture = new SurfaceTexture(this.mTexId);
            this.mMasterSurface = new Surface(this.mMasterTexture);
            if (BuildCheck.isAndroid4_1()) {
                this.mMasterTexture.setDefaultBufferSize(this.mVideoWidth, this.mVideoHeight);
            }
            this.mMasterTexture.setOnFrameAvailableListener(this.mOnFrameAvailableListener);
            try {
                if (this.mParent.mCallback != null) {
                    this.mParent.mCallback.onCreate(this.mMasterSurface);
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }

        private void handleReleaseMasterSurface() {
            try {
                if (this.mParent.mCallback != null) {
                    this.mParent.mCallback.onDestroy();
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.mMasterSurface = null;
            if (this.mMasterTexture != null) {
                this.mMasterTexture.release();
                this.mMasterTexture = null;
            }
            if (this.mTexId != 0) {
                GLHelper.deleteTex(this.mTexId);
                this.mTexId = 0;
            }
        }

        @SuppressLint(value={"NewApi"})
        private void handleResize(int width, int height) {
            this.mVideoWidth = width;
            this.mVideoHeight = height;
            if (BuildCheck.isAndroid4_1()) {
                this.mMasterTexture.setDefaultBufferSize(this.mVideoWidth, this.mVideoHeight);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMirror(int mirror) {
            this.mMirror = mirror;
            Object object = this.mClientSync;
            synchronized (object) {
                int n = this.mClients.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null) continue;
                    this.setMirror(client, mirror);
                }
            }
        }

        private void setMirror(RendererSurfaceRec client, int mirror) {
            float[] mvp = client.mMvpMatrix;
            switch (mirror) {
                case 0: {
                    mvp[0] = Math.abs(mvp[0]);
                    mvp[5] = Math.abs(mvp[5]);
                    break;
                }
                case 1: {
                    mvp[0] = -Math.abs(mvp[0]);
                    mvp[5] = Math.abs(mvp[5]);
                    break;
                }
                case 2: {
                    mvp[0] = Math.abs(mvp[0]);
                    mvp[5] = -Math.abs(mvp[5]);
                    break;
                }
                case 3: {
                    mvp[0] = -Math.abs(mvp[0]);
                    mvp[5] = -Math.abs(mvp[5]);
                }
            }
        }
    }
}

