/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.opengl.GLUtils;
import android.util.Log;
import com.serenegiant.utils.AssetsHelper;
import com.serenegiant.utils.BuildCheck;
import java.io.IOException;

public final class GLHelper {
    private static final String TAG = "GLHelper";

    public static void checkGlError(String op) {
        int error = GLES20.glGetError();
        if (error != 0) {
            String msg = op + ": glError 0x" + Integer.toHexString(error);
            Log.e((String)TAG, (String)msg);
            new Throwable(msg).printStackTrace();
        }
    }

    public static int initTex(int texTarget, int filter_param) {
        return GLHelper.initTex(texTarget, 33984, filter_param, filter_param, 33071);
    }

    public static int initTex(int texTarget, int texUnit, int min_filter, int mag_filter, int wrap) {
        int[] tex = new int[1];
        GLES20.glActiveTexture((int)texUnit);
        GLES20.glGenTextures((int)1, (int[])tex, (int)0);
        GLES20.glBindTexture((int)texTarget, (int)tex[0]);
        GLES20.glTexParameteri((int)texTarget, (int)10242, (int)wrap);
        GLES20.glTexParameteri((int)texTarget, (int)10243, (int)wrap);
        GLES20.glTexParameteri((int)texTarget, (int)10241, (int)min_filter);
        GLES20.glTexParameteri((int)texTarget, (int)10240, (int)mag_filter);
        return tex[0];
    }

    public static void deleteTex(int hTex) {
        int[] tex = new int[]{hTex};
        GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
    }

    public static int loadTextureFromResource(Context context, int resId) {
        Bitmap bitmap = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(0, 0, 255, 0);
        Drawable background = context.getResources().getDrawable(resId);
        background.setBounds(0, 0, 256, 256);
        background.draw(canvas);
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        bitmap.recycle();
        return textures[0];
    }

    public static int createTextureWithTextContent(String text) {
        Bitmap bitmap = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(0, 0, 255, 0);
        Paint textPaint = new Paint();
        textPaint.setTextSize(32.0f);
        textPaint.setAntiAlias(true);
        textPaint.setARGB(255, 255, 255, 255);
        canvas.drawText(text, 16.0f, 112.0f, textPaint);
        int texture = GLHelper.initTex(3553, 33984, 9728, 9729, 10497);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        bitmap.recycle();
        return texture;
    }

    public static int loadShader(Context context, String vss_asset, String fss_asset) {
        int program = 0;
        try {
            String vss = AssetsHelper.loadString(context.getAssets(), vss_asset);
            String fss = AssetsHelper.loadString(context.getAssets(), vss_asset);
            program = GLHelper.loadShader(vss, fss);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return program;
    }

    public static int loadShader(String vss, String fss) {
        int[] compiled = new int[1];
        int vs = GLHelper.loadShader(35633, vss);
        if (vs == 0) {
            return 0;
        }
        int fs = GLHelper.loadShader(35632, fss);
        if (fs == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        GLHelper.checkGlError("glCreateProgram");
        if (program == 0) {
            Log.e((String)TAG, (String)"Could not create program");
        }
        GLES20.glAttachShader((int)program, (int)vs);
        GLHelper.checkGlError("glAttachShader");
        GLES20.glAttachShader((int)program, (int)fs);
        GLHelper.checkGlError("glAttachShader");
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            Log.e((String)TAG, (String)"Could not link program: ");
            Log.e((String)TAG, (String)GLES20.glGetProgramInfoLog((int)program));
            GLES20.glDeleteProgram((int)program);
            return 0;
        }
        return program;
    }

    public static int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        GLHelper.checkGlError("glCreateShader type=" + shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Log.e((String)TAG, (String)("Could not compile shader " + shaderType + ":"));
            Log.e((String)TAG, (String)(" " + GLES20.glGetShaderInfoLog((int)shader)));
            GLES20.glDeleteShader((int)shader);
            shader = 0;
        }
        return shader;
    }

    public static void checkLocation(int location, String label) {
        if (location < 0) {
            throw new RuntimeException("Unable to locate '" + label + "' in program");
        }
    }

    @SuppressLint(value={"InlinedApi"})
    public static void logVersionInfo() {
        Log.i((String)TAG, (String)("vendor  : " + GLES20.glGetString((int)7936)));
        Log.i((String)TAG, (String)("renderer: " + GLES20.glGetString((int)7937)));
        Log.i((String)TAG, (String)("version : " + GLES20.glGetString((int)7938)));
        if (BuildCheck.isAndroid4_3()) {
            int[] values = new int[1];
            GLES30.glGetIntegerv((int)33307, (int[])values, (int)0);
            int majorVersion = values[0];
            GLES30.glGetIntegerv((int)33308, (int[])values, (int)0);
            int minorVersion = values[0];
            if (GLES30.glGetError() == 0) {
                Log.i((String)TAG, (String)("version: " + majorVersion + "." + minorVersion));
            }
        }
    }
}

