/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.serenegiant.common.R;
import com.serenegiant.glutils.IRendererCommon;
import com.serenegiant.widget.AspectScaledTextureView;

public class ZoomAspectScaledTextureView
extends AspectScaledTextureView
implements IRendererCommon {
    private boolean mHandleTouchEvent = true;
    private static final int STATE_NON = 0;
    private static final int STATE_WAITING = 1;
    private static final int STATE_DRAGING = 2;
    private static final int STATE_CHECKING = 3;
    private static final int STATE_ZOOMING = 4;
    private static final int STATE_ROTATING = 5;
    private static final float DEFAULT_MAX_SCALE = 8.0f;
    private static final float DEFAULT_MIN_SCALE = 0.8f;
    private static final float DEFAULT_SCALE = 1.0f;
    private static final float MIN_DISTANCE = 15.0f;
    private static final float MIN_DISTANCE_SQUARE = 225.0f;
    private static final float MOVE_LIMIT_RATE = 0.2f;
    private static final int CHECK_TIMEOUT = ViewConfiguration.getTapTimeout() + ViewConfiguration.getLongPressTimeout();
    private static final int TAP_TIMEOUT = ViewConfiguration.getTapTimeout() * 2;
    private static final int LONG_PRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
    private static final float TO_DEGREE = 57.29578f;
    private static final float EPS = 0.1f;
    protected final Matrix mDefaultMatrix = new Matrix();
    protected boolean mImageMatrixChanged;
    protected final float[] mMatrixCache = new float[9];
    private final Matrix mSavedImageMatrix = new Matrix();
    private final RectF mLimitRect = new RectF();
    private final LineSegment[] mLimitSegments = new LineSegment[4];
    private final RectF mImageRect = new RectF();
    private final float[] mTrans = new float[8];
    private int mPrimaryId;
    private int mSecondaryId;
    private float mPrimaryX;
    private float mPrimaryY;
    private float mSecondX;
    private float mSecondY;
    private float mPivotX;
    private float mPivotY;
    private float mTouchDistance;
    private float mCurrentDegrees;
    private boolean mIsRotating;
    protected final float mMaxScale = 8.0f;
    private float mMinScale = 0.8f;
    private int mState = -1;
    private Runnable mWaitImageReset;
    private Runnable mStartCheckRotate;
    private int mMirrorMode = -1;

    public ZoomAspectScaledTextureView(Context context) {
        this(context, null, 0);
    }

    public ZoomAspectScaledTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZoomAspectScaledTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ZoomAspectScaledTextureView, defStyleAttr, 0);
        try {
            this.mHandleTouchEvent = a.getBoolean(R.styleable.ZoomAspectScaledTextureView_handle_touch_event, true);
        }
        finally {
            a.recycle();
        }
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mHandleTouchEvent) {
            return super.onTouchEvent(event);
        }
        actionCode = event.getActionMasked();
        switch (actionCode) {
            case 0: {
                this.startWaiting(event);
                return true;
            }
            case 5: {
                switch (this.mState) {
                    case 1: {
                        this.removeCallbacks(this.mWaitImageReset);
                    }
                    case 2: {
                        if (event.getPointerCount() <= 1) break;
                        this.startCheck(event);
                        return true;
                    }
                }
                break;
            }
            case 2: {
                switch (this.mState) {
                    case 1: {
                        if (!this.checkTouchMoved(event)) break;
                        this.removeCallbacks(this.mWaitImageReset);
                        this.setState(2);
                        return true;
                    }
                    case 2: {
                        if (!this.processDrag(event)) break;
                        return true;
                    }
                    case 3: {
                        if (!this.checkTouchMoved(event)) break;
                        this.startZoom(event);
                        return true;
                    }
                    case 4: {
                        if (!this.processZoom(event)) break;
                        return true;
                    }
                    case 5: {
                        if (!this.processRotate(event)) break;
                        return true;
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                this.removeCallbacks(this.mWaitImageReset);
                this.removeCallbacks(this.mStartCheckRotate);
                if (actionCode != 1 || this.mState != 1) ** GOTO lbl54
                downTime = SystemClock.uptimeMillis() - event.getDownTime();
                if (downTime <= (long)ZoomAspectScaledTextureView.LONG_PRESS_TIMEOUT) ** GOTO lbl51
                this.performLongClick();
                ** GOTO lbl54
lbl51:
                // 1 sources

                if (downTime < (long)ZoomAspectScaledTextureView.TAP_TIMEOUT) {
                    this.performClick();
                }
            }
lbl54:
            // 6 sources

            case 6: {
                this.setState(0);
            }
        }
        return super.onTouchEvent(event);
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        super.onSurfaceTextureAvailable(surface, width, height);
        this.setMirror(0);
    }

    @Override
    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        super.onSurfaceTextureSizeChanged(surface, width, height);
        this.applyMirrorMode();
    }

    @Override
    public void setMirror(int mirror) {
        if (this.mMirrorMode != mirror) {
            this.mMirrorMode = mirror;
            this.applyMirrorMode();
        }
    }

    public void setEnableHandleTouchEvent(boolean enabled) {
        this.mHandleTouchEvent = enabled;
    }

    public void reset() {
        this.init();
    }

    @Override
    protected void init() {
        this.mState = -1;
        this.setState(0);
        this.mMinScale = 0.8f;
        this.mCurrentDegrees = 0.0f;
        this.mIsRotating = Math.abs((float)((int)(this.mCurrentDegrees / 360.0f)) * 360.0f - this.mCurrentDegrees) > 0.1f;
        int view_width = this.getWidth();
        int view_height = this.getHeight();
        Rect tmp = new Rect();
        this.getDrawingRect(tmp);
        this.mLimitRect.set(tmp);
        this.mLimitRect.inset((float)((int)(0.2f * (float)view_width)), (float)((int)(0.2f * (float)view_height)));
        this.mLimitSegments[0] = null;
        this.mImageRect.set(0.0f, 0.0f, (float)tmp.width(), (float)tmp.height());
        super.init();
        this.mDefaultMatrix.set(this.mImageMatrix);
    }

    private final void setState(int state) {
        if (this.mState != state) {
            this.mState = state;
            this.getTransform(this.mSavedImageMatrix);
            if (!this.mImageMatrix.equals((Object)this.mSavedImageMatrix)) {
                this.mImageMatrix.set(this.mSavedImageMatrix);
                this.mImageMatrixChanged = true;
            }
        }
    }

    private final void startWaiting(MotionEvent event) {
        this.mPrimaryId = 0;
        this.mSecondaryId = -1;
        this.mPrimaryX = this.mSecondX = event.getX();
        this.mPrimaryY = this.mSecondY = event.getY();
        if (this.mWaitImageReset == null) {
            this.mWaitImageReset = new WaitImageReset();
        }
        this.postDelayed(this.mWaitImageReset, CHECK_TIMEOUT);
        this.setState(1);
    }

    private final boolean processDrag(MotionEvent event) {
        boolean canMove;
        float dx = event.getX() - this.mPrimaryX;
        float dy = event.getY() - this.mPrimaryY;
        this.mTrans[0] = this.mTrans[6] = this.mImageRect.left;
        this.mTrans[1] = this.mTrans[3] = this.mImageRect.top;
        this.mTrans[5] = this.mTrans[7] = this.mImageRect.bottom;
        this.mTrans[2] = this.mTrans[4] = this.mImageRect.right;
        this.mImageMatrix.mapPoints(this.mTrans);
        for (int i = 0; i < 8; i += 2) {
            int n = i;
            this.mTrans[n] = this.mTrans[n] + dx;
            int n2 = i + 1;
            this.mTrans[n2] = this.mTrans[n2] + dy;
        }
        boolean bl = canMove = this.mLimitRect.contains(this.mTrans[0], this.mTrans[1]) || this.mLimitRect.contains(this.mTrans[2], this.mTrans[3]) || this.mLimitRect.contains(this.mTrans[4], this.mTrans[5]) || this.mLimitRect.contains(this.mTrans[6], this.mTrans[7]) || ZoomAspectScaledTextureView.ptInPoly(this.mLimitRect.left, this.mLimitRect.top, this.mTrans) || ZoomAspectScaledTextureView.ptInPoly(this.mLimitRect.right, this.mLimitRect.top, this.mTrans) || ZoomAspectScaledTextureView.ptInPoly(this.mLimitRect.right, this.mLimitRect.bottom, this.mTrans) || ZoomAspectScaledTextureView.ptInPoly(this.mLimitRect.left, this.mLimitRect.bottom, this.mTrans);
        if (!canMove) {
            LineSegment side;
            if (this.mLimitSegments[0] == null) {
                this.mLimitSegments[0] = new LineSegment(this.mLimitRect.left, this.mLimitRect.top, this.mLimitRect.right, this.mLimitRect.top);
                this.mLimitSegments[1] = new LineSegment(this.mLimitRect.right, this.mLimitRect.top, this.mLimitRect.right, this.mLimitRect.bottom);
                this.mLimitSegments[2] = new LineSegment(this.mLimitRect.right, this.mLimitRect.bottom, this.mLimitRect.left, this.mLimitRect.bottom);
                this.mLimitSegments[3] = new LineSegment(this.mLimitRect.left, this.mLimitRect.bottom, this.mLimitRect.left, this.mLimitRect.top);
            }
            if (!(canMove = ZoomAspectScaledTextureView.checkIntersect(side = new LineSegment(this.mTrans[0], this.mTrans[1], this.mTrans[2], this.mTrans[3]), this.mLimitSegments))) {
                side.set(this.mTrans[2], this.mTrans[3], this.mTrans[4], this.mTrans[5]);
                canMove = ZoomAspectScaledTextureView.checkIntersect(side, this.mLimitSegments);
                if (!canMove) {
                    side.set(this.mTrans[4], this.mTrans[5], this.mTrans[6], this.mTrans[7]);
                    canMove = ZoomAspectScaledTextureView.checkIntersect(side, this.mLimitSegments);
                    if (!canMove) {
                        side.set(this.mTrans[6], this.mTrans[7], this.mTrans[0], this.mTrans[1]);
                        canMove = ZoomAspectScaledTextureView.checkIntersect(side, this.mLimitSegments);
                    }
                }
            }
        }
        if (canMove) {
            if (!this.mIsRotating) {
                float left = Math.min(Math.min(this.mTrans[0], this.mTrans[2]), Math.min(this.mTrans[4], this.mTrans[6]));
                float right = Math.max(Math.max(this.mTrans[0], this.mTrans[2]), Math.max(this.mTrans[4], this.mTrans[6]));
                float top = Math.min(Math.min(this.mTrans[1], this.mTrans[3]), Math.min(this.mTrans[5], this.mTrans[7]));
                float bottom = Math.max(Math.max(this.mTrans[1], this.mTrans[3]), Math.max(this.mTrans[5], this.mTrans[7]));
                if (right < this.mLimitRect.left) {
                    dx = this.mLimitRect.left - right;
                } else if (left + 0.1f > this.mLimitRect.right) {
                    dx = this.mLimitRect.right - left - 0.1f;
                }
                if (bottom < this.mLimitRect.top) {
                    dy = this.mLimitRect.top - bottom;
                } else if (top + 0.1f > this.mLimitRect.bottom) {
                    dy = this.mLimitRect.bottom - top - 0.1f;
                }
            }
            if ((dx != 0.0f || dy != 0.0f) && this.mImageMatrix.postTranslate(dx, dy)) {
                this.mImageMatrixChanged = true;
                this.setTransform(this.mImageMatrix);
            }
        }
        this.mPrimaryX = event.getX();
        this.mPrimaryY = event.getY();
        return canMove;
    }

    private final void startCheck(MotionEvent event) {
        if (event.getPointerCount() > 1) {
            this.mPrimaryId = event.getPointerId(0);
            this.mPrimaryX = event.getX(0);
            this.mPrimaryY = event.getY(0);
            this.mSecondaryId = event.getPointerId(1);
            this.mSecondX = event.getX(1);
            this.mSecondY = event.getY(1);
            float dx = this.mSecondX - this.mPrimaryX;
            float dy = this.mSecondY - this.mPrimaryY;
            float distance = (float)Math.hypot(dx, dy);
            if (distance < 15.0f) {
                return;
            }
            this.mTouchDistance = distance;
            this.mPivotX = (this.mPrimaryX + this.mSecondX) / 2.0f;
            this.mPivotY = (this.mPrimaryY + this.mSecondY) / 2.0f;
            if (this.mStartCheckRotate == null) {
                this.mStartCheckRotate = new StartCheckRotate();
            }
            this.postDelayed(this.mStartCheckRotate, CHECK_TIMEOUT);
            this.setState(3);
        }
    }

    private final void startZoom(MotionEvent event) {
        this.removeCallbacks(this.mStartCheckRotate);
        this.setState(4);
    }

    private final boolean processZoom(MotionEvent event) {
        this.restoreMatrix();
        float currentScale = this.getMatrixScale();
        float scale = this.calcScale(event);
        float tmpScale = scale * currentScale;
        if (tmpScale < this.mMinScale) {
            return false;
        }
        if (tmpScale > 8.0f) {
            return false;
        }
        if (this.mImageMatrix.postScale(scale, scale, this.mPivotX, this.mPivotY)) {
            this.mImageMatrixChanged = true;
            this.setTransform(this.mImageMatrix);
        }
        return true;
    }

    private final float calcScale(MotionEvent event) {
        float dx = event.getX(0) - event.getX(1);
        float dy = event.getY(0) - event.getY(1);
        float distance = (float)Math.hypot(dx, dy);
        return distance / this.mTouchDistance;
    }

    private final boolean checkTouchMoved(MotionEvent event) {
        float y;
        float x;
        boolean result = true;
        int ix0 = event.findPointerIndex(this.mPrimaryId);
        int ix1 = event.findPointerIndex(this.mSecondaryId);
        if (ix0 >= 0 && (x = event.getX(ix0) - this.mPrimaryX) * x + (y = event.getY(ix0) - this.mPrimaryY) * y < 225.0f) {
            if (ix1 >= 0) {
                x = event.getX(ix1) - this.mSecondX;
                if (x * x + (y = event.getY(ix1) - this.mSecondY) * y < 225.0f) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private final boolean processRotate(MotionEvent event) {
        if (this.checkTouchMoved(event)) {
            this.restoreMatrix();
            this.mCurrentDegrees = this.calcAngle(event);
            boolean bl = this.mIsRotating = Math.abs((float)((int)(this.mCurrentDegrees / 360.0f)) * 360.0f - this.mCurrentDegrees) > 0.1f;
            if (this.mIsRotating && this.mImageMatrix.postRotate(this.mCurrentDegrees, this.mPivotX, this.mPivotY)) {
                this.mImageMatrixChanged = true;
                this.setTransform(this.mImageMatrix);
                return true;
            }
        }
        return false;
    }

    private final float calcAngle(MotionEvent event) {
        int ix0 = event.findPointerIndex(this.mPrimaryId);
        int ix1 = event.findPointerIndex(this.mSecondaryId);
        float angle = 0.0f;
        if (ix0 >= 0 && ix1 >= 0) {
            float x0 = this.mSecondX - this.mPrimaryX;
            float y0 = this.mSecondY - this.mPrimaryY;
            float x1 = event.getX(ix1) - event.getX(ix0);
            float y1 = event.getY(ix1) - event.getY(ix0);
            double s = (x0 * x0 + y0 * y0) * (x1 * x1 + y1 * y1);
            double cos = (double)ZoomAspectScaledTextureView.dotProduct(x0, y0, x1, y1) / Math.sqrt(s);
            angle = 57.29578f * (float)Math.acos(cos) * Math.signum(ZoomAspectScaledTextureView.crossProduct(x0, y0, x1, y1));
        }
        return angle;
    }

    private static final float dotProduct(float x0, float y0, float x1, float y1) {
        return x0 * x1 + y0 * y1;
    }

    private static final float crossProduct(float x0, float y0, float x1, float y1) {
        return x0 * y1 - x1 * y0;
    }

    private static final float crossProduct(Vector v1, Vector v2) {
        return v1.x * v2.y - v2.x * v1.y;
    }

    private static final boolean ptInPoly(float x, float y, float[] poly) {
        int n = poly.length & Integer.MAX_VALUE;
        if (n < 6) {
            return false;
        }
        boolean result = true;
        Vector v1 = new Vector();
        Vector v2 = new Vector();
        for (int i = 0; i < n; i += 2) {
            v1.set(x, y).dec(poly[i], poly[i + 1]);
            if (i + 2 < n) {
                v2.set(poly[i + 2], poly[i + 3]);
            } else {
                v2.set(poly[0], poly[1]);
            }
            v2.dec(poly[i], poly[i + 1]);
            if (!(ZoomAspectScaledTextureView.crossProduct(v1, v2) > 0.0f)) continue;
            result = false;
            break;
        }
        return result;
    }

    private static final boolean checkIntersect(LineSegment seg, LineSegment[] segs) {
        boolean result = false;
        int n = segs != null ? segs.length : 0;
        Vector a = seg.p2.sub(seg.p1);
        for (int i = 0; i < n; ++i) {
            Vector c = segs[i].p1.sub(seg.p1);
            Vector d = segs[i].p2.sub(seg.p1);
            boolean bl = result = ZoomAspectScaledTextureView.crossProduct(a, c) * ZoomAspectScaledTextureView.crossProduct(a, d) < 0.1f;
            if (!result) continue;
            Vector b = segs[i].p2.sub(segs[i].p1);
            c = seg.p1.sub(segs[i].p1);
            d = seg.p2.sub(segs[i].p1);
            boolean bl2 = result = ZoomAspectScaledTextureView.crossProduct(b, c) * ZoomAspectScaledTextureView.crossProduct(b, d) < 0.1f;
            if (result) break;
        }
        return result;
    }

    private final float getMatrixScale() {
        this.updateMatrixCache();
        float scale = Math.min(this.mMatrixCache[0], this.mMatrixCache[0]);
        if (scale <= 0.0f) {
            return 1.0f;
        }
        return scale;
    }

    private final void restoreMatrix() {
        this.mImageMatrix.set(this.mSavedImageMatrix);
        this.mImageMatrixChanged = true;
    }

    private final boolean updateMatrixCache() {
        if (this.mImageMatrixChanged) {
            this.mImageMatrix.getValues(this.mMatrixCache);
            this.mImageMatrixChanged = false;
            return true;
        }
        return false;
    }

    private void applyMirrorMode() {
        switch (this.mMirrorMode) {
            case 1: {
                this.setScaleX(-1.0f);
                this.setScaleY(1.0f);
                break;
            }
            case 2: {
                this.setScaleX(1.0f);
                this.setScaleY(-1.0f);
                break;
            }
            case 3: {
                this.setScaleX(-1.0f);
                this.setScaleY(-1.0f);
                break;
            }
            default: {
                this.setScaleX(1.0f);
                this.setScaleY(1.0f);
            }
        }
    }

    private final class StartCheckRotate
    implements Runnable {
        private StartCheckRotate() {
        }

        @Override
        public void run() {
            if (ZoomAspectScaledTextureView.this.mState == 3) {
                ZoomAspectScaledTextureView.this.setState(5);
            }
        }
    }

    private final class WaitImageReset
    implements Runnable {
        private WaitImageReset() {
        }

        @Override
        public void run() {
            ZoomAspectScaledTextureView.this.init();
        }
    }

    private static final class LineSegment {
        public final Vector p1;
        public final Vector p2;

        public LineSegment(float x0, float y0, float x1, float y1) {
            this.p1 = new Vector(x0, y0);
            this.p2 = new Vector(x1, y1);
        }

        public LineSegment set(float x0, float y0, float x1, float y1) {
            this.p1.set(x0, y0);
            this.p2.set(x1, y1);
            return this;
        }
    }

    private static final class Vector {
        public float x;
        public float y;

        public Vector() {
        }

        public Vector(float x, float y) {
            this.set(x, y);
        }

        public Vector set(float x, float y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Vector sub(Vector other) {
            return new Vector(this.x - other.x, this.y - other.y);
        }

        public Vector dec(float x, float y) {
            this.x -= x;
            this.y -= y;
            return this;
        }
    }
}

