/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.serenegiant.common.R;
import com.serenegiant.widget.Dividable;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    public static final int HORIZONTAL_LIST = 0;
    public static final int VERTICAL_LIST = 1;
    private static final int[] ATTRS = new int[]{16843284};
    private Drawable mDivider;
    private int mOrientation = 1;

    public DividerItemDecoration(Context context) {
        Drawable divider = null;
        TypedArray a = context.obtainStyledAttributes(ATTRS);
        try {
            divider = a.getDrawable(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.recycle();
        this.init(divider);
    }

    public DividerItemDecoration(Context context, @DrawableRes int divider) {
        this.init(context.getResources().getDrawable(divider));
    }

    public DividerItemDecoration(Context context, Drawable divider) {
        this.init(divider);
    }

    private void init(Drawable divider) {
        this.mDivider = divider;
    }

    public void onDraw(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        if (this.mDivider == null) {
            return;
        }
        if (this.mOrientation == 1) {
            this.drawVertical(canvas, parent);
        } else {
            this.drawHorizontal(canvas, parent);
        }
    }

    protected void drawVertical(Canvas canvas, RecyclerView parent) {
        RecyclerView.LayoutManager manager = parent.getLayoutManager();
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount() - 1;
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            if (!this.hasDivider(child)) continue;
            int top = child.getBottom();
            int bottom = top + this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(canvas);
        }
    }

    protected void drawHorizontal(Canvas canvas, RecyclerView parent) {
        RecyclerView.LayoutManager manager = parent.getLayoutManager();
        int top = parent.getPaddingTop();
        int bottom = parent.getHeight() - parent.getPaddingBottom();
        int childCount = parent.getChildCount() - 1;
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            if (!this.hasDivider(child)) continue;
            int left = child.getLeft();
            int right = left + this.mDivider.getIntrinsicWidth();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(canvas);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        if (this.mDivider == null) {
            outRect.set(0, 0, 0, 0);
        } else if (this.hasDivider(view)) {
            if (this.mOrientation == 1) {
                outRect.set(0, 0, 0, this.mDivider.getIntrinsicHeight());
            } else {
                outRect.set(0, 0, this.mDivider.getIntrinsicWidth(), 0);
            }
        } else {
            outRect.set(0, 0, 0, 0);
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("invalid orientation");
        }
        this.mOrientation = orientation;
    }

    protected boolean hasDivider(View view) {
        if (view instanceof Dividable) {
            return ((Dividable)view).hasDivider();
        }
        Boolean b = (Boolean)view.getTag(R.id.has_divider);
        return b != null && b != false;
    }
}

