/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.serenegiant.utils.SDUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;

public class FileUtils {
    private static final String TAG = FileUtils.class.getSimpleName();
    public static String DIR_NAME = "UsbWebCamera";
    private static final SimpleDateFormat mDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.US);
    public static float FREE_RATIO = 0.03f;
    public static float FREE_SIZE_OFFSET = 2.097152E7f;
    public static float FREE_SIZE = 3.145728E8f;
    public static float FREE_SIZE_MINUTE = 4.194304E7f;
    public static long CHECK_INTERVAL = 45000L;

    public static final File getCaptureFile(Context context, String type, String ext, int save_tree_id) {
        return FileUtils.getCaptureFile(context, type, null, ext, save_tree_id);
    }

    public static final File getCaptureFile(Context context, String type, String prefix, String ext, int save_tree_id) {
        File dir;
        File result = null;
        String file_name = (TextUtils.isEmpty((CharSequence)prefix) ? FileUtils.getDateTimeString() : prefix + FileUtils.getDateTimeString()) + ext;
        if (save_tree_id > 0 && SDUtils.hasStorageAccess(context, save_tree_id) && ((result = SDUtils.createStorageDir(context, save_tree_id)) == null || !result.canWrite())) {
            Log.w((String)TAG, (String)"\u306a\u3093\u3067\u304b\u66f8\u304d\u8fbc\u3081\u3093");
            result = null;
        }
        if (result == null && (dir = FileUtils.getCaptureDir(context, type, 0)) != null) {
            dir.mkdirs();
            if (dir.canWrite()) {
                result = dir;
            }
        }
        if (result != null) {
            result = new File(result, file_name);
        }
        return result;
    }

    @SuppressLint(value={"NewApi"})
    public static final File getCaptureDir(Context context, String type, int save_tree_id) {
        File result = null;
        if (save_tree_id > 0 && SDUtils.hasStorageAccess(context, save_tree_id)) {
            result = SDUtils.createStorageDir(context, save_tree_id);
        }
        File dir = result != null ? result : new File(Environment.getExternalStoragePublicDirectory((String)type), DIR_NAME);
        dir.mkdirs();
        if (dir.canWrite()) {
            return dir;
        }
        return null;
    }

    public static final String getDateTimeString() {
        GregorianCalendar now = new GregorianCalendar();
        return mDateTimeFormat.format(now.getTime());
    }

    public static String getExternalMounts() {
        String externalpath = null;
        String internalpath = "";
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            Process proc = runtime.exec("mount");
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = br.readLine()) != null) {
                String[] columns;
                if (line.contains("secure") || line.contains("asec")) continue;
                if (line.contains("fat")) {
                    columns = line.split(" ");
                    if (columns == null || columns.length <= 1 || TextUtils.isEmpty((CharSequence)columns[1]) || (externalpath = columns[1]).endsWith("/")) continue;
                    externalpath = externalpath + "/";
                    continue;
                }
                if (!line.contains("fuse") || (columns = line.split(" ")) == null || columns.length <= 1) continue;
                internalpath = internalpath.concat("[" + columns[1] + "]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return externalpath;
    }

    public static final boolean checkFreeSpace(Context context, long max_duration, long start_time, int save_tree_id) {
        if (context == null) {
            return false;
        }
        return FileUtils.checkFreeSpace(context, FREE_RATIO, max_duration > 0L ? (float)(max_duration - (System.currentTimeMillis() - start_time)) / 60000.0f * FREE_SIZE_MINUTE + FREE_SIZE_OFFSET : FREE_SIZE, save_tree_id);
    }

    public static final boolean checkFreeSpace(Context context, float ratio, float minFree, int save_tree_id) {
        if (context == null) {
            return false;
        }
        boolean result = false;
        try {
            File dir = FileUtils.getCaptureDir(context, Environment.DIRECTORY_DCIM, save_tree_id);
            if (dir != null) {
                float freeSpace;
                float f = freeSpace = dir.canWrite() ? (float)dir.getUsableSpace() : 0.0f;
                if (dir.getTotalSpace() > 0L) {
                    result = freeSpace / (float)dir.getTotalSpace() > ratio || freeSpace > minFree;
                }
            }
        }
        catch (Exception e) {
            Log.w((String)"checkFreeSpace:", (Throwable)e);
        }
        return result;
    }

    public static final long getAvailableFreeSpace(Context context, String type, int save_tree_id) {
        File dir;
        long result = 0L;
        if (context != null && (dir = FileUtils.getCaptureDir(context, type, save_tree_id)) != null) {
            result = dir.canWrite() ? dir.getUsableSpace() : 0L;
        }
        return result;
    }

    public static final float getFreeRatio(Context context, String type, int save_tree_id) {
        File dir;
        if (context != null && (dir = FileUtils.getCaptureDir(context, type, save_tree_id)) != null) {
            float freeSpace;
            float f = freeSpace = dir.canWrite() ? (float)dir.getUsableSpace() : 0.0f;
            if (dir.getTotalSpace() > 0L) {
                return freeSpace / (float)dir.getTotalSpace();
            }
        }
        return 0.0f;
    }

    public static final String removeFileExtension(String path) {
        int ix;
        int n = ix = !TextUtils.isEmpty((CharSequence)path) ? path.lastIndexOf(".") : -1;
        if (ix > 0) {
            return path.substring(0, ix);
        }
        return path;
    }
}

