/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

public final class BitsHelper {
    public static int countBits(byte v) {
        int count = (v & 0x55) + (v >>> 1 & 0x55);
        count = (count & 0x33) + (count >>> 2 & 0x33);
        return (count & 0xF) + (count >>> 4 & 0xF);
    }

    public static int countBits(short v) {
        int count = (v & 0x5555) + (v >>> 1 & 0x5555);
        count = (count & 0x3333) + (count >>> 2 & 0x3333);
        count = (count & 0xF0F) + (count >>> 4 & 0xF0F);
        return (count & 0xFF) + (count >>> 8 & 0xFF);
    }

    public static int countBits(int v) {
        int count = (v & 0x55555555) + (v >>> 1 & 0x55555555);
        count = (count & 0x33333333) + (count >>> 2 & 0x33333333);
        count = (count & 0xF0F0F0F) + (count >>> 4 & 0xF0F0F0F);
        count = (count & 0xFF00FF) + (count >>> 8 & 0xFF00FF);
        return (count & 0xFFFF) + (count >>> 16 & 0xFFFF);
    }

    public static int countBits(long v) {
        long count = (v & 0x5555555555555555L) + (v >>> 1 & 0x5555555555555555L);
        count = (count & 0x3333333333333333L) + (count >>> 2 & 0x3333333333333333L);
        count = (count & 0xF0F0F0F0F0F0F0FL) + (count >>> 4 & 0xF0F0F0F0F0F0F0FL);
        count = (count & 0xFF00FF00FF00FFL) + (count >>> 8 & 0xFF00FF00FF00FFL);
        count = (count & 0xFFFF0000FFFFL) + (count >>> 16 & 0xFFFF0000FFFFL);
        return (int)((count & 0xFFFFFFFFL) + (count >>> 32 & 0xFFFFFFFFL));
    }

    public static int MSB(byte v) {
        if (v == 0) {
            return 0;
        }
        v = (byte)(v | v >>> 1);
        v = (byte)(v | v >>> 2);
        v = (byte)(v | v >>> 4);
        return BitsHelper.countBits(v) - 1;
    }

    public static int MSB(short v) {
        if (v == 0) {
            return 0;
        }
        v = (short)(v | v >>> 1);
        v = (short)(v | v >>> 2);
        v = (short)(v | v >>> 4);
        v = (short)(v | v >>> 8);
        return BitsHelper.countBits(v) - 1;
    }

    public static int MSB(int v) {
        if (v == 0) {
            return 0;
        }
        v |= v >>> 1;
        v |= v >>> 2;
        v |= v >>> 4;
        v |= v >>> 8;
        v |= v >>> 16;
        return BitsHelper.countBits(v) - 1;
    }

    public static int MSB(long v) {
        if (v == 0L) {
            return 0;
        }
        v |= v >>> 1;
        v |= v >>> 2;
        v |= v >>> 4;
        v |= v >>> 8;
        v |= v >>> 16;
        v |= v >>> 32;
        return BitsHelper.countBits(v) - 1;
    }

    public static int LSB(byte v) {
        if (v == 0) {
            return 0;
        }
        v = (byte)(v | v << 1);
        v = (byte)(v | v << 2);
        v = (byte)(v | v << 4);
        return 8 - BitsHelper.countBits(v);
    }

    public static int LSB(short v) {
        if (v == 0) {
            return 0;
        }
        v = (short)(v | v << 1);
        v = (short)(v | v << 2);
        v = (short)(v | v << 4);
        v = (short)(v | v << 8);
        return 16 - BitsHelper.countBits(v);
    }

    public static int LSB(int v) {
        if (v == 0) {
            return 0;
        }
        v |= v << 1;
        v |= v << 2;
        v |= v << 4;
        v |= v << 8;
        v |= v << 16;
        return 32 - BitsHelper.countBits(v);
    }

    public static int LSB(long v) {
        if (v == 0L) {
            return 0;
        }
        v |= v << 1;
        v |= v << 2;
        v |= v << 4;
        v |= v << 8;
        v |= v << 16;
        v |= v << 32;
        return 64 - BitsHelper.countBits(v);
    }

    public static int squareBits(byte v) {
        if (v == 0) {
            return 0;
        }
        return 1 << BitsHelper.MSB(v - 1) + 1;
    }

    public static int squareBits(short v) {
        if (v == 0) {
            return 0;
        }
        return 1 << BitsHelper.MSB(v - 1) + 1;
    }

    public static int squareBits(int v) {
        if (v == 0) {
            return 0;
        }
        return 1 << BitsHelper.MSB(v - 1) + 1;
    }

    public static int squareBits(long v) {
        if (v == 0L) {
            return 0;
        }
        return 1 << BitsHelper.MSB(v - 1L) + 1;
    }
}

