/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.net;

import android.util.Log;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class NetworkHelper {
    private static final String TAG = NetworkHelper.class.getSimpleName();

    public static String getLocalIPv4Address() {
        try {
            Enumeration<NetworkInterface> networkInterfaceEnum = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnum.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnum.nextElement();
                Enumeration<InetAddress> ipAddressEnum = networkInterface.getInetAddresses();
                while (ipAddressEnum.hasMoreElements()) {
                    InetAddress addr = ipAddressEnum.nextElement();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            Log.e((String)TAG, (String)"getLocalIPv4Address", (Throwable)e);
        }
        return null;
    }

    public static String getLocalIPv6Address() {
        try {
            Enumeration<NetworkInterface> networkInterfaceEnum = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnum.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnum.nextElement();
                Enumeration<InetAddress> ipAddressEnum = networkInterface.getInetAddresses();
                while (ipAddressEnum.hasMoreElements()) {
                    InetAddress addr = ipAddressEnum.nextElement();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet6Address)) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            Log.w((String)TAG, (String)"getLocalIPv6Address", (Throwable)e);
        }
        return null;
    }
}

