/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import com.serenegiant.media.IMediaCodecCallback;
import com.serenegiant.media.MediaEncoder;
import com.serenegiant.media.MediaMovieRecorder;
import java.io.IOException;
import java.util.Locale;

@TargetApi(value=18)
public class MediaVideoEncoder
extends MediaEncoder {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaEncoder";
    private static final String MIME_TYPE = "video/avc";
    private static final int FRAME_RATE = 25;
    private static final float BPP = 0.25f;
    private Surface mSurface;
    private int mVideoWidth = 1280;
    private int mVideoHeight = 720;
    protected static int[] recognizedFormats = new int[]{2130708361};

    public MediaVideoEncoder(MediaMovieRecorder muxer, IMediaCodecCallback listener) {
        this(1280, 720, muxer, listener);
    }

    public MediaVideoEncoder(int width, int height, MediaMovieRecorder muxer, IMediaCodecCallback listener) {
        super(false, muxer, listener);
        this.mVideoWidth = width;
        this.mVideoHeight = height;
    }

    @Override
    public void prepare() throws IOException {
        this.mTrackIndex = -1;
        this.mIsEOS = false;
        this.mMuxerStarted = false;
        MediaCodecInfo videoCodecInfo = MediaVideoEncoder.selectVideoCodec(MIME_TYPE);
        if (videoCodecInfo == null) {
            Log.e((String)TAG, (String)"Unable to find an appropriate codec for video/avc");
            return;
        }
        MediaFormat format = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)this.mVideoWidth, (int)this.mVideoHeight);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", this.calcBitRate());
        format.setInteger("frame-rate", 25);
        format.setInteger("i-frame-interval", 10);
        this.mMediaCodec = MediaCodec.createEncoderByType((String)MIME_TYPE);
        this.mMediaCodec.configure(format, null, null, 1);
        this.mSurface = this.mMediaCodec.createInputSurface();
        this.mMediaCodec.start();
        this.mIsPrepared = true;
        this.callOnPrepared();
    }

    @Override
    public void release() {
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        super.release();
    }

    public void setVideoSize(int width, int height) throws IllegalArgumentException, IllegalStateException {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException(String.format(Locale.US, "size(%d,%d)", width, height));
        }
        if (this.isRunning()) {
            throw new IllegalStateException("already start capturing");
        }
        this.mVideoWidth = width;
        this.mVideoHeight = height;
    }

    public Surface getInputSurface() throws IllegalStateException {
        if (this.mSurface == null) {
            throw new IllegalStateException("not prepared yet");
        }
        return this.mSurface;
    }

    public int getWidth() {
        return this.mVideoWidth;
    }

    public int getHeight() {
        return this.mVideoHeight;
    }

    private int calcBitRate() {
        int bitrate = (int)(6.25f * (float)this.mVideoWidth * (float)this.mVideoHeight);
        Log.i((String)TAG, (String)String.format("bitrate=%5.2f[Mbps]", Float.valueOf((float)bitrate / 1024.0f / 1024.0f)));
        return bitrate;
    }

    protected static final MediaCodecInfo selectVideoCodec(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                int format;
                if (!types[j].equalsIgnoreCase(mimeType) || (format = MediaVideoEncoder.selectColorFormat(codecInfo, mimeType)) <= 0) continue;
                return codecInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final int selectColorFormat(MediaCodecInfo codecInfo, String mimeType) {
        MediaCodecInfo.CodecCapabilities caps;
        int result = 0;
        try {
            Thread.currentThread().setPriority(10);
            caps = codecInfo.getCapabilitiesForType(mimeType);
        }
        finally {
            Thread.currentThread().setPriority(5);
        }
        for (int i = 0; i < caps.colorFormats.length; ++i) {
            int colorFormat = caps.colorFormats[i];
            if (!MediaVideoEncoder.isRecognizedViewFormat(colorFormat)) continue;
            result = colorFormat;
            break;
        }
        if (result == 0) {
            Log.e((String)TAG, (String)("couldn't find a good color format for " + codecInfo.getName() + " / " + mimeType));
        }
        return result;
    }

    private static final boolean isRecognizedViewFormat(int colorFormat) {
        int n = recognizedFormats != null ? recognizedFormats.length : 0;
        for (int i = 0; i < n; ++i) {
            if (recognizedFormats[i] != colorFormat) continue;
            return true;
        }
        return false;
    }
}

