/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import com.serenegiant.media.IMuxer;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=18)
public class MediaMuxerWrapper
implements IMuxer {
    private final MediaMuxer mMuxer;
    private volatile boolean mIsStarted;

    public MediaMuxerWrapper(String output_path, int format) throws IOException {
        this.mMuxer = new MediaMuxer(output_path, format);
    }

    @Override
    public int addTrack(MediaFormat format) {
        return this.mMuxer.addTrack(format);
    }

    @Override
    public void writeSampleData(int trackIndex, ByteBuffer byteBuf, MediaCodec.BufferInfo bufferInfo) {
        this.mMuxer.writeSampleData(trackIndex, byteBuf, bufferInfo);
    }

    @Override
    public void start() {
        this.mMuxer.start();
        this.mIsStarted = true;
    }

    @Override
    public void stop() {
        this.mIsStarted = false;
        this.mMuxer.stop();
    }

    @Override
    public void release() {
        this.mIsStarted = false;
        this.mMuxer.release();
    }

    @Override
    public boolean isStarted() {
        return this.mIsStarted;
    }
}

