/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Bundle;
import android.view.Surface;
import com.serenegiant.media.AbstractEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.VideoConfig;
import com.serenegiant.utils.BuildCheck;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@TargetApi(value=16)
public abstract class AbstractVideoEncoder
extends AbstractEncoder {
    public static final String MIME_AVC = "video/avc";
    public static final int OMX_COLOR_FormatUnused = 0;
    public static final int OMX_COLOR_FormatMonochrome = 1;
    public static final int OMX_COLOR_Format8bitRGB332 = 2;
    public static final int OMX_COLOR_Format12bitRGB444 = 3;
    public static final int OMX_COLOR_Format16bitARGB4444 = 4;
    public static final int OMX_COLOR_Format16bitARGB1555 = 5;
    public static final int OMX_COLOR_Format16bitRGB565 = 6;
    public static final int OMX_COLOR_Format16bitBGR565 = 7;
    public static final int OMX_COLOR_Format18bitRGB666 = 8;
    public static final int OMX_COLOR_Format18bitARGB1665 = 9;
    public static final int OMX_COLOR_Format19bitARGB1666 = 10;
    public static final int OMX_COLOR_Format24bitRGB888 = 11;
    public static final int OMX_COLOR_Format24bitBGR888 = 12;
    public static final int OMX_COLOR_Format24bitARGB1887 = 13;
    public static final int OMX_COLOR_Format25bitARGB1888 = 14;
    public static final int OMX_COLOR_Format32bitBGRA8888 = 15;
    public static final int OMX_COLOR_Format32bitARGB8888 = 16;
    public static final int OMX_COLOR_FormatYUV411Planar = 17;
    public static final int OMX_COLOR_FormatYUV411PackedPlanar = 18;
    public static final int OMX_COLOR_FormatYUV420Planar = 19;
    public static final int OMX_COLOR_FormatYUV420PackedPlanar = 20;
    public static final int OMX_COLOR_FormatYUV420SemiPlanar = 21;
    public static final int OMX_COLOR_FormatYUV422Planar = 22;
    public static final int OMX_COLOR_FormatYUV422PackedPlanar = 23;
    public static final int OMX_COLOR_FormatYUV422SemiPlanar = 24;
    public static final int OMX_COLOR_FormatYCbYCr = 25;
    public static final int OMX_COLOR_FormatYCrYCb = 26;
    public static final int OMX_COLOR_FormatCbYCrY = 27;
    public static final int OMX_COLOR_FormatCrYCbY = 28;
    public static final int OMX_COLOR_FormatYUV444Interleaved = 29;
    public static final int OMX_COLOR_FormatRawBayer8bit = 30;
    public static final int OMX_COLOR_FormatRawBayer10bit = 31;
    public static final int OMX_COLOR_FormatRawBayer8bitcompressed = 32;
    public static final int OMX_COLOR_FormatL2 = 33;
    public static final int OMX_COLOR_FormatL4 = 34;
    public static final int OMX_COLOR_FormatL8 = 35;
    public static final int OMX_COLOR_FormatL16 = 36;
    public static final int OMX_COLOR_FormatL24 = 37;
    public static final int OMX_COLOR_FormatL32 = 38;
    public static final int OMX_COLOR_FormatYUV420PackedSemiPlanar = 39;
    public static final int OMX_COLOR_FormatYUV422PackedSemiPlanar = 40;
    public static final int OMX_COLOR_Format18BitBGR666 = 41;
    public static final int OMX_COLOR_Format24BitARGB6666 = 42;
    public static final int OMX_COLOR_Format24BitABGR6666 = 43;
    public static final int OMX_COLOR_FormatKhronosExtensions = 0x6F000000;
    public static final int OMX_COLOR_FormatVendorStartUnused = 0x7F000000;
    public static final int OMX_COLOR_FormatAndroidOpaque = 2130708361;
    public static final int OMX_TI_COLOR_FormatYUV420PackedSemiPlanar = 2130706688;
    public static final int OMX_QCOM_COLOR_FormatYVU420SemiPlanar = 2141391872;
    public static final int OMX_QCOM_COLOR_FormatYUV420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    public static final int OMX_SEC_COLOR_FormatNV12Tiled = 2143289346;
    public static final int OMX_QCOM_COLOR_FormatYUV420PackedSemiPlanar32m = 2141391876;
    public static final int OMX_COLOR_FormatMax = Integer.MAX_VALUE;
    protected int mColorFormat;
    protected int mWidth;
    protected int mHeight;
    protected int mBitRate = -1;
    protected int mFramerate = -1;
    protected int mIFrameIntervals = -1;
    public static int[] recognizedFormats = new int[]{19, 21, 2141391872};
    public static boolean supportsAdaptiveStreaming = BuildCheck.isKitKat();

    public AbstractVideoEncoder(String mime, IRecorder recorder, EncoderListener listener) {
        super(mime, recorder, listener);
    }

    public void setVideoSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mBitRate = VideoConfig.getBitrate(width, height);
    }

    public void setVideoConfig(int bitRate, int frameRate, int iFrameIntervals) {
        this.mBitRate = bitRate;
        this.mFramerate = frameRate;
        this.mIFrameIntervals = iFrameIntervals;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public abstract int getCaptureFormat();

    public abstract Surface getInputSurface();

    public final MediaCodecInfo selectVideoCodec(String mimeType) {
        int numCodecs = AbstractVideoEncoder.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = AbstractVideoEncoder.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            int n = types.length;
            for (int j = 0; j < n; ++j) {
                int format;
                if (!types[j].equalsIgnoreCase(mimeType) || (format = AbstractVideoEncoder.selectColorFormat(codecInfo, mimeType)) <= 0) continue;
                this.mColorFormat = format;
                return codecInfo;
            }
        }
        return null;
    }

    @Override
    public final boolean isAudio() {
        return false;
    }

    @TargetApi(value=19)
    public void adjustBitrate(int targetBitrate) {
        if (supportsAdaptiveStreaming && this.mMediaCodec != null) {
            Bundle bitrate = new Bundle();
            bitrate.putInt("video-bitrate", targetBitrate);
            this.mMediaCodec.setParameters(bitrate);
        } else if (!supportsAdaptiveStreaming) {
            // empty if block
        }
    }

    @Override
    protected MediaFormat createOutputFormat(byte[] csd, int size, int ix0, int ix1) {
        MediaFormat outFormat;
        if (ix0 >= 0) {
            outFormat = MediaFormat.createVideoFormat((String)this.MIME_TYPE, (int)this.mWidth, (int)this.mHeight);
            ByteBuffer csd0 = ByteBuffer.allocateDirect(ix1 - ix0).order(ByteOrder.nativeOrder());
            csd0.put(csd, ix0, ix1 - ix0);
            csd0.flip();
            outFormat.setByteBuffer("csd-0", csd0);
            if (ix1 > ix0) {
                ByteBuffer csd1 = ByteBuffer.allocateDirect(size - ix1 + ix0).order(ByteOrder.nativeOrder());
                csd1.put(csd, ix1, size - ix1 + ix0);
                csd1.flip();
                outFormat.setByteBuffer("csd-1", csd1);
            }
        } else {
            throw new RuntimeException("unexpected csd data came.");
        }
        return outFormat;
    }

    private static final boolean isRecognizedVideoFormat(int colorFormat) {
        int n = recognizedFormats != null ? recognizedFormats.length : 0;
        for (int i = 0; i < n; ++i) {
            if (recognizedFormats[i] != colorFormat) continue;
            return true;
        }
        return false;
    }

    private static final int selectColorFormat(MediaCodecInfo codecInfo, String mimeType) {
        int result = 0;
        MediaCodecInfo.CodecCapabilities capabilities = AbstractVideoEncoder.getCodecCapabilities(codecInfo, mimeType);
        for (int colorFormat : capabilities.colorFormats) {
            if (!AbstractVideoEncoder.isRecognizedVideoFormat(colorFormat)) continue;
            result = colorFormat;
            break;
        }
        return result;
    }

    public static final void dumpVideoCodecEncoders() {
        int numCodecs = AbstractVideoEncoder.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = AbstractVideoEncoder.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                AbstractVideoEncoder.selectColorFormat(codecInfo, types[j]);
            }
        }
    }

    protected static final boolean isSemiPlanarYUV(int colorFormat) {
        switch (colorFormat) {
            case 19: 
            case 20: {
                return false;
            }
            case 21: 
            case 39: 
            case 2130706688: 
            case 2141391872: {
                return true;
            }
        }
        throw new RuntimeException("unknown format " + colorFormat);
    }
}

