/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import android.widget.Toast;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.visual.R;
import com.sensorsdata.analytics.android.sdk.visual.view.IPairingCodeInterface;
import com.sensorsdata.analytics.android.sdk.visual.view.PairingCodeEditText;
import com.sensorsdata.analytics.android.sdk.visual.view.PairingCodeRequestHelper;

public class PairingCodeEditDialog
extends Dialog {
    private static final String TAG = "SA.PairingCodeEditDialog";
    private Context mContext;

    public PairingCodeEditDialog(Context context) {
        super(context);
        this.mContext = context;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.sensors_analytics_verification_code);
        Window window = this.getWindow();
        if (window != null) {
            WindowManager.LayoutParams p = window.getAttributes();
            p.width = this.dip2px(this.getContext(), 350.0f);
            window.setAttributes(p);
            GradientDrawable bg = new GradientDrawable();
            bg.setShape(0);
            bg.setColor(-1);
            bg.setCornerRadius((float)this.dip2px(this.getContext(), 7.0f));
            window.setBackgroundDrawable((Drawable)bg);
            window.setSoftInputMode(4);
        }
        TextView titleView = (TextView)this.findViewById(R.id.sensors_analytics_verification_code_title);
        titleView.setText(R.string.sensors_analytics_visual_code_title);
        final PairingCodeEditText pairingCodeEditText = (PairingCodeEditText)this.findViewById(R.id.sensors_analytics_pairing_code);
        pairingCodeEditText.setOnPairingCodeChangedListener(new IPairingCodeInterface.OnPairingCodeChangedListener(){

            @Override
            public void onPairingCodeChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void onInputCompleted(CharSequence s) {
                if (TextUtils.isEmpty((CharSequence)s)) {
                    SALog.i((String)PairingCodeEditDialog.TAG, (String)"onCreate | dialog input content is null and return");
                    return;
                }
                new PairingCodeRequestHelper().verifyPairingCodeRequest(PairingCodeEditDialog.this.mContext, s.toString(), new PairingCodeRequestHelper.IApiCallback(){

                    @Override
                    public void onSuccess() {
                        pairingCodeEditText.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                pairingCodeEditText.hiddenKeyBord();
                                PairingCodeEditDialog.this.dismiss();
                            }
                        }, 300L);
                    }

                    @Override
                    public void onFailure(String message) {
                        pairingCodeEditText.clearText();
                        if (!TextUtils.isEmpty((CharSequence)message)) {
                            Toast.makeText((Context)PairingCodeEditDialog.this.mContext, (CharSequence)message, (int)1).show();
                        }
                    }
                });
            }
        });
    }

    public void show() {
        if (!this.isLiving()) {
            SALog.i((String)TAG, (String)"Activity is finish");
        } else {
            SALog.i((String)TAG, (String)("show:" + this.mContext));
            super.show();
        }
    }

    public void dismiss() {
        if (Looper.myLooper() != Looper.getMainLooper() && this.mContext instanceof Activity && this.isActivityFinishingOrDestroyed(this.mContext)) {
            SALog.i((String)TAG, (String)"Activity is finish");
        } else if (this.isShowing()) {
            try {
                SALog.i((String)TAG, (String)"isShowing() == true, dismiss");
                super.dismiss();
            }
            catch (IllegalArgumentException e) {
                SALog.printStackTrace((Exception)e);
            }
        }
    }

    private boolean isLiving() {
        if (this.mContext == null) {
            return false;
        }
        return !(this.mContext instanceof Activity) || !this.isActivityFinishingOrDestroyed(this.mContext);
    }

    private boolean isActivityFinishingOrDestroyed(Context context) {
        Activity activity = (Activity)context;
        if (activity.isFinishing()) {
            SALog.i((String)TAG, (String)("Activity is finish,name=" + activity.getClass().getName()));
            return true;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            return activity.isDestroyed();
        }
        return false;
    }

    private int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

