/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.utils;

import android.content.Context;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import com.sensorsdata.analytics.android.sdk.visual.NodesProcess;
import com.sensorsdata.analytics.android.sdk.visual.R;
import com.sensorsdata.analytics.android.sdk.visual.model.NodeInfo;
import com.sensorsdata.analytics.android.sdk.visual.model.SnapInfo;
import com.sensorsdata.analytics.android.sdk.visual.model.WebNodeInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class AlertMessageUtils {
    private static final String TAG = "SA.AlertMessageUtils";

    private static void flutterAlertHandlerFailure(String mActivityName) {
        SALog.i((String)TAG, (String)"Flutter page is not integrated SDK");
        if (!TextUtils.isEmpty((CharSequence)mActivityName)) {
            Context context = SensorsDataAPI.sharedInstance().getSAContextManager().getContext();
            String title = SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_visual_sa_h5);
            String message = SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_visual_sa_flutter_error);
            String link_text = SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_visual_sa_h5_error_link);
            String msg = "{\"callType\":\"app_alert\",\"data\":[{\"title\":\"" + title + "\",\"message\":\"" + message + "\",\"link_text\":\"" + link_text + "\",\"link_url\":\"https://manual.sensorsdata.cn/sa/latest/flutter-22257963.html\"}]}";
            NodesProcess.getInstance().getFlutterNodesManager().handlerFailure(mActivityName, msg);
        }
    }

    private static void h5AlertHandlerFailure(String url) {
        WebNodeInfo webNodeInfo;
        if (!TextUtils.isEmpty((CharSequence)url) && (webNodeInfo = (WebNodeInfo)NodesProcess.getInstance().getWebNodesManager().getNodes(url)) == null) {
            SALog.i((String)TAG, (String)"H5 page is not integrated Web JS SDK");
            Context context = SensorsDataAPI.sharedInstance().getSAContextManager().getContext();
            String title = SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_visual_sa_h5);
            String message = SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_visual_sa_h5_error);
            String link_text = SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_visual_sa_h5_error_link);
            String msg = "{\"callType\":\"app_alert\",\"data\":[{\"title\":\"" + title + "\",\"message\":\"" + message + "\",\"link_text\":\"" + link_text + "\",\"link_url\":\"https://manual.sensorsdata.cn/sa/latest/tech_sdk_client_web_use-7545346.html\"}]}";
            NodesProcess.getInstance().getWebNodesManager().handlerFailure(url, msg);
        }
    }

    public static void buildH5AlertInfo(OutputStream writer, String mType, SnapInfo info, Context context) throws IOException {
        WebNodeInfo pageInfo = (WebNodeInfo)NodesProcess.getInstance().getWebNodesManager().getPageInfo(info.webViewUrl);
        if (pageInfo != null) {
            if (!TextUtils.isEmpty((CharSequence)pageInfo.getUrl())) {
                writer.write((",\"h5_url\": \"" + pageInfo.getUrl() + "\"").getBytes());
            }
            if (!TextUtils.isEmpty((CharSequence)pageInfo.getTitle())) {
                writer.write((",\"h5_title\": \"" + pageInfo.getTitle() + "\"").getBytes());
            }
        }
        List<NodeInfo.AlertInfo> list = info.alertInfos;
        AlertMessageUtils.buildAlertInfo(writer, mType, list, context);
    }

    public static void buildFlutterAlertInfo(OutputStream writer, String mType, SnapInfo info, Context context) throws IOException {
        List<NodeInfo.AlertInfo> list = info.flutter_alertInfos;
        AlertMessageUtils.buildAlertInfo(writer, mType, list, context);
    }

    private static void buildAlertInfo(OutputStream writer, String mType, List<NodeInfo.AlertInfo> list, Context context) throws IOException {
        if (list != null && list.size() > 0) {
            writer.write(",\"app_alert_infos\":".getBytes());
            writer.flush();
            writer.write("[".getBytes());
            for (int i = 0; i < list.size(); ++i) {
                NodeInfo.AlertInfo alertInfo;
                if (i > 0) {
                    writer.write(",".getBytes());
                }
                if ((alertInfo = list.get(i)) == null) continue;
                if (TextUtils.equals((CharSequence)"heat_map", (CharSequence)mType)) {
                    alertInfo.title = alertInfo.title.replace(SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_visual), SADisplayUtil.getStringResource((Context)context, (int)R.string.sensors_analytics_heatmap));
                }
                writer.write("{".getBytes());
                writer.write("\"title\":".getBytes());
                writer.write(("\"" + alertInfo.title + "\"").getBytes());
                writer.write(",".getBytes());
                writer.write("\"message\":".getBytes());
                writer.write(("\"" + alertInfo.message + "\"").getBytes());
                writer.write(",".getBytes());
                writer.write("\"link_text\":".getBytes());
                writer.write(("\"" + alertInfo.linkText + "\"").getBytes());
                writer.write(",".getBytes());
                writer.write("\"link_url\":".getBytes());
                writer.write(("\"" + alertInfo.linkUrl + "\"").getBytes());
                writer.write("}".getBytes());
            }
            writer.write("]".getBytes());
            writer.flush();
        }
    }

    public static class AlertRunnable
    implements Runnable {
        private final String unique;
        private final AlertType alertType;

        public AlertRunnable(AlertType alertType, String unique) {
            this.unique = unique;
            this.alertType = alertType;
        }

        @Override
        public void run() {
            switch (this.alertType) {
                case H5: {
                    AlertMessageUtils.h5AlertHandlerFailure(this.unique);
                    break;
                }
                case FLUTTER: {
                    AlertMessageUtils.flutterAlertHandlerFailure(this.unique);
                }
            }
        }

        public static enum AlertType {
            H5,
            FLUTTER;

        }
    }
}

