/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.snap;

import android.os.Handler;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.visual.ViewSnapshot;
import com.sensorsdata.analytics.android.sdk.visual.snap.Caller;
import com.sensorsdata.analytics.android.sdk.visual.snap.PropertyDescription;
import com.sensorsdata.analytics.android.sdk.visual.snap.ResourceIds;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EditProtocol {
    private static final Class<?>[] NO_PARAMS = new Class[0];
    private static final String TAG = "SA.EProtocol";
    private final ResourceIds mResourceIds;
    private List<PropertyDescription> propertyDescriptionList;

    public EditProtocol(ResourceIds resourceIds) {
        this.mResourceIds = resourceIds;
        try {
            JSONObject mMessageObject = new JSONObject("{\"type\":\"snapshot_request\",\"payload\":{\"config\":{\"classes\":[{\"name\":\"android.view.View\",\"properties\":[{\"name\":\"clickable\",\"get\":{\"selector\":\"isClickable\",\"parameters\":[],\"result\":{\"type\":\"java.lang.Boolean\"}}}]},{\"name\":\"android.widget.TextView\",\"properties\":[{\"name\":\"clickable\",\"get\":{\"selector\":\"isClickable\",\"parameters\":[],\"result\":{\"type\":\"java.lang.Boolean\"}}}]},{\"name\":\"android.widget.ImageView\",\"properties\":[{\"name\":\"clickable\",\"get\":{\"selector\":\"isClickable\",\"parameters\":[],\"result\":{\"type\":\"java.lang.Boolean\"}}}]}]}}}");
            JSONObject payload = mMessageObject.getJSONObject("payload");
            if (payload.has("config")) {
                this.propertyDescriptionList = this.getListPropertyDescription(payload);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public ViewSnapshot readSnapshotConfig(Handler mMainThreadHandler) throws BadInstructionsException {
        if (this.propertyDescriptionList == null) {
            return null;
        }
        return new ViewSnapshot(this.propertyDescriptionList, this.mResourceIds, mMainThreadHandler);
    }

    private List<PropertyDescription> getListPropertyDescription(JSONObject source) throws BadInstructionsException {
        LinkedList<PropertyDescription> properties = new LinkedList<PropertyDescription>();
        try {
            JSONObject config = source.getJSONObject("config");
            JSONArray classes = config.getJSONArray("classes");
            for (int classIx = 0; classIx < classes.length(); ++classIx) {
                JSONObject classDesc = classes.getJSONObject(classIx);
                String targetClassName = classDesc.getString("name");
                Class<?> targetClass = Class.forName(targetClassName);
                JSONArray propertyDescs = classDesc.getJSONArray("properties");
                for (int i = 0; i < propertyDescs.length(); ++i) {
                    JSONObject propertyDesc = propertyDescs.getJSONObject(i);
                    PropertyDescription desc = this.readPropertyDescription(targetClass, propertyDesc);
                    properties.add(desc);
                }
            }
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't read snapshot configuration", e);
        }
        catch (ClassNotFoundException e) {
            throw new BadInstructionsException("Can't resolve types for snapshot configuration", e);
        }
        return properties;
    }

    private PropertyDescription readPropertyDescription(Class<?> targetClass, JSONObject propertyDesc) throws BadInstructionsException {
        try {
            String mutatorName;
            String propName = propertyDesc.getString("name");
            Caller accessor = null;
            if (propertyDesc.has("get")) {
                JSONObject accessorConfig = propertyDesc.getJSONObject("get");
                String accessorName = accessorConfig.getString("selector");
                String accessorResultTypeName = accessorConfig.getJSONObject("result").getString("type");
                Class<?> accessorResultType = Class.forName(accessorResultTypeName);
                accessor = new Caller(targetClass, accessorName, NO_PARAMS, accessorResultType);
            }
            if (propertyDesc.has("set")) {
                JSONObject mutatorConfig = propertyDesc.getJSONObject("set");
                mutatorName = mutatorConfig.getString("selector");
            } else {
                mutatorName = null;
            }
            return new PropertyDescription(propName, targetClass, accessor, mutatorName);
        }
        catch (NoSuchMethodException e) {
            throw new BadInstructionsException("Can't create property reader", e);
        }
        catch (JSONException e) {
            throw new BadInstructionsException("Can't read property JSON", e);
        }
        catch (ClassNotFoundException e) {
            throw new BadInstructionsException("Can't read property JSON, relevant arg/return class not found", e);
        }
    }

    public static class BadInstructionsException
    extends Exception {
        private static final long serialVersionUID = -4062004792184145311L;

        public BadInstructionsException(String message) {
            super(message);
        }

        public BadInstructionsException(String message, Throwable e) {
            super(message, e);
        }
    }
}

