/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.property;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.AppStateTools;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewNode;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewTreeStatusObservable;
import com.sensorsdata.analytics.android.sdk.visual.R;
import com.sensorsdata.analytics.android.sdk.visual.model.VisualConfig;
import com.sensorsdata.analytics.android.sdk.visual.property.VisualConfigRequestHelper;
import com.sensorsdata.analytics.android.sdk.visual.property.VisualPropertiesCache;
import com.sensorsdata.analytics.android.sdk.visual.property.VisualPropertiesH5Helper;
import java.lang.ref.WeakReference;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class VisualPropertiesManager {
    private static final String TAG = "SA.VP.VisualPropertiesManager";
    private static final String PROPERTY_TYPE_NUMBER = "NUMBER";
    private VisualConfig mVisualConfig;
    private final VisualPropertiesCache mConfigCache = new VisualPropertiesCache();
    private final VisualConfigRequestHelper mRequestHelper;
    private CollectLogListener mCollectLogListener;
    private final VisualPropertiesH5Helper mVisualPropertiesH5Helper;

    private VisualPropertiesManager() {
        this.mVisualConfig = this.mConfigCache.getVisualConfig();
        this.mRequestHelper = new VisualConfigRequestHelper();
        this.mVisualPropertiesH5Helper = new VisualPropertiesH5Helper();
    }

    public static VisualPropertiesManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void requestVisualConfig(SAContextManager contextManager) {
        try {
            if (contextManager == null || !contextManager.getSensorsDataAPI().isNetworkRequestEnable() || SensorsDataAPI.isSDKDisabled()) {
                SALog.i((String)TAG, (String)"Close network request");
                return;
            }
            if (!contextManager.getInternalConfigs().saConfigOptions.isVisualizedPropertiesEnabled()) {
                return;
            }
            SALog.i((String)TAG, (String)"requestVisualConfig");
            this.mRequestHelper.requestVisualConfig(contextManager.getContext(), this.getVisualConfigVersion(), new VisualConfigRequestHelper.IApiCallback(){

                @Override
                public void onSuccess(String message) {
                    VisualPropertiesManager.this.save2Cache(message);
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public VisualPropertiesH5Helper getVisualPropertiesH5Helper() {
        return this.mVisualPropertiesH5Helper;
    }

    public VisualPropertiesCache getVisualPropertiesCache() {
        return this.mConfigCache;
    }

    public VisualConfig getVisualConfig() {
        return this.mVisualConfig;
    }

    public void save2Cache(String message) {
        this.mConfigCache.save2Cache(message);
        this.mVisualConfig = this.mConfigCache.getVisualConfig();
    }

    public String getVisualConfigVersion() {
        if (this.mVisualConfig != null) {
            return this.mVisualConfig.version;
        }
        return null;
    }

    public void registerCollectLogListener(CollectLogListener listener) {
        this.mCollectLogListener = listener;
    }

    public void unRegisterCollectLogListener() {
        this.mCollectLogListener = null;
    }

    public void mergeVisualProperties(VisualEventType eventType, JSONObject srcObject, ViewNode viewNode) {
        try {
            List<VisualConfig.VisualPropertiesConfig> eventConfigList;
            WeakReference view;
            String screenName = srcObject.optString("$screen_name");
            if (this.mCollectLogListener != null) {
                this.mCollectLogListener.onStart(eventType.visualEventType, screenName, viewNode);
            }
            SALog.i((String)TAG, (String)String.format("mergeVisualProperties eventType: %s, screenName:%s ", eventType.getVisualEventType(), screenName));
            if (TextUtils.isEmpty((CharSequence)screenName)) {
                SALog.i((String)TAG, (String)"screenName is empty and return");
                return;
            }
            if (!SensorsDataAPI.sharedInstance().isVisualizedAutoTrackEnabled()) {
                SALog.i((String)TAG, (String)"you should call 'enableVisualizedAutoTrack(true)' first");
                if (this.mCollectLogListener != null) {
                    this.mCollectLogListener.onSwitchClose();
                }
                return;
            }
            Activity activity = null;
            if (viewNode != null && (view = viewNode.getView()) != null && view.get() != null) {
                activity = SAViewUtils.getActivityOfView((Context)((View)view.get()).getContext(), (View)((View)view.get()));
            }
            if (activity == null) {
                activity = AppStateTools.getInstance().getForegroundActivity();
            }
            if (activity == null || !SensorsDataAPI.sharedInstance().isVisualizedAutoTrackActivity(activity.getClass())) {
                SALog.i((String)TAG, (String)"activity is null or not in white list and return");
                if (this.mCollectLogListener != null) {
                    this.mCollectLogListener.onOtherError("activity is null or not in white list and return");
                }
                return;
            }
            if (this.mVisualConfig == null) {
                SALog.i((String)TAG, (String)"visual properties is empty and return");
                if (this.mCollectLogListener != null) {
                    this.mCollectLogListener.onCheckVisualConfigFailure(SADisplayUtil.getStringResource((Context)SensorsDataAPI.sharedInstance().getSAContextManager().getContext(), (int)R.string.sensors_analytics_visual_cache_no_property_error));
                }
                return;
            }
            if (!this.checkAppIdAndProject()) {
                if (this.mCollectLogListener != null) {
                    this.mCollectLogListener.onCheckVisualConfigFailure(SADisplayUtil.getStringResource((Context)SensorsDataAPI.sharedInstance().getSAContextManager().getContext(), (int)R.string.sensors_analytics_visual_appid_error));
                }
                return;
            }
            List<VisualConfig.VisualPropertiesConfig> propertiesConfigs = this.mVisualConfig.events;
            if (propertiesConfigs == null || propertiesConfigs.size() == 0) {
                SALog.i((String)TAG, (String)"propertiesConfigs is empty");
                if (this.mCollectLogListener != null) {
                    this.mCollectLogListener.onOtherError("propertiesConfigs is empty");
                }
                return;
            }
            String elementPath = null;
            String elementPosition = null;
            String elementContent = null;
            if (viewNode != null) {
                elementPath = viewNode.getViewPath();
                elementPosition = viewNode.getViewPosition();
                elementContent = viewNode.getViewContent();
            }
            if ((eventConfigList = this.getMatchEventConfigList(propertiesConfigs, eventType, screenName, elementPath, elementPosition, elementContent)).size() == 0) {
                SALog.i((String)TAG, (String)"event config is empty and return");
                if (this.mCollectLogListener != null) {
                    this.mCollectLogListener.onCheckEventConfigFailure();
                }
                return;
            }
            for (VisualConfig.VisualPropertiesConfig visualPropertiesConfig : eventConfigList) {
                VisualConfig.VisualEvent event = visualPropertiesConfig.event;
                if (event != null && event.isH5) continue;
                List<VisualConfig.VisualProperty> properties = visualPropertiesConfig.properties;
                if (properties == null || properties.size() == 0) {
                    SALog.i((String)TAG, (String)"properties is empty ");
                    continue;
                }
                this.mergeVisualProperty(properties, event, srcObject, viewNode, visualPropertiesConfig.eventName);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public List<VisualConfig.VisualPropertiesConfig> getMatchEventConfigList(List<VisualConfig.VisualPropertiesConfig> propertiesConfigs, VisualEventType eventType, String screenName, String elementPath, String elementPosition, String elementContent) {
        ArrayList<VisualConfig.VisualPropertiesConfig> list = new ArrayList<VisualConfig.VisualPropertiesConfig>();
        try {
            for (VisualConfig.VisualPropertiesConfig visualPropertiesConfig : propertiesConfigs) {
                if (!TextUtils.equals((CharSequence)visualPropertiesConfig.eventType, (CharSequence)eventType.getVisualEventType())) continue;
                VisualConfig.VisualEvent event = visualPropertiesConfig.event;
                if (!TextUtils.isEmpty((CharSequence)screenName) && !TextUtils.equals((CharSequence)event.screenName, (CharSequence)screenName)) continue;
                if (eventType == VisualEventType.APP_CLICK || eventType == VisualEventType.WEB_CLICK) {
                    if (!TextUtils.equals((CharSequence)event.elementPath, (CharSequence)elementPath)) {
                        SALog.i((String)TAG, (String)String.format("event element_path is not match: current element_path is %s, config element_path is %s ", elementPath, event.elementPath));
                        continue;
                    }
                    if (event.limitElementPosition && !TextUtils.equals((CharSequence)event.elementPosition, (CharSequence)elementPosition)) {
                        SALog.i((String)TAG, (String)String.format("event element_position is not match: current element_position is %s, config element_position is %s ", elementPosition, event.elementPosition));
                        continue;
                    }
                    if (event.limitElementContent && !TextUtils.equals((CharSequence)event.elementContent, (CharSequence)elementContent)) {
                        SALog.i((String)TAG, (String)String.format("event element_content is not match: current element_content is %s, config element_content is %s ", elementContent, event.elementContent));
                        continue;
                    }
                }
                list.add(visualPropertiesConfig);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return list;
    }

    public boolean checkAppIdAndProject() {
        String serverUrl = SensorsDataAPI.sharedInstance().getServerUrl();
        if (TextUtils.isEmpty((CharSequence)serverUrl)) {
            SALog.i((String)TAG, (String)"serverUrl is empty and return");
            return false;
        }
        Uri uri = Uri.parse((String)serverUrl);
        String project = uri.getQueryParameter("project");
        Context context = SensorsDataAPI.sharedInstance().getSAContextManager().getContext();
        String appId = AppInfoUtils.getProcessName((Context)context);
        if (TextUtils.isEmpty((CharSequence)project) || TextUtils.isEmpty((CharSequence)appId)) {
            SALog.i((String)TAG, (String)"project or app_id is empty and return");
            return false;
        }
        if (this.mVisualConfig == null) {
            SALog.i((String)TAG, (String)"VisualConfig is null and return");
            return false;
        }
        if (!TextUtils.equals((CharSequence)appId, (CharSequence)this.mVisualConfig.appId)) {
            SALog.i((String)TAG, (String)String.format("app_id is not equals: current app_id is %s, config app_id is %s ", appId, this.mVisualConfig.appId));
            return false;
        }
        if (!TextUtils.equals((CharSequence)project, (CharSequence)this.mVisualConfig.project)) {
            SALog.i((String)TAG, (String)String.format("project is not equals: current project is %s, config project is %s ", project, this.mVisualConfig.project));
            return false;
        }
        return true;
    }

    private void mergeVisualProperty(List<VisualConfig.VisualProperty> properties, VisualConfig.VisualEvent event, JSONObject srcObject, ViewNode clickViewNode, String eventName) {
        try {
            HashSet<String> h5HashSet = new HashSet<String>();
            ViewTreeStatusObservable.getInstance().clearViewNodeCache();
            for (VisualConfig.VisualProperty visualProperty : properties) {
                if (visualProperty.isH5 && !TextUtils.isEmpty((CharSequence)visualProperty.webViewElementPath)) {
                    h5HashSet.add(visualProperty.webViewElementPath + visualProperty.screenName);
                    continue;
                }
                this.mergeAppVisualProperty(visualProperty, event, srcObject, clickViewNode);
            }
            if (h5HashSet.size() > 0) {
                this.mVisualPropertiesH5Helper.mergeJSVisualProperties(srcObject, h5HashSet, eventName);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void mergeAppVisualProperty(VisualConfig.VisualProperty visualProperty, VisualConfig.VisualEvent event, JSONObject srcObject, ViewNode clickViewNode) {
        block26: {
            try {
                if (TextUtils.isEmpty((CharSequence)visualProperty.name)) {
                    SALog.i((String)TAG, (String)"config visual property name is empty");
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)visualProperty.elementPath)) {
                    SALog.i((String)TAG, (String)"config visual property elementPath is empty");
                    return;
                }
                if (!(clickViewNode == null || TextUtils.isEmpty((CharSequence)clickViewNode.getViewPosition()) || event == null || TextUtils.isEmpty((CharSequence)event.elementPosition) || event.limitElementPosition || TextUtils.isEmpty((CharSequence)visualProperty.elementPosition) || !TextUtils.equals((CharSequence)visualProperty.elementPath.split("-")[0], (CharSequence)event.elementPath.split("-")[0]))) {
                    visualProperty.elementPosition = clickViewNode.getViewPosition();
                    SALog.i((String)TAG, (String)("visualProperty elementPosition replace: " + clickViewNode.getViewPosition()));
                }
                String propertyElementContent = null;
                try {
                    ViewNode viewTreeNode = ViewTreeStatusObservable.getInstance().getViewNode(clickViewNode != null ? clickViewNode.getView() : null, visualProperty.elementPath, visualProperty.elementPosition, visualProperty.screenName);
                    if (viewTreeNode != null && TextUtils.equals((CharSequence)visualProperty.elementPath, (CharSequence)viewTreeNode.getViewPath()) && TextUtils.isEmpty((CharSequence)visualProperty.elementPosition) | TextUtils.equals((CharSequence)visualProperty.elementPosition, (CharSequence)viewTreeNode.getViewPosition())) {
                        propertyElementContent = viewTreeNode.getViewContent();
                        WeakReference targetView = null;
                        if (viewTreeNode.getView() != null) {
                            targetView = viewTreeNode.getView();
                        }
                        if (targetView != null && targetView.get() != null) {
                            propertyElementContent = SAViewUtils.getViewContent((View)((View)targetView.get()), (boolean)true);
                        }
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
                if (propertyElementContent == null || TextUtils.isEmpty(propertyElementContent)) {
                    if (this.mCollectLogListener != null) {
                        this.mCollectLogListener.onFindPropertyElementFailure(visualProperty.name, visualProperty.elementPath, visualProperty.elementPosition);
                    }
                    return;
                }
                SALog.i((String)TAG, (String)String.format("find property target view success, property element_path: %s,element_position: %s,element_content: %s", visualProperty.elementPath, visualProperty.elementPosition, propertyElementContent));
                String result = null;
                if (!TextUtils.isEmpty((CharSequence)visualProperty.regular)) {
                    Pattern pattern = null;
                    try {
                        pattern = Pattern.compile(visualProperty.regular, 40);
                        Matcher matcher = pattern.matcher(propertyElementContent);
                        if (!matcher.find()) {
                            SALog.i((String)TAG, (String)"matcher not find continue");
                            if (this.mCollectLogListener != null) {
                                this.mCollectLogListener.onParsePropertyContentFailure(visualProperty.name, visualProperty.type, propertyElementContent, visualProperty.regular);
                            }
                            return;
                        }
                        result = matcher.group();
                        SALog.i((String)TAG, (String)String.format("propertyValue is: %s", result));
                    }
                    catch (Exception e) {
                        if (this.mCollectLogListener != null) {
                            this.mCollectLogListener.onParsePropertyContentFailure(visualProperty.name, visualProperty.type, propertyElementContent, visualProperty.regular);
                        }
                        SALog.printStackTrace((Exception)e);
                        return;
                    }
                }
                if (TextUtils.isEmpty(result)) break block26;
                if (TextUtils.equals((CharSequence)PROPERTY_TYPE_NUMBER, (CharSequence)visualProperty.type)) {
                    try {
                        if (result != null) {
                            srcObject.put(visualProperty.name, (Object)NumberFormat.getInstance().parse(result));
                        }
                        break block26;
                    }
                    catch (Exception e) {
                        if (this.mCollectLogListener != null) {
                            this.mCollectLogListener.onOtherError(e.getMessage());
                        }
                        break block26;
                    }
                }
                try {
                    srcObject.put(visualProperty.name, result);
                }
                catch (JSONException e) {
                    if (this.mCollectLogListener != null) {
                        this.mCollectLogListener.onOtherError(e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
        }
    }

    public static enum VisualEventType {
        APP_CLICK("appclick", "$AppClick"),
        WEB_CLICK("appclick", "$WebClick");

        private final String visualEventType;
        private final String trackEventType;

        private VisualEventType(String visualEventType, String trackEventType) {
            this.visualEventType = visualEventType;
            this.trackEventType = trackEventType;
        }

        public String getVisualEventType() {
            return this.visualEventType;
        }

        public static VisualEventType getVisualEventType(String trackEventType) {
            for (VisualEventType visualEventType : VisualEventType.values()) {
                if (!TextUtils.equals((CharSequence)visualEventType.trackEventType, (CharSequence)trackEventType)) continue;
                return visualEventType;
            }
            return null;
        }
    }

    static interface CollectLogListener {
        public void onStart(String var1, String var2, ViewNode var3);

        public void onSwitchClose();

        public void onCheckVisualConfigFailure(String var1);

        public void onCheckEventConfigFailure();

        public void onFindPropertyElementFailure(String var1, String var2, String var3);

        public void onParsePropertyContentFailure(String var1, String var2, String var3, String var4);

        public void onOtherError(String var1);
    }

    private static class SingletonHolder {
        private static final VisualPropertiesManager INSTANCE = new VisualPropertiesManager();

        private SingletonHolder() {
        }
    }
}

