/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual;

import android.app.Activity;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.visual.VisualDebugHelper;
import com.sensorsdata.analytics.android.sdk.visual.VisualizedAutoTrackViewCrawler;
import com.sensorsdata.analytics.android.sdk.visual.property.VisualPropertiesLog;
import com.sensorsdata.analytics.android.sdk.visual.property.VisualPropertiesManager;

public class VisualizedAutoTrackService {
    private static final String TAG = "SA.VisualizedAutoTrackService";
    private static VisualizedAutoTrackService instance;
    private static VisualizedAutoTrackViewCrawler mVTrack;
    private boolean mDebugModeEnabled = false;
    private VisualPropertiesLog mVisualPropertiesLog;
    private VisualDebugHelper mVisualDebugHelper;
    private String mLastDebugInfo;

    private VisualizedAutoTrackService() {
    }

    public static VisualizedAutoTrackService getInstance() {
        if (instance == null) {
            instance = new VisualizedAutoTrackService();
        }
        return instance;
    }

    public void stop() {
        try {
            if (mVTrack != null) {
                mVTrack.stopUpdates(false);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void resume() {
        try {
            if (mVTrack != null) {
                mVTrack.startUpdates();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void start(Activity activity, String featureCode, String postUrl) {
        try {
            String packageName = activity.getApplicationContext().getPackageName();
            ApplicationInfo appInfo = activity.getApplicationContext().getPackageManager().getApplicationInfo(packageName, 128);
            Bundle configBundle = appInfo.metaData;
            if (null == configBundle) {
                configBundle = new Bundle();
            }
            if (Build.VERSION.SDK_INT >= 16) {
                String resourcePackageName = configBundle.getString("com.sensorsdata.analytics.android.ResourcePackageName");
                if (null == resourcePackageName) {
                    resourcePackageName = activity.getPackageName();
                }
                if (this.mVisualDebugHelper == null) {
                    this.mVisualDebugHelper = new VisualDebugHelper();
                }
                mVTrack = new VisualizedAutoTrackViewCrawler(activity, resourcePackageName, featureCode, postUrl, this.mVisualDebugHelper);
                mVTrack.startUpdates();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public boolean isServiceRunning() {
        if (mVTrack != null) {
            return mVTrack.isServiceRunning();
        }
        return false;
    }

    String getDebugInfo() {
        try {
            if (this.mVisualDebugHelper != null) {
                this.mLastDebugInfo = this.mVisualDebugHelper.getDebugInfo();
                if (!TextUtils.isEmpty((CharSequence)this.mLastDebugInfo)) {
                    SALog.i((String)TAG, (String)("visual debug info: " + this.mLastDebugInfo));
                    return this.mLastDebugInfo;
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return null;
    }

    String getLastDebugInfo() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.mLastDebugInfo)) {
                SALog.i((String)TAG, (String)("last debug info: " + this.mLastDebugInfo));
                return this.mLastDebugInfo;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return null;
    }

    String getVisualLogInfo() {
        try {
            String visualPropertiesLog;
            if (this.mVisualPropertiesLog != null && !TextUtils.isEmpty((CharSequence)(visualPropertiesLog = this.mVisualPropertiesLog.getVisualPropertiesLog()))) {
                SALog.i((String)TAG, (String)("visual log info: " + visualPropertiesLog));
                return visualPropertiesLog;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return null;
    }

    void setDebugModeEnabled(boolean debugModeEnabled) {
        try {
            if (this.mDebugModeEnabled != debugModeEnabled) {
                if (debugModeEnabled) {
                    this.mVisualPropertiesLog = new VisualPropertiesLog();
                    VisualPropertiesManager.getInstance().registerCollectLogListener(this.mVisualPropertiesLog);
                } else {
                    this.mVisualPropertiesLog = null;
                    VisualPropertiesManager.getInstance().unRegisterCollectLogListener();
                }
            }
            this.mDebugModeEnabled = debugModeEnabled;
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }
}

