/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.listener.SAEventListener;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.ThreadUtils;
import com.sensorsdata.analytics.android.sdk.visual.VisualizedAutoTrackService;
import com.sensorsdata.analytics.android.sdk.visual.model.VisualConfig;
import com.sensorsdata.analytics.android.sdk.visual.property.VisualPropertiesManager;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.json.JSONArray;
import org.json.JSONObject;

public class VisualDebugHelper {
    private static final String TAG = "SA.VP.VisualDebugHelper";
    private JSONArray mJsonArray;
    private TrackEventAdapter mEventListener = null;
    private final Object object = new Object();

    void startMonitor() {
        try {
            if (this.mEventListener == null) {
                final ExecutorService executorService = ThreadUtils.getSinglePool();
                this.mEventListener = new TrackEventAdapter(){

                    public void trackEvent(final JSONObject jsonObject) {
                        executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                VisualDebugHelper.this.handlerEvent(jsonObject);
                            }
                        });
                    }
                };
            }
            SensorsDataAPI.sharedInstance().addEventListener((SAEventListener)this.mEventListener);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    void stopMonitor() {
        try {
            if (this.mEventListener != null) {
                SensorsDataAPI.sharedInstance().removeEventListener((SAEventListener)this.mEventListener);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handlerEvent(JSONObject jsonObject) {
        block28: {
            try {
                if (jsonObject == null) {
                    return;
                }
                if (!VisualizedAutoTrackService.getInstance().isServiceRunning()) {
                    return;
                }
                String eventName = jsonObject.optString("event");
                if (!TextUtils.equals((CharSequence)"$AppClick", (CharSequence)eventName) && !TextUtils.equals((CharSequence)"$WebClick", (CharSequence)eventName)) {
                    SALog.i((String)TAG, (String)("eventName is " + eventName + " filter"));
                    return;
                }
                JSONObject propertyObject = jsonObject.optJSONObject("properties");
                if (propertyObject == null) {
                    return;
                }
                if (!VisualPropertiesManager.getInstance().checkAppIdAndProject()) {
                    return;
                }
                VisualConfig visualConfig = VisualPropertiesManager.getInstance().getVisualConfig();
                if (visualConfig == null) {
                    return;
                }
                List<VisualConfig.VisualPropertiesConfig> propertiesConfigs = visualConfig.events;
                if (propertiesConfigs == null || propertiesConfigs.size() == 0) {
                    SALog.i((String)TAG, (String)"propertiesConfigs is empty ");
                    return;
                }
                if (TextUtils.equals((CharSequence)"$AppClick", (CharSequence)eventName)) {
                    String screenName = propertyObject.optString("$screen_name");
                    if (TextUtils.isEmpty((CharSequence)screenName)) {
                        SALog.i((String)TAG, (String)"screenName is empty ");
                        return;
                    }
                    List<VisualConfig.VisualPropertiesConfig> eventConfigList = VisualPropertiesManager.getInstance().getMatchEventConfigList(propertiesConfigs, VisualPropertiesManager.VisualEventType.getVisualEventType(eventName), screenName, propertyObject.optString("$element_path"), propertyObject.optString("$element_position"), propertyObject.optString("$element_content"));
                    if (eventConfigList.size() <= 0) break block28;
                    Object object = this.object;
                    synchronized (object) {
                        for (VisualConfig.VisualPropertiesConfig config : eventConfigList) {
                            try {
                                JSONObject object2 = new JSONObject();
                                JSONUtils.mergeJSONObject((JSONObject)jsonObject, (JSONObject)object2);
                                object2.put("event_name", (Object)config.eventName);
                                if (this.mJsonArray == null) {
                                    this.mJsonArray = new JSONArray();
                                }
                                this.mJsonArray.put((Object)object2);
                            }
                            catch (Exception e) {
                                SALog.printStackTrace((Exception)e);
                            }
                        }
                        break block28;
                    }
                }
                if (!TextUtils.equals((CharSequence)"$WebClick", (CharSequence)eventName)) break block28;
                try {
                    JSONArray array = propertyObject.optJSONArray("sensorsdata_web_visual_eventName");
                    if (array == null) {
                        int hashCode = jsonObject.hashCode();
                        array = VisualPropertiesManager.getInstance().getVisualPropertiesH5Helper().getEventName(hashCode);
                        VisualPropertiesManager.getInstance().getVisualPropertiesH5Helper().clearCache(hashCode);
                    }
                    if (array == null || array.length() <= 0) break block28;
                    Object object = this.object;
                    synchronized (object) {
                        for (int i = 0; i < array.length(); ++i) {
                            try {
                                JSONObject object3 = new JSONObject();
                                JSONUtils.mergeJSONObject((JSONObject)jsonObject, (JSONObject)object3);
                                object3.put("event_name", (Object)array.optString(i));
                                if (this.mJsonArray == null) {
                                    this.mJsonArray = new JSONArray();
                                }
                                this.mJsonArray.put((Object)object3);
                                continue;
                            }
                            catch (Exception e) {
                                SALog.printStackTrace((Exception)e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDebugInfo() {
        Object object = this.object;
        synchronized (object) {
            if (this.mJsonArray != null) {
                String result = this.mJsonArray.toString();
                this.mJsonArray = null;
                return result;
            }
            return null;
        }
    }

    private static abstract class TrackEventAdapter
    implements SAEventListener {
        private TrackEventAdapter() {
        }

        public void login() {
        }

        public void logout() {
        }

        public void identify() {
        }

        public void resetAnonymousId() {
        }
    }
}

