/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.property;

import android.content.Context;
import android.net.Uri;
import android.os.CountDownTimer;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.network.HttpCallback;
import com.sensorsdata.analytics.android.sdk.network.HttpMethod;
import com.sensorsdata.analytics.android.sdk.network.RequestHelper;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.Dispatcher;
import com.sensorsdata.analytics.android.sdk.visual.property.VisualPropertiesManager;

public class VisualConfigRequestHelper {
    private static final String TAG = "SA.VP.VisualConfigRequestHelper";
    private volatile CountDownTimer mCountDownTimer;

    public void requestVisualConfig(final Context context, final String version, final IApiCallback callback) {
        Dispatcher.getInstance().post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (VisualConfigRequestHelper.this.mCountDownTimer != null) {
                        VisualConfigRequestHelper.this.mCountDownTimer.cancel();
                        VisualConfigRequestHelper.this.mCountDownTimer = null;
                    }
                    VisualConfigRequestHelper.this.mCountDownTimer = new CountDownTimer(90000L, 30000L){

                        public void onTick(long l) {
                            try {
                                String serverUrl = SensorsDataAPI.sharedInstance().getServerUrl();
                                if (TextUtils.isEmpty((CharSequence)serverUrl)) {
                                    SALog.i((String)VisualConfigRequestHelper.TAG, (String)"visualConfigRequest server url is null and return");
                                    return;
                                }
                                String requestUrl = VisualConfigRequestHelper.this.getRequestUrl(context, version);
                                if (TextUtils.isEmpty((CharSequence)requestUrl)) {
                                    SALog.i((String)VisualConfigRequestHelper.TAG, (String)"visualConfigRequest request url is null and return");
                                    return;
                                }
                                new RequestHelper.Builder(HttpMethod.GET, requestUrl).callback((HttpCallback)new HttpCallback.StringCallback(){

                                    public void onFailure(int code, String errorMessage) {
                                        if (code == 304 || code == 404 || code == 205) {
                                            VisualConfigRequestHelper.this.resetTimer();
                                            if (code == 205) {
                                                VisualPropertiesManager.getInstance().save2Cache("");
                                            }
                                            SALog.i((String)VisualConfigRequestHelper.TAG, (String)"requestVisualConfig return 304 Or 404");
                                        }
                                    }

                                    public void onResponse(String response) {
                                        VisualConfigRequestHelper.this.resetTimer();
                                        if (callback != null) {
                                            callback.onSuccess(response);
                                        }
                                        SALog.i((String)VisualConfigRequestHelper.TAG, (String)("requestVisualConfig success response is " + response));
                                    }

                                    public void onAfter() {
                                    }
                                }).execute();
                            }
                            catch (Exception e) {
                                SALog.printStackTrace((Exception)e);
                            }
                        }

                        public void onFinish() {
                        }
                    };
                    VisualConfigRequestHelper.this.mCountDownTimer.start();
                }
                catch (Exception e) {
                    SALog.printStackTrace((Exception)e);
                }
            }
        });
    }

    private void resetTimer() {
        try {
            if (this.mCountDownTimer != null) {
                this.mCountDownTimer.cancel();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        finally {
            this.mCountDownTimer = null;
        }
    }

    private String getRequestUrl(Context context, String version) {
        if (context == null) {
            SALog.i((String)TAG, (String)"getRequestUrl context is null and return");
            return null;
        }
        String serverUrl = SensorsDataAPI.sharedInstance().getServerUrl();
        if (TextUtils.isEmpty((CharSequence)serverUrl)) {
            SALog.i((String)TAG, (String)"visualConfigRequest server url is null and return");
            return null;
        }
        String baseUrl = null;
        int pathPrefix = serverUrl.lastIndexOf("/");
        if (pathPrefix != -1) {
            baseUrl = serverUrl.substring(0, pathPrefix) + "/config/visualized/Android.conf";
        }
        if (!TextUtils.isEmpty(baseUrl)) {
            String appId;
            Uri uri;
            String project;
            Uri configUri = Uri.parse(baseUrl);
            Uri.Builder builder = configUri.buildUpon();
            if (!TextUtils.isEmpty((CharSequence)version)) {
                builder.appendQueryParameter("v", version);
            }
            if (!TextUtils.isEmpty((CharSequence)(project = (uri = Uri.parse((String)serverUrl)).getQueryParameter("project")))) {
                builder.appendQueryParameter("project", project);
            }
            if (!TextUtils.isEmpty((CharSequence)(appId = AppInfoUtils.getProcessName((Context)context)))) {
                builder.appendQueryParameter("app_id", appId);
            }
            return builder.build().toString();
        }
        return null;
    }

    public static interface IApiCallback {
        public void onSuccess(String var1);
    }
}

