/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.model;

import com.sensorsdata.analytics.android.sdk.visual.model.CommonNode;
import com.sensorsdata.analytics.android.sdk.visual.model.NodeInfo;
import java.util.List;

public class WebNodeInfo
extends NodeInfo {
    private String url;

    private WebNodeInfo(List<? extends CommonNode> webNodes, List<NodeInfo.AlertInfo> alertInfos, String title, String url, NodeInfo.Status status) {
        this.webNodes = webNodes;
        this.alertInfos = alertInfos;
        this.title = title;
        this.url = url;
        this.status = status;
    }

    public static WebNodeInfo createAlertInfo(List<NodeInfo.AlertInfo> list) {
        return (WebNodeInfo)new WebNodeBuilder().setAlertInfo(list).setStatus(NodeInfo.Status.FAILURE).create();
    }

    public static WebNodeInfo createNodesInfo(List<? extends CommonNode> webNodes) {
        return (WebNodeInfo)new WebNodeBuilder().setWebNodes(webNodes).setStatus(NodeInfo.Status.SUCCESS).create();
    }

    public static WebNodeInfo createPageInfo(String title, String url) {
        return (WebNodeInfo)new WebNodeBuilder().setUrl(url).setTitle(title).create();
    }

    public String getUrl() {
        return this.url;
    }

    public static class WebNodeBuilder
    extends NodeInfo.Builder<WebNodeInfo> {
        private String url;

        WebNodeBuilder setUrl(String url) {
            this.url = url;
            return this;
        }

        @Override
        WebNodeInfo create() {
            return new WebNodeInfo(this.webNodes, this.alertInfos, this.title, this.url, this.status);
        }
    }
}

