/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual;

import android.text.TextUtils;
import android.util.LruCache;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.util.Dispatcher;
import com.sensorsdata.analytics.android.sdk.visual.HeatMapService;
import com.sensorsdata.analytics.android.sdk.visual.VisualizedAutoTrackService;
import com.sensorsdata.analytics.android.sdk.visual.model.CommonNode;
import com.sensorsdata.analytics.android.sdk.visual.model.NodeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractNodesManager {
    private static final String TAG = "SA.Visual.AbstractNodesManager";
    protected static final String CALL_TYPE_VISUALIZED_TRACK = "visualized_track";
    protected static final String CALL_TYPE_PAGE_INFO = "page_info";
    protected static LruCache<String, NodeInfo> sNodesCache;
    protected static LruCache<String, NodeInfo> sPageInfoCache;
    protected static final int LRU_CACHE_MAX_SIZE = 10;
    protected String mLastThirdNodeMsg = null;
    private boolean mHasWebView;
    protected boolean mHasAlertInfo;

    protected abstract void handlerVisualizedTrack(List<? extends CommonNode> var1);

    protected abstract void handlerVisualizedPageInfo(String var1);

    protected abstract void handlerVisualizedFailure(String var1, List<NodeInfo.AlertInfo> var2);

    protected abstract CommonNode parseExtraNodesInfo(JSONObject var1);

    public void handlerMessage(String message) {
        Dispatcher.getInstance().removeCallbacksAndMessages();
        if (!VisualizedAutoTrackService.getInstance().isServiceRunning() && !HeatMapService.getInstance().isServiceRunning()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        this.mLastThirdNodeMsg = String.valueOf(System.currentTimeMillis());
        this.mHasAlertInfo = false;
        try {
            String callType;
            JSONObject jsonObject = new JSONObject(message);
            switch (callType = jsonObject.optString("callType")) {
                case "visualized_track": {
                    List<CommonNode> list = this.parseResult(message);
                    if (list == null || list.size() <= 0) break;
                    if (sNodesCache == null) {
                        sNodesCache = new LruCache(10);
                    }
                    this.handlerVisualizedTrack(list);
                    break;
                }
                case "page_info": {
                    this.handlerVisualizedPageInfo(message);
                    break;
                }
            }
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public void handlerFailure(String webViewUrl, String message) {
        try {
            Dispatcher.getInstance().removeCallbacksAndMessages();
            if (!VisualizedAutoTrackService.getInstance().isServiceRunning() && !HeatMapService.getInstance().isServiceRunning()) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)message)) {
                return;
            }
            SALog.i((String)TAG, (String)("handlerFailure url " + webViewUrl + ",msg: " + message));
            this.mHasAlertInfo = true;
            this.mLastThirdNodeMsg = String.valueOf(System.currentTimeMillis());
            List<NodeInfo.AlertInfo> list = this.parseAlertResult(message);
            if (list != null && list.size() > 0) {
                if (sNodesCache == null) {
                    sNodesCache = new LruCache(10);
                }
                this.handlerVisualizedFailure(webViewUrl, list);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public NodeInfo getNodes(String webViewUrl) {
        if (!VisualizedAutoTrackService.getInstance().isServiceRunning() && !HeatMapService.getInstance().isServiceRunning()) {
            return null;
        }
        if (sNodesCache == null) {
            sNodesCache = new LruCache(10);
        }
        return (NodeInfo)sNodesCache.get((Object)webViewUrl);
    }

    public NodeInfo getPageInfo(String webViewUrl) {
        if (!VisualizedAutoTrackService.getInstance().isServiceRunning() && !HeatMapService.getInstance().isServiceRunning()) {
            return null;
        }
        if (sPageInfoCache == null) {
            sPageInfoCache = new LruCache(10);
        }
        return (NodeInfo)sPageInfoCache.get((Object)webViewUrl);
    }

    void clear() {
        this.mLastThirdNodeMsg = null;
        this.mHasAlertInfo = false;
    }

    boolean hasAlertInfo() {
        return this.mHasAlertInfo;
    }

    private List<CommonNode> parseResult(String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return null;
        }
        ArrayList<CommonNode> list = new ArrayList<CommonNode>();
        HashMap<String, NodeRect> hashMap = new HashMap<String, NodeRect>();
        try {
            JSONObject jsonObject = new JSONObject(msg);
            JSONArray data = jsonObject.optJSONArray("data");
            JSONArray extra = null;
            try {
                extra = jsonObject.optJSONArray("extra_elements");
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
            if (data != null) {
                this.findWebNodes(data, list, hashMap);
            }
            if (extra != null) {
                this.findWebNodes(extra, list, hashMap);
            }
            this.modifyWebNodes(list, hashMap);
            try {
                Collections.sort(list, new Comparator<CommonNode>(){

                    @Override
                    public int compare(CommonNode o1, CommonNode o2) {
                        return o1.getLevel() - o2.getLevel();
                    }
                });
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return list;
    }

    private List<NodeInfo.AlertInfo> parseAlertResult(String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return null;
        }
        ArrayList<NodeInfo.AlertInfo> list = null;
        try {
            JSONObject jsonObject = new JSONObject(msg);
            JSONArray array = jsonObject.optJSONArray("data");
            if (array != null && array.length() > 0) {
                list = new ArrayList<NodeInfo.AlertInfo>();
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject object = array.getJSONObject(i);
                    if (object == null) continue;
                    list.add(new NodeInfo.AlertInfo(object.optString("title"), object.optString("message"), object.optString("link_text"), object.optString("link_url")));
                }
            }
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return list;
    }

    private void findWebNodes(JSONArray array, List<CommonNode> list, Map<String, NodeRect> hashMap) {
        try {
            if (array != null && array.length() > 0) {
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject object = array.optJSONObject(i);
                    CommonNode webNode = this.parseExtraNodesInfo(object);
                    webNode.setId(object.optString("id"));
                    webNode.set$element_content(object.optString("$element_content"));
                    webNode.setTop((float)object.optDouble("top"));
                    webNode.setLeft((float)object.optDouble("left"));
                    webNode.setScrollX((float)object.optDouble("scrollX"));
                    webNode.setScrollY((float)object.optDouble("scrollY"));
                    webNode.setWidth((float)object.optDouble("width"));
                    webNode.setHeight((float)object.optDouble("height"));
                    webNode.setLevel(object.optInt("level"));
                    webNode.set$element_path(object.optString("$element_path"));
                    webNode.set$element_position(object.optString("$element_position"));
                    webNode.setEnable_click(object.optBoolean("enable_click", true));
                    webNode.setIs_list_view(object.optBoolean("is_list_view"));
                    JSONArray subElementsArray = object.optJSONArray("subelements");
                    ArrayList<String> subViewIds = new ArrayList<String>();
                    if (subElementsArray != null && subElementsArray.length() > 0) {
                        for (int j = 0; j < subElementsArray.length(); ++j) {
                            String subElementsId = subElementsArray.optString(j);
                            if (TextUtils.isEmpty((CharSequence)subElementsId)) continue;
                            subViewIds.add(subElementsId);
                            if (hashMap.containsKey(subElementsId)) continue;
                            hashMap.put(subElementsId, new NodeRect(webNode.getTop(), webNode.getLeft()));
                        }
                    }
                    if (subViewIds.size() > 0) {
                        webNode.setSubelements(subViewIds);
                    }
                    list.add(webNode);
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    String getLastThirdMsg() {
        return this.mLastThirdNodeMsg;
    }

    void setHasThirdView(boolean hasWebView) {
        this.mHasWebView = hasWebView;
    }

    boolean hasThirdView() {
        return this.mHasWebView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyWebNodes(List<? extends CommonNode> webNodeList, Map<String, NodeRect> hashMap) {
        if (webNodeList == null || webNodeList.size() == 0) {
            return;
        }
        AbstractNodesManager abstractNodesManager = this;
        synchronized (abstractNodesManager) {
            for (CommonNode commonNode : webNodeList) {
                commonNode.setOriginLeft(commonNode.getLeft());
                commonNode.setOriginTop(commonNode.getTop());
                if (!hashMap.containsKey(commonNode.getId())) {
                    commonNode.setRootView(true);
                    float scrollY = 0.0f;
                    float scrollX = 0.0f;
                    if (!Float.isNaN(commonNode.getScrollY())) {
                        scrollY = commonNode.getScrollY();
                    }
                    if (!Float.isNaN(commonNode.getScrollX())) {
                        scrollX = commonNode.getScrollX();
                    }
                    commonNode.setTop(commonNode.getTop() + scrollY);
                    commonNode.setLeft(commonNode.getLeft() + scrollX);
                    continue;
                }
                NodeRect rect = hashMap.get(commonNode.getId());
                if (rect == null) continue;
                commonNode.setTop(commonNode.getTop() - rect.top);
                commonNode.setLeft(commonNode.getLeft() - rect.left);
            }
        }
    }

    static class NodeRect {
        public float top;
        public float left;

        public NodeRect(float top, float left) {
            this.top = top;
            this.left = left;
        }
    }
}

