/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.aop.push;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPIEmptyImplementation;
import com.sensorsdata.analytics.android.sdk.push.core.PushProcess;
import com.sensorsdata.analytics.android.sdk.push.utils.PushUtils;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import java.util.Date;
import org.json.JSONObject;

public class PushAutoTrackHelper {
    private static final String TAG = "SA.PushAutoTrackHelper";
    private static long lastPushClickTime = 0L;

    public static void trackJPushOpenActivity(Intent intent) {
        if (intent == null) {
            return;
        }
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        String data = null;
        if (intent.getData() != null) {
            data = intent.getData().toString();
        }
        if (TextUtils.isEmpty(data) && intent.getExtras() != null) {
            data = intent.getExtras().getString("JMessageExtra");
        }
        SALog.i((String)TAG, (String)("trackJPushOpenActivity is called, Intent data is " + data));
        if (TextUtils.isEmpty((CharSequence)data)) {
            return;
        }
        try {
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject(data);
            }
            catch (Exception e) {
                SALog.i((String)TAG, (String)"Failed to construct JSON");
            }
            if (jsonObject != null) {
                String title = jsonObject.optString("n_title");
                String content = jsonObject.optString("n_content");
                String extras = jsonObject.optString("n_extras");
                byte whichPushSDK = (byte)jsonObject.optInt("rom_type");
                String appPushChannel = PushUtils.getJPushSDKName(whichPushSDK);
                SALog.i((String)TAG, (String)String.format("trackJPushOpenActivity is called, title is %s, content is %s, extras is %s, appPushChannel is %s", title, content, extras, appPushChannel));
                if (TextUtils.isEmpty((CharSequence)title) || TextUtils.isEmpty((CharSequence)content) || TextUtils.isEmpty((CharSequence)appPushChannel)) {
                    return;
                }
                String sfData = PushAutoTrackHelper.getSFData(extras);
                PushAutoTrackHelper.trackNotificationOpenedEvent(sfData, title, content, "JPush", appPushChannel);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void trackNotificationOpenedEvent(String sfData, String title, String content, String appPushServiceName, String appPushChannel) {
        PushAutoTrackHelper.trackNotificationOpenedEvent(sfData, title, content, appPushServiceName, appPushChannel, 0L);
    }

    private static void trackNotificationOpenedEvent(String sfData, String title, String content, String appPushServiceName, String appPushChannel, long time) {
        try {
            if (PushAutoTrackHelper.isRepeatEvent()) {
                SALog.i((String)TAG, (String)String.format("$AppPushClick Repeat trigger, title is %s, content is %s, extras is %s, appPushChannel is %s, appPushServiceName is %s", title, content, sfData, appPushChannel, appPushServiceName));
                return;
            }
            JSONObject eventProperties = new JSONObject();
            eventProperties.put("$app_push_msg_title", (Object)title);
            eventProperties.put("$app_push_msg_content", (Object)content);
            eventProperties.put("$app_push_service_name", (Object)appPushServiceName);
            if (!TextUtils.isEmpty((CharSequence)appPushChannel)) {
                eventProperties.put("$app_push_channel", (Object)appPushChannel.toUpperCase());
            }
            try {
                JSONObject sfDataProperties = null;
                if (!TextUtils.isEmpty((CharSequence)sfData)) {
                    try {
                        SALog.i((String)TAG, (String)("sfData is " + sfData));
                        sfDataProperties = new JSONObject(sfData);
                    }
                    catch (Exception e) {
                        SALog.i((String)TAG, (String)"Failed to construct JSON");
                    }
                }
                if (sfDataProperties != null && sfDataProperties.has("sf_plan_id")) {
                    eventProperties.put("$sf_msg_title", (Object)title);
                    eventProperties.put("$sf_msg_content", (Object)content);
                    eventProperties.put("$sf_msg_id", sfDataProperties.opt("sf_msg_id"));
                    eventProperties.put("$sf_plan_id", sfDataProperties.opt("sf_plan_id"));
                    eventProperties.put("$sf_audience_id", sfDataProperties.opt("sf_audience_id"));
                    eventProperties.put("$sf_link_url", sfDataProperties.opt("sf_link_url"));
                    eventProperties.put("$sf_plan_strategy_id", sfDataProperties.opt("sf_plan_strategy_id"));
                    eventProperties.put("$sf_plan_type", sfDataProperties.opt("sf_plan_type"));
                    eventProperties.put("$sf_strategy_unit_id", sfDataProperties.opt("sf_strategy_unit_id"));
                    eventProperties.put("$sf_enter_plan_time", sfDataProperties.opt("sf_enter_plan_time"));
                    eventProperties.put("$sf_channel_id", sfDataProperties.opt("sf_channel_id"));
                    eventProperties.put("$sf_channel_category", sfDataProperties.opt("sf_channel_category"));
                    eventProperties.put("$sf_channel_service_name", sfDataProperties.opt("sf_channel_service_name"));
                }
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
            try {
                if (time > 0L) {
                    eventProperties.put("$time", (Object)new Date(time));
                }
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
            SensorsDataAPI.sharedInstance().track("$AppPushClick", eventProperties);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void trackGeTuiNotificationClicked(String title, String content, String sfData, long time) {
        PushAutoTrackHelper.trackNotificationOpenedEvent(sfData, title, content, "GeTui", null, time);
    }

    private static boolean isRepeatEvent() {
        long currentTime = SystemClock.elapsedRealtime();
        SALog.i((String)TAG, (String)("currentTime: " + currentTime + ",lastPushClickTime: " + lastPushClickTime));
        if (currentTime - lastPushClickTime > 2000L) {
            lastPushClickTime = currentTime;
            return false;
        }
        return true;
    }

    public static void trackJPushAppOpenNotification(String extras, String title, String content, String appPushChannel) {
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        SALog.i((String)TAG, (String)String.format("trackJPushAppOpenNotification is called, title is %s, content is %s, extras is %s, appPushChannel is %s, appPushServiceName is %s", title, content, extras, appPushChannel, "JPush"));
        String sfData = PushAutoTrackHelper.getSFData(extras);
        PushAutoTrackHelper.trackNotificationOpenedEvent(sfData, title, content, "JPush", appPushChannel);
    }

    public static void trackMeizuAppOpenNotification(String extras, String title, String content, String appPushServiceName) {
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        SALog.i((String)TAG, (String)String.format("trackMeizuAppOpenNotification is called, title is %s, content is %s, extras is %s, appPushChannel is %s, appPushServiceName is %s", title, content, extras, "Meizu", appPushServiceName));
        try {
            String nExtras = extras;
            try {
                JSONObject extrasJson = null;
                try {
                    extrasJson = new JSONObject(extras);
                }
                catch (Exception e) {
                    SALog.i((String)TAG, (String)"Failed to construct JSON");
                }
                if (extrasJson != null && extrasJson.has("JMessageExtra")) {
                    JSONObject contentJson;
                    JSONObject jMessageJson = extrasJson.optJSONObject("JMessageExtra");
                    if (jMessageJson != null && (contentJson = jMessageJson.optJSONObject("m_content")) != null) {
                        nExtras = contentJson.optString("n_extras");
                    }
                    appPushServiceName = "JPush";
                }
            }
            catch (Exception e) {
                SALog.printStackTrace((Exception)e);
            }
            String sfData = PushAutoTrackHelper.getSFData(nExtras);
            PushAutoTrackHelper.trackNotificationOpenedEvent(sfData, title, content, appPushServiceName, "Meizu");
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void onGeTuiNotificationClicked(Object gtNotificationMessage) {
        if (gtNotificationMessage == null) {
            SALog.i((String)TAG, (String)"gtNotificationMessage is null");
            return;
        }
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        try {
            String msgId = (String)ReflectUtil.callMethod((Object)gtNotificationMessage, (String)"getMessageId", (Object[])new Object[0]);
            String title = (String)ReflectUtil.callMethod((Object)gtNotificationMessage, (String)"getTitle", (Object[])new Object[0]);
            String content = (String)ReflectUtil.callMethod((Object)gtNotificationMessage, (String)"getContent", (Object[])new Object[0]);
            if (!(TextUtils.isEmpty((CharSequence)msgId) || TextUtils.isEmpty((CharSequence)title) || TextUtils.isEmpty((CharSequence)content))) {
                PushProcess.getInstance().trackGTClickDelayed(msgId, title, content);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void onGeTuiReceiveMessageData(Object gtTransmitMessage) {
        if (gtTransmitMessage == null) {
            SALog.i((String)TAG, (String)"gtNotificationMessage is null");
            return;
        }
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        try {
            byte[] bytes = (byte[])ReflectUtil.callMethod((Object)gtTransmitMessage, (String)"getPayload", (Object[])new Object[0]);
            String msgId = (String)ReflectUtil.callMethod((Object)gtTransmitMessage, (String)"getMessageId", (Object[])new Object[0]);
            if (bytes != null && !TextUtils.isEmpty((CharSequence)msgId)) {
                String sfData = new String(bytes);
                PushProcess.getInstance().trackReceiveMessageData(sfData, msgId);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void onUMengNotificationClick(Object UMessage) {
        if (UMessage == null) {
            SALog.i((String)TAG, (String)"UMessage is null");
            return;
        }
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        try {
            JSONObject raw = (JSONObject)ReflectUtil.callMethod((Object)UMessage, (String)"getRaw", (Object[])new Object[0]);
            if (raw == null) {
                SALog.i((String)TAG, (String)"onUMengNotificationClick:raw is null");
                return;
            }
            JSONObject body = raw.optJSONObject("body");
            if (body != null) {
                String extra = raw.optString("extra");
                String title = body.optString("title");
                String content = body.optString("text");
                String sfData = PushAutoTrackHelper.getSFData(extra);
                PushAutoTrackHelper.trackNotificationOpenedEvent(sfData, title, content, "UMeng", null);
                SALog.i((String)TAG, (String)String.format("onUMengNotificationClick is called, title is %s, content is %s, extras is %s", title, content, extra));
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void onUMengActivityMessage(Intent intent) {
        if (intent == null) {
            SALog.i((String)TAG, (String)"intent is null");
            return;
        }
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        try {
            JSONObject raw;
            JSONObject body;
            String intentBody = intent.getStringExtra("body");
            if (!TextUtils.isEmpty((CharSequence)intentBody) && (body = (raw = new JSONObject(intentBody)).optJSONObject("body")) != null) {
                String extra = raw.optString("extra");
                String title = body.optString("title");
                String content = body.optString("text");
                String messageSource = intent.getStringExtra("message_source");
                String sfData = PushAutoTrackHelper.getSFData(extra);
                PushAutoTrackHelper.trackNotificationOpenedEvent(sfData, title, content, "UMeng", messageSource);
                SALog.i((String)TAG, (String)String.format("onUMengActivityMessage is called, title is %s, content is %s, extras is %s", title, content, extra));
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void onNotify(NotificationManager manager, String tag, int id, Notification notification) {
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        try {
            PushProcess.getInstance().onNotify(tag, id, notification);
            SALog.i((String)TAG, (String)"onNotify");
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void onNotify(NotificationManager manager, int id, Notification notification) {
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        try {
            PushAutoTrackHelper.onNotify(manager, null, id, notification);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void onNewIntent(Object activity, Intent intent) {
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        try {
            if (activity instanceof Activity) {
                PushProcess.getInstance().onNotificationClick((Context)((Activity)activity), intent);
                SALog.i((String)TAG, (String)"onNewIntent");
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static void hookPendingIntentGetActivityBundle(PendingIntent pendingIntent, Context context, int requestCode, Intent intent, int flags, Bundle bundle) {
        PushAutoTrackHelper.hookPendingIntent(intent, pendingIntent);
    }

    public static void hookIntentGetActivity(Context context, int requestCode, Intent intent, int flags) {
        PushAutoTrackHelper.hookIntent(intent);
    }

    public static void hookIntentGetActivityBundle(Context context, int requestCode, Intent intent, int flags, Bundle bundle) {
        PushAutoTrackHelper.hookIntent(intent);
    }

    public static void hookPendingIntentGetActivity(PendingIntent pendingIntent, Context context, int requestCode, Intent intent, int flags) {
        PushAutoTrackHelper.hookPendingIntent(intent, pendingIntent);
    }

    public static void onBroadcastReceiver(BroadcastReceiver receiver, Context context, Intent intent) {
        PushAutoTrackHelper.onBroadcastServiceIntent(intent);
    }

    public static void onServiceStart(Service service, Intent intent, int startId) {
        PushAutoTrackHelper.onBroadcastServiceIntent(intent);
    }

    public static void onServiceStartCommand(Service service, Intent intent, int flags, int startId) {
        PushAutoTrackHelper.onBroadcastServiceIntent(intent);
    }

    public static void hookIntentGetBroadcast(Context context, int requestCode, Intent intent, int flags) {
        PushAutoTrackHelper.hookIntent(intent);
    }

    public static void hookPendingIntentGetBroadcast(PendingIntent pendingIntent, Context context, int requestCode, Intent intent, int flags) {
        PushAutoTrackHelper.hookPendingIntent(intent, pendingIntent);
    }

    public static void hookIntentGetService(Context context, int requestCode, Intent intent, int flags) {
        PushAutoTrackHelper.hookIntent(intent);
    }

    public static void hookPendingIntentGetService(PendingIntent pendingIntent, Context context, int requestCode, Intent intent, int flags) {
        PushAutoTrackHelper.hookPendingIntent(intent, pendingIntent);
    }

    public static void hookIntentGetForegroundService(Context context, int requestCode, Intent intent, int flags) {
        PushAutoTrackHelper.hookIntent(intent);
    }

    public static void hookPendingIntentGetForegroundService(PendingIntent pendingIntent, Context context, int requestCode, Intent intent, int flags) {
        PushAutoTrackHelper.hookPendingIntent(intent, pendingIntent);
    }

    private static void hookPendingIntent(Intent intent, PendingIntent pendingIntent) {
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        try {
            PushProcess.getInstance().hookPendingIntent(intent, pendingIntent);
            SALog.i((String)TAG, (String)"hookPendingIntent");
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private static void onBroadcastServiceIntent(Intent intent) {
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        try {
            PushProcess.getInstance().onNotificationClick(null, intent);
            SALog.i((String)TAG, (String)"onBroadcastServiceIntent");
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private static void hookIntent(Intent intent) {
        if (!PushAutoTrackHelper.isTrackPushEnabled()) {
            return;
        }
        try {
            PushProcess.getInstance().hookIntent(intent);
            SALog.i((String)TAG, (String)"hookIntent");
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    private static boolean isTrackPushEnabled() {
        try {
            if (SensorsDataAPI.sharedInstance() instanceof SensorsDataAPIEmptyImplementation || SensorsDataAPI.getConfigOptions() == null || !SensorsDataAPI.getConfigOptions().isEnableTrackPush()) {
                SALog.i((String)TAG, (String)"SDK or push disabled.");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return false;
        }
    }

    private static String getSFData(String extras) {
        String sfData = null;
        try {
            JSONObject sfDataJson = new JSONObject(extras);
            sfData = sfDataJson.optString("sf_data");
        }
        catch (Exception e) {
            SALog.i((String)TAG, (String)"get sf_data failed");
        }
        return sfData;
    }
}

