/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.exposure;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.business.exposure.SAExposureListener;
import com.sensorsdata.analytics.android.sdk.exposure.ExposureView;
import com.sensorsdata.analytics.android.sdk.util.Dispatcher;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewNode;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewTreeStatusObservable;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class StayDurationRunnable
implements Runnable {
    private final ExposureView mExposureView;
    private static final String TAG = "SA.StayDurationRunnable";

    public StayDurationRunnable(ExposureView exposureView) {
        this.mExposureView = exposureView;
    }

    @Override
    public void run() {
        try {
            String viewText;
            if (!this.shouldExposure(this.mExposureView)) {
                return;
            }
            JSONObject exposureProperties = this.mExposureView.getExposureData().getProperties();
            JSONObject jsonObject = exposureProperties == null ? new JSONObject() : new JSONObject(exposureProperties.toString());
            View view = this.mExposureView.getView();
            if (view == null) {
                return;
            }
            Activity activity = SAViewUtils.getActivityOfView((Context)view.getContext(), (View)view);
            if (activity != null) {
                SALog.i((String)TAG, (String)"activity is not null.");
                JSONObject activityProperty = SAViewUtils.getScreenNameAndTitle((View)view);
                if (activityProperty == null || TextUtils.isEmpty((CharSequence)activityProperty.toString())) {
                    activityProperty = SAViewUtils.buildTitleAndScreenName((Activity)activity);
                }
                JSONUtils.mergeJSONObject((JSONObject)activityProperty, (JSONObject)jsonObject);
            }
            SALog.i((String)TAG, (String)("StayDurationRunnable:" + this.mExposureView));
            ViewNode viewNode = ViewTreeStatusObservable.getInstance().getViewNode(view);
            if (viewNode != null) {
                if (!TextUtils.isEmpty((CharSequence)viewNode.getViewPath())) {
                    jsonObject.put("$element_path", (Object)viewNode.getViewPath());
                }
                if (!TextUtils.isEmpty((CharSequence)viewNode.getViewPosition())) {
                    jsonObject.put("$element_position", (Object)viewNode.getViewPosition());
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(viewText = SAViewUtils.getViewContent((View)view)))) {
                jsonObject.put("$element_content", (Object)viewText);
            }
            jsonObject.put("$element_type", (Object)SAViewUtils.getViewType((View)view));
            String eventName = this.mExposureView.getExposureData().getEvent();
            SensorsDataAPI.sharedInstance().track(eventName, jsonObject);
            this.didExposure(this.mExposureView);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        this.mExposureView.setLastVisible(true);
        this.mExposureView.setExposed(true);
        this.mExposureView.setActivityChange(false);
    }

    private boolean shouldExposure(final ExposureView mExposureView) {
        try {
            final SAExposureListener exposureListener = mExposureView.getExposureData().getExposureListener();
            if (exposureListener != null) {
                FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return exposureListener.shouldExposure(mExposureView.getView(), mExposureView.getExposureData());
                    }
                });
                Dispatcher.getInstance().getUiThreadHandler().post(futureTask);
                if (!futureTask.get(3000L, TimeUnit.MILLISECONDS).booleanValue()) {
                    SALog.i((String)TAG, (String)"Exposure fail, shouldExposure is false");
                    return false;
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return true;
    }

    private void didExposure(final ExposureView mExposureView) {
        try {
            final SAExposureListener exposureListener = mExposureView.getExposureData().getExposureListener();
            if (exposureListener != null && Dispatcher.getInstance().getUiThreadHandler() != null) {
                Dispatcher.getInstance().getUiThreadHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        exposureListener.didExposure(mExposureView.getView(), mExposureView.getExposureData());
                    }
                });
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }
}

