/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.exposure;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewTreeObserver;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.exposure.AppPageChange;
import com.sensorsdata.analytics.android.sdk.exposure.ExposureView;
import com.sensorsdata.analytics.android.sdk.exposure.R;
import com.sensorsdata.analytics.android.sdk.exposure.SAExposedProcess;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataActivityLifecycleCallbacks;
import com.sensorsdata.analytics.android.sdk.util.WindowHelper;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewUtil;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;

public class ExposedTransform
implements SensorsDataActivityLifecycleCallbacks.SAActivityLifecycleCallbacks {
    private final String TAG = "SA.ExposedTransform";
    private final AppPageChange mAppPageChange;
    private final SAExposedProcess.CallBack mCallBack;
    private WeakReference<Activity> mActivityWeakReference;
    private volatile boolean isMonitor = false;
    private boolean isResumedLayoutChanged;
    private volatile int windowCount = -1;

    public void onNewIntent(Intent intent) {
    }

    public synchronized void observerWindow(Activity activity) {
        int originWindowCount = this.windowCount;
        View[] views = this.processViews();
        SALog.i((String)"SA.ExposedTransform", (String)("originWindowCount:" + originWindowCount + ",windowCount:" + this.windowCount));
        if (originWindowCount != this.windowCount) {
            this.viewsRemoveTreeObserver(activity, views);
            this.onActivityResumed(activity);
            return;
        }
        if (!this.isMonitor) {
            this.onActivityResumed(activity);
        }
    }

    private View[] processViews() {
        try {
            WindowHelper.init();
            View[] views = WindowHelper.getSortedWindowViews();
            this.windowCount = views.length > 0 ? views.length : 0;
            return views;
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return null;
        }
    }

    public ExposedTransform(final SAExposedProcess.CallBack callBack) {
        this.mCallBack = callBack;
        LayoutCallBack layoutCallBack = new LayoutCallBack(){

            @Override
            public void viewLayoutChange() {
                Activity activity;
                if (ExposedTransform.this.mActivityWeakReference != null && (activity = (Activity)ExposedTransform.this.mActivityWeakReference.get()) != null && ExposedTransform.this.isViewChanged(activity)) {
                    ExposedTransform.this.isResumedLayoutChanged = false;
                    callBack.viewLayoutChange(activity);
                }
            }
        };
        this.mAppPageChange = new AppPageChange(layoutCallBack);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.mActivityWeakReference = new WeakReference<Activity>(activity);
    }

    public void onActivityStarted(Activity activity) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityResumed(Activity activity) {
        this.mActivityWeakReference = new WeakReference<Activity>(activity);
        this.isResumedLayoutChanged = true;
        SALog.i((String)"SA.ExposedTransform", (String)("onActivityResumed:" + activity));
        ExposedTransform exposedTransform = this;
        synchronized (exposedTransform) {
            this.viewsAddTreeObserver(activity);
            this.mCallBack.onActivityResumed(activity);
        }
    }

    private void viewTreeObserver(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mAppPageChange);
        if (Build.VERSION.SDK_INT >= 18) {
            viewTreeObserver.addOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this.mAppPageChange);
        }
        viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this.mAppPageChange);
        viewTreeObserver.addOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this.mAppPageChange);
    }

    private void viewRemoveTreeObserver(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mAppPageChange);
        if (Build.VERSION.SDK_INT >= 18) {
            viewTreeObserver.removeOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this.mAppPageChange);
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this.mAppPageChange);
        viewTreeObserver.removeOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this.mAppPageChange);
    }

    private void viewsAddTreeObserver(Activity activity) {
        SALog.i((String)"SA.ExposedTransform", (String)("viewsAddTreeObserver:" + this.isMonitor));
        if (!this.isMonitor) {
            if (this.mCallBack.getExposureViewSize(activity) <= 0) {
                return;
            }
            this.processViews();
            boolean flag = true;
            View[] views = WindowHelper.getSortedWindowViews();
            View decorView = activity.getWindow().getDecorView();
            if (views != null && views.length > 0) {
                for (View view : views) {
                    if (decorView == view) {
                        flag = false;
                    }
                    this.viewTreeObserver(view);
                }
                if (flag) {
                    this.viewTreeObserver(decorView);
                }
            } else {
                this.viewTreeObserver(activity.getWindow().getDecorView());
            }
            this.isMonitor = true;
        }
    }

    private void viewsRemoveTreeObserver(Activity activity, View[] views) {
        SALog.i((String)"SA.ExposedTransform", (String)("viewsRemoveTreeObserver:" + this.isMonitor));
        if (this.isMonitor) {
            this.isMonitor = false;
            if (views == null) {
                views = WindowHelper.getSortedWindowViews();
            }
            if (views != null && views.length > 0) {
                for (View view : views) {
                    this.viewRemoveTreeObserver(view);
                }
            } else {
                this.viewRemoveTreeObserver(activity.getWindow().getDecorView());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityPaused(Activity activity) {
        SALog.i((String)"SA.ExposedTransform", (String)"onActivityPaused");
        ExposedTransform exposedTransform = this;
        synchronized (exposedTransform) {
            this.viewsRemoveTreeObserver(activity, null);
            this.mCallBack.onActivityPaused(activity);
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    private boolean isViewChanged(Activity activity) {
        try {
            Collection<ExposureView> exposureViews = this.mCallBack.getExposureViews(activity);
            if (exposureViews == null || exposureViews.isEmpty()) {
                return false;
            }
            Iterator<ExposureView> iterator = exposureViews.iterator();
            boolean isViewChanged = false;
            while (iterator.hasNext()) {
                try {
                    ExposureView exposureView = iterator.next();
                    View view = exposureView.getView();
                    int[] size = new int[2];
                    view.getLocationOnScreen(size);
                    String tempState = (String)view.getTag(R.id.sensors_analytics_tag_view_exposure_key);
                    String newState = size[0] + "," + size[1] + "," + ViewUtil.viewVisibilityInParents((View)view);
                    if (!newState.equals(tempState) || this.isResumedLayoutChanged) {
                        SALog.i((String)"SA.ExposedTransform", (String)(tempState + ", newSize = " + newState + ",view = " + view));
                        isViewChanged = true;
                        exposureView.setViewLayoutChange(true);
                    }
                    view.setTag(R.id.sensors_analytics_tag_view_exposure_key, (Object)newState);
                }
                catch (Exception exception) {
                    SALog.printStackTrace((Exception)exception);
                }
            }
            return isViewChanged;
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return true;
        }
    }

    static interface LayoutCallBack {
        public void viewLayoutChange();
    }
}

