/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.encrypt.biz;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.encrypt.SAEncryptListener;
import com.sensorsdata.analytics.android.sdk.encrypt.SecreteKey;
import com.sensorsdata.analytics.android.sdk.encrypt.biz.SecretKeyManager;
import java.io.ByteArrayOutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class SAEventEncryptTools {
    private SecreteKey mSecreteKey;
    private final SecretKeyManager mSecretKeyManager;

    public SAEventEncryptTools(SAContextManager contextManager) {
        this.mSecretKeyManager = SecretKeyManager.getInstance(contextManager);
    }

    public SAEncryptListener getEncryptListener() {
        try {
            if (this.mSecretKeyManager.isSecretKeyNull(this.mSecreteKey)) {
                this.mSecreteKey = this.mSecretKeyManager.loadSecretKey();
                if (this.mSecretKeyManager.isSecretKeyNull(this.mSecreteKey)) {
                    return null;
                }
            }
            return this.mSecretKeyManager.getEncryptListener(this.mSecreteKey);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return null;
        }
    }

    public <T> T encryptTrackData(T jsonObject) {
        try {
            String encryptedKey;
            SAEncryptListener mEncryptListener;
            if (this.mSecretKeyManager.isSecretKeyNull(this.mSecreteKey)) {
                this.mSecreteKey = this.mSecretKeyManager.loadSecretKey();
                if (this.mSecretKeyManager.isSecretKeyNull(this.mSecreteKey)) {
                    return jsonObject;
                }
            }
            if ((mEncryptListener = this.mSecretKeyManager.getEncryptListener(this.mSecreteKey)) == null) {
                return jsonObject;
            }
            String publicKey = this.mSecreteKey.key;
            if (publicKey.startsWith("EC:")) {
                publicKey = publicKey.substring(publicKey.indexOf(":") + 1);
            }
            if (TextUtils.isEmpty((CharSequence)(encryptedKey = mEncryptListener.encryptSymmetricKeyWithPublicKey(publicKey)))) {
                return jsonObject;
            }
            String encryptData = mEncryptListener.encryptEvent(this.gzipEventData(jsonObject.toString()));
            if (TextUtils.isEmpty((CharSequence)encryptData)) {
                return jsonObject;
            }
            JSONObject dataJson = new JSONObject();
            dataJson.put("ekey", (Object)encryptedKey);
            dataJson.put("pkv", this.mSecreteKey.version);
            dataJson.put("payloads", (Object)encryptData);
            return (T)(jsonObject instanceof String ? dataJson.toString() : dataJson);
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
            return jsonObject;
        }
    }

    public <T> T encryptTrackData(T jsonObject, SecreteKey secreteKey) {
        try {
            String encryptedKey;
            if (this.mSecretKeyManager.isSecretKeyNull(secreteKey)) {
                return jsonObject;
            }
            SAEncryptListener mEncryptListener = this.mSecretKeyManager.getEncryptListener(secreteKey);
            if (mEncryptListener == null) {
                return jsonObject;
            }
            String publicKey = secreteKey.key;
            if (publicKey.startsWith("EC:")) {
                publicKey = publicKey.substring(publicKey.indexOf(":") + 1);
            }
            if (TextUtils.isEmpty((CharSequence)(encryptedKey = mEncryptListener.encryptSymmetricKeyWithPublicKey(publicKey)))) {
                return jsonObject;
            }
            String encryptData = mEncryptListener.encryptEvent(this.gzipEventData(jsonObject.toString()));
            if (TextUtils.isEmpty((CharSequence)encryptData)) {
                return jsonObject;
            }
            JSONObject dataJson = new JSONObject();
            dataJson.put("ekey", (Object)encryptedKey);
            dataJson.put("pkv", secreteKey.version);
            JSONArray dataArray = new JSONArray();
            dataArray.put((Object)encryptData);
            dataJson.put("payloads", (Object)dataArray);
            return (T)(jsonObject instanceof String ? dataJson.toString() : dataJson);
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
            return jsonObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] gzipEventData(String record) {
        DeflaterOutputStream gzipOutputStream = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            gzipOutputStream = new GZIPOutputStream(buffer);
            gzipOutputStream.write(record.getBytes());
            ((GZIPOutputStream)gzipOutputStream).finish();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            SALog.printStackTrace((Exception)ex);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (gzipOutputStream != null) {
                try {
                    gzipOutputStream.close();
                }
                catch (Exception ex) {
                    SALog.printStackTrace((Exception)ex);
                }
            }
        }
    }
}

