/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.encrypt;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.util.Base64Coder;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESSecretManager {
    private static final String TAG = "SA.AESSecretManager";
    private static final byte[] ZERO_IV = new byte[16];
    private static final String CBC_PKCS5_PADDING = "AES/CBC/PKCS5Padding";
    private static final String ALGORITHM = "AES";
    private static final String CHARSET_NAME = "UTF-8";
    private static final String SECRET_KEY_FILE = "com.sensorsdata.analytics.android.sdk.other";
    private String mAESSecret;

    private AESSecretManager() {
    }

    public static AESSecretManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void initSecretKey(Context context) {
        SharedPreferences secretSp = context.getSharedPreferences(SECRET_KEY_FILE, 0);
        this.mAESSecret = secretSp.getString(Base64Coder.encodeString((String)"sa_sp_encrypt_secret_key"), "");
        if (TextUtils.isEmpty((CharSequence)this.mAESSecret)) {
            this.mAESSecret = this.generateAESKey();
            secretSp.edit().putString(Base64Coder.encodeString((String)"sa_sp_encrypt_secret_key"), this.mAESSecret).apply();
        }
    }

    private String generateAESKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(ALGORITHM);
            keyGen.init(128);
            SecretKey secretKey = keyGen.generateKey();
            return new String(Base64Coder.encode((byte[])secretKey.getEncoded()));
        }
        catch (Exception e) {
            SALog.i((String)TAG, (String)("generateAESKey fail, msg: " + e));
            return "";
        }
    }

    private SecretKey strKey2SecretKey(String strKey) {
        byte[] bytes = Base64Coder.decode((String)strKey);
        return new SecretKeySpec(bytes, ALGORITHM);
    }

    public String encryptAES(String content) {
        try {
            if (content == null || TextUtils.isEmpty((CharSequence)this.mAESSecret)) {
                return content;
            }
            Cipher cipher = Cipher.getInstance(CBC_PKCS5_PADDING);
            IvParameterSpec zeroIv = new IvParameterSpec(ZERO_IV);
            cipher.init(1, (Key)this.strKey2SecretKey(this.mAESSecret), zeroIv);
            return new String(Base64Coder.encode((byte[])cipher.doFinal(content.getBytes(CHARSET_NAME))));
        }
        catch (Exception e) {
            SALog.i((String)TAG, (String)("encryptAES fail, msg: " + e));
            return "";
        }
    }

    public String decryptAES(String content) {
        try {
            if (content == null || TextUtils.isEmpty((CharSequence)this.mAESSecret)) {
                return content;
            }
            Cipher cipher = Cipher.getInstance(CBC_PKCS5_PADDING);
            IvParameterSpec zeroIv = new IvParameterSpec(ZERO_IV);
            cipher.init(2, (Key)this.strKey2SecretKey(this.mAESSecret), zeroIv);
            return new String(cipher.doFinal(Base64Coder.decode((String)content)), CHARSET_NAME);
        }
        catch (Exception e) {
            SALog.i((String)TAG, (String)("decryptAES fail, msg: " + e));
            return "";
        }
    }

    private static class SingletonHolder {
        private static final AESSecretManager INSTANCE = new AESSecretManager();

        private SingletonHolder() {
        }
    }
}

