/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.encrypt.impl;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.encrypt.AESSecretManager;
import com.sensorsdata.analytics.android.sdk.encrypt.R;
import com.sensorsdata.analytics.android.sdk.encrypt.SAEncryptListener;
import com.sensorsdata.analytics.android.sdk.encrypt.SecreteKey;
import com.sensorsdata.analytics.android.sdk.encrypt.biz.SAEventEncryptTools;
import com.sensorsdata.analytics.android.sdk.encrypt.biz.SecretKeyManager;
import com.sensorsdata.analytics.android.sdk.encrypt.impl.AbsSAEncrypt;
import com.sensorsdata.analytics.android.sdk.encrypt.impl.SAEncryptAPI;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import org.json.JSONException;

public class SAEncryptAPIImpl
implements SAEncryptAPI {
    private static final String TAG = "SA.EncryptAPIImpl";
    private SAContextManager mSAContextManager;
    private SAEventEncryptTools mSensorsDataEncrypt;
    private SecretKeyManager mSecretKeyManager;

    public SAEncryptAPIImpl(SAContextManager contextManager) {
        try {
            this.mSAContextManager = contextManager;
            SAConfigOptions configOptions = contextManager.getInternalConfigs().saConfigOptions;
            if (configOptions.isEnableEncrypt() || configOptions.isTransportEncrypt()) {
                this.mSensorsDataEncrypt = new SAEventEncryptTools(contextManager);
                this.mSecretKeyManager = SecretKeyManager.getInstance(contextManager);
                AESSecretManager.getInstance().initSecretKey(contextManager.getContext());
            } else if (configOptions.getAdvertConfig() != null && configOptions.getAdvertConfig().secreteKey != null) {
                this.mSensorsDataEncrypt = new SAEventEncryptTools(contextManager);
            }
            if (configOptions.getStorePlugins() != null && !configOptions.getStorePlugins().isEmpty()) {
                AESSecretManager.getInstance().initSecretKey(contextManager.getContext());
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public <T> T invokeModuleFunction(String methodName, Object ... argv) {
        try {
            if ("encryptAES".equals(methodName)) {
                return (T)this.encryptAES((String)argv[0]);
            }
            if ("decryptAES".equals(methodName)) {
                return (T)this.decryptAES((String)argv[0]);
            }
            if ("verifySecretKey".equals(methodName)) {
                return (T)this.verifySecretKey((Uri)argv[0]);
            }
            if ("encryptEventData".equals(methodName)) {
                return (T)this.encryptEventData(argv[0]);
            }
            if ("encryptEventDataWithKey".equals(methodName)) {
                return (T)this.encryptEventData(argv[0], (SecreteKey)argv[1]);
            }
            if ("storeSecretKey".equals(methodName)) {
                this.storeSecretKey((String)argv[0]);
            } else {
                SAEncryptListener encryptListener;
                if ("loadSecretKey".equals(methodName)) {
                    return (T)this.loadSecretKey();
                }
                if ("supportTransportEncrypt".equals(methodName)) {
                    return (T)this.mSecretKeyManager.isSupportTransportEncrypt();
                }
                if ("storeEvent".equals(methodName)) {
                    SAEncryptListener encryptListener2 = this.mSensorsDataEncrypt.getEncryptListener();
                    if (encryptListener2 instanceof AbsSAEncrypt) {
                        return (T)((AbsSAEncrypt)encryptListener2).encryptEventRecord((String)argv[0]);
                    }
                } else if ("loadEvent".equals(methodName) && (encryptListener = this.mSensorsDataEncrypt.getEncryptListener()) instanceof AbsSAEncrypt) {
                    return (T)((AbsSAEncrypt)encryptListener).decryptEventRecord((String)argv[0]);
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return null;
    }

    @Override
    public String encryptAES(String content) {
        return AESSecretManager.getInstance().encryptAES(content);
    }

    @Override
    public String decryptAES(String content) {
        return AESSecretManager.getInstance().decryptAES(content);
    }

    @Override
    public <T> T encryptEventData(T jsonObject) {
        return this.mSensorsDataEncrypt.encryptTrackData(jsonObject);
    }

    @Override
    public <T> T encryptEventData(T jsonObject, SecreteKey secreteKey) {
        if (this.mSensorsDataEncrypt == null) {
            return jsonObject;
        }
        return this.mSensorsDataEncrypt.encryptTrackData(jsonObject, secreteKey);
    }

    @Override
    public String verifySecretKey(Uri uri) {
        String version = uri.getQueryParameter("v");
        String key = Uri.decode((String)uri.getQueryParameter("key"));
        String symmetricEncryptType = Uri.decode((String)uri.getQueryParameter("symmetricEncryptType"));
        String asymmetricEncryptType = Uri.decode((String)uri.getQueryParameter("asymmetricEncryptType"));
        SALog.i((String)TAG, (String)("Encrypt, version = " + version + ", key = " + key + ", symmetricEncryptType = " + symmetricEncryptType + ", asymmetricEncryptType = " + asymmetricEncryptType));
        String tip = TextUtils.isEmpty((CharSequence)version) || TextUtils.isEmpty((CharSequence)key) ? SADisplayUtil.getStringResource((Context)this.mSAContextManager.getContext(), (int)R.string.sensors_analytics_encrypt_fail) : (this.mSecretKeyManager != null ? this.mSecretKeyManager.checkPublicSecretKey(this.mSAContextManager.getContext(), version, key, symmetricEncryptType, asymmetricEncryptType) : SADisplayUtil.getStringResource((Context)this.mSAContextManager.getContext(), (int)R.string.sensors_analytics_encrypt_disable));
        return tip;
    }

    @Override
    public void storeSecretKey(String secretKeyJson) {
        SecretKeyManager.getInstance(this.mSAContextManager).storeSecretKey(secretKeyJson);
    }

    @Override
    public String loadSecretKey() {
        try {
            SecreteKey secreteKey = this.mSecretKeyManager.loadSecretKey();
            SAEncryptListener mEncryptListener = this.mSecretKeyManager.getEncryptListener(secreteKey);
            if (mEncryptListener == null) {
                return "";
            }
            return secreteKey.toString();
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
            return null;
        }
    }
}

