/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Rect;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.RatingBar;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.ToggleButton;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.util.AppStateTools;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.Pathfinder;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import com.sensorsdata.analytics.android.sdk.util.SAFragmentUtils;
import com.sensorsdata.analytics.android.sdk.util.SAPageInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import com.sensorsdata.analytics.android.sdk.util.SnapCache;
import com.sensorsdata.analytics.android.sdk.util.WindowHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;

public class SAViewUtils {
    private static final String TAG = "SA.SAViewUtils";
    private static List<String> sOSViewPackage = new LinkedList<String>(){
        {
            this.add("android##widget");
            this.add("android##support##v7##widget");
            this.add("android##support##design##widget");
            this.add("android##support##text##emoji##widget");
            this.add("androidx##appcompat##widget");
            this.add("androidx##emoji##widget");
            this.add("androidx##cardview##widget");
            this.add("com##google##android##material");
        }
    };

    public static String traverseView(StringBuilder stringBuilder, ViewGroup root) {
        try {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (root == null) {
                return stringBuilder.toString();
            }
            int childCount = root.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                String viewText;
                View child = root.getChildAt(i);
                if (child == null || child.getVisibility() != 0) continue;
                if (child instanceof ViewGroup) {
                    SAViewUtils.traverseView(stringBuilder, (ViewGroup)child);
                    continue;
                }
                if (SAViewUtils.isViewIgnored(child) || TextUtils.isEmpty((CharSequence)(viewText = SAViewUtils.getViewContent(child)))) continue;
                stringBuilder.append(viewText);
                stringBuilder.append("-");
            }
            return stringBuilder.toString();
        }
        catch (Throwable e) {
            SALog.i(TAG, e.getMessage());
            return stringBuilder != null ? stringBuilder.toString() : "";
        }
    }

    public static boolean isViewIgnored(View view) {
        try {
            if (view == null) {
                return true;
            }
            List<Class<?>> mIgnoredViewTypeList = SensorsDataAPI.sharedInstance().getIgnoredViewTypeList();
            if (mIgnoredViewTypeList != null) {
                for (Class<?> clazz : mIgnoredViewTypeList) {
                    if (!clazz.isAssignableFrom(view.getClass())) continue;
                    return true;
                }
            }
            return "1".equals(view.getTag(R.id.sensors_analytics_tag_view_ignored));
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return true;
        }
    }

    public static boolean isViewIgnored(Class<?> viewType) {
        try {
            if (viewType == null) {
                return true;
            }
            List<Class<?>> mIgnoredViewTypeList = SensorsDataAPI.sharedInstance().getIgnoredViewTypeList();
            if (!mIgnoredViewTypeList.isEmpty()) {
                for (Class<?> clazz : mIgnoredViewTypeList) {
                    if (!clazz.isAssignableFrom(viewType)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static String getViewTypeByReflect(View view) {
        String viewType = SnapCache.getInstance().getCanonicalName(view.getClass());
        Class<?> compatClass = ReflectUtil.getClassByName("android.widget.Switch");
        if (compatClass != null && compatClass.isInstance(view)) {
            return SAViewUtils.getViewType(viewType, "Switch");
        }
        compatClass = ReflectUtil.getClassByName("android.support.v7.widget.SwitchCompat");
        if (compatClass != null && compatClass.isInstance(view)) {
            return SAViewUtils.getViewType(viewType, "SwitchCompat");
        }
        compatClass = ReflectUtil.getClassByName("androidx.appcompat.widget.SwitchCompat");
        if (compatClass != null && compatClass.isInstance(view)) {
            return SAViewUtils.getViewType(viewType, "SwitchCompat");
        }
        return viewType;
    }

    public static Activity getActivityOfView(Context context, View view) {
        Activity activity = null;
        try {
            if (context != null) {
                Object object;
                if (context instanceof Activity) {
                    activity = (Activity)context;
                } else if (context instanceof ContextWrapper) {
                    while (!(context instanceof Activity) && context instanceof ContextWrapper) {
                        context = ((ContextWrapper)context).getBaseContext();
                    }
                    if (context instanceof Activity) {
                        activity = (Activity)context;
                    }
                }
                if (activity == null && view != null && (object = view.getTag(R.id.sensors_analytics_tag_view_activity)) != null && object instanceof Activity) {
                    activity = (Activity)object;
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return activity;
    }

    public static String getViewGroupTypeByReflect(View view) {
        String viewType = SnapCache.getInstance().getCanonicalName(view.getClass());
        Class<?> compatClass = ReflectUtil.getClassByName("android.support.v7.widget.CardView");
        if (compatClass != null && compatClass.isInstance(view)) {
            return SAViewUtils.getViewType(viewType, "CardView");
        }
        compatClass = ReflectUtil.getClassByName("androidx.cardview.widget.CardView");
        if (compatClass != null && compatClass.isInstance(view)) {
            return SAViewUtils.getViewType(viewType, "CardView");
        }
        compatClass = ReflectUtil.getClassByName("android.support.design.widget.NavigationView");
        if (compatClass != null && compatClass.isInstance(view)) {
            return SAViewUtils.getViewType(viewType, "NavigationView");
        }
        compatClass = ReflectUtil.getClassByName("com.google.android.material.navigation.NavigationView");
        if (compatClass != null && compatClass.isInstance(view)) {
            return SAViewUtils.getViewType(viewType, "NavigationView");
        }
        return viewType;
    }

    public static String getViewContent(View view) {
        return SAViewUtils.getViewContent(view, false);
    }

    public static String getViewContent(View view, boolean fromVisual) {
        try {
            if (view == null) {
                SALog.i(TAG, "getViewContent view is null");
                return "";
            }
            String cacheViewType = SnapCache.getInstance().getViewType(view);
            String cacheViewText = SnapCache.getInstance().getViewText(view);
            CharSequence viewText = null;
            if (cacheViewType == null || cacheViewText == null) {
                if (view instanceof CheckBox) {
                    CheckBox checkBox = (CheckBox)view;
                    viewText = checkBox.getText();
                } else if (view instanceof RadioButton) {
                    RadioButton radioButton = (RadioButton)view;
                    viewText = radioButton.getText();
                } else if (view instanceof ToggleButton) {
                    ToggleButton toggleButton = (ToggleButton)view;
                    boolean isChecked = toggleButton.isChecked();
                    viewText = isChecked ? toggleButton.getTextOn() : toggleButton.getTextOff();
                } else if (view instanceof CompoundButton) {
                    Class<?> switchCompatClass = null;
                    try {
                        switchCompatClass = ReflectUtil.getClassByName("android.support.v7.widget.SwitchCompat");
                    }
                    catch (Exception isChecked) {
                        // empty catch block
                    }
                    if (switchCompatClass == null) {
                        try {
                            switchCompatClass = ReflectUtil.getClassByName("androidx.appcompat.widget.SwitchCompat");
                        }
                        catch (Exception isChecked) {
                            // empty catch block
                        }
                    }
                    CompoundButton switchCompat = (CompoundButton)view;
                    if (switchCompatClass != null && switchCompatClass.isInstance(view) || view instanceof Switch) {
                        Method method = switchCompat.isChecked() ? view.getClass().getMethod("getTextOn", new Class[0]) : view.getClass().getMethod("getTextOff", new Class[0]);
                        viewText = (String)method.invoke((Object)view, new Object[0]);
                    } else {
                        viewText = switchCompat.getText();
                    }
                } else if (view instanceof Button) {
                    Button button = (Button)view;
                    viewText = button.getText();
                } else if (view instanceof CheckedTextView) {
                    CheckedTextView textView = (CheckedTextView)view;
                    viewText = textView.getText();
                } else if (view instanceof TextView) {
                    TextView textView = (TextView)view;
                    Object object = ReflectUtil.findField(new String[]{"androidx.appcompat.widget.AppCompatTextView"}, (Object)textView, "mPrecomputedTextFuture");
                    if (object == null) {
                        viewText = textView.getText();
                    }
                } else if (view instanceof ImageView) {
                    ImageView imageView = (ImageView)view;
                    if (!TextUtils.isEmpty((CharSequence)imageView.getContentDescription()) && !SAViewUtils.isWeexView(view)) {
                        viewText = imageView.getContentDescription().toString();
                    }
                } else if (view instanceof RatingBar) {
                    RatingBar ratingBar = (RatingBar)view;
                    viewText = String.valueOf(ratingBar.getRating());
                } else if (view instanceof SeekBar) {
                    SeekBar seekBar = (SeekBar)view;
                    viewText = String.valueOf(seekBar.getProgress());
                } else if (view instanceof Spinner) {
                    StringBuilder stringBuilder = new StringBuilder();
                    viewText = SAViewUtils.traverseView(stringBuilder, (ViewGroup)view);
                    if (!TextUtils.isEmpty((CharSequence)viewText)) {
                        viewText = viewText.toString().substring(0, viewText.length() - 1);
                    }
                } else {
                    Object tab = SAViewUtils.instanceOfTabView(view);
                    if (tab != null) {
                        viewText = SAViewUtils.getTabLayoutContent(tab);
                    } else if (SAViewUtils.instanceOfBottomNavigationItemView(view)) {
                        Object itemData = SAViewUtils.getMenuItemData(view);
                        if (itemData != null) {
                            try {
                                String title;
                                Class<?> menuItemImplClass = ReflectUtil.getCurrentClass(new String[]{"androidx.appcompat.view.menu.MenuItemImpl"});
                                if (menuItemImplClass != null && !TextUtils.isEmpty((CharSequence)(title = (String)ReflectUtil.findField(menuItemImplClass, itemData, "mTitle")))) {
                                    viewText = title;
                                }
                            }
                            catch (Exception exception) {}
                        }
                    } else if (SAViewUtils.instanceOfNavigationView(view)) {
                        viewText = SAViewUtils.isViewSelfVisible(view) ? "Open" : "Close";
                    } else if (view instanceof ViewGroup) {
                        if (!SAViewUtils.isWeexView(view)) {
                            viewText = view.getContentDescription();
                        }
                        if (TextUtils.isEmpty((CharSequence)viewText)) {
                            try {
                                StringBuilder stringBuilder = new StringBuilder();
                                viewText = SAViewUtils.traverseView(stringBuilder, (ViewGroup)view);
                                if (!TextUtils.isEmpty((CharSequence)viewText)) {
                                    viewText = viewText.toString().substring(0, viewText.length() - 1);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (TextUtils.isEmpty((CharSequence)viewText) && view instanceof TextView) {
                    viewText = ((TextView)view).getHint();
                }
                if (TextUtils.isEmpty((CharSequence)viewText) && (!SAViewUtils.isWeexView(view) || SAViewUtils.isWeexTextView(view))) {
                    viewText = view.getContentDescription();
                }
                if (viewText == null) {
                    viewText = "";
                }
                SnapCache.getInstance().setViewText(view, viewText.toString());
            } else {
                viewText = cacheViewText;
            }
            if (view instanceof EditText) {
                viewText = fromVisual ? ((EditText)view).getText() : "";
            }
            if (viewText == null) {
                viewText = "";
            }
            return viewText.toString();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return "";
        }
    }

    public static String getViewType(View view) {
        String viewType;
        String cacheViewType = SnapCache.getInstance().getViewType(view);
        if (cacheViewType == null) {
            viewType = SnapCache.getInstance().getCanonicalName(view.getClass());
            if (view instanceof CheckBox) {
                viewType = SAViewUtils.getViewType(viewType, "CheckBox");
            } else if (view instanceof RadioButton) {
                viewType = SAViewUtils.getViewType(viewType, "RadioButton");
            } else if (view instanceof ToggleButton) {
                viewType = SAViewUtils.getViewType(viewType, "ToggleButton");
            } else if (view instanceof CompoundButton) {
                viewType = SAViewUtils.getViewTypeByReflect(view);
            } else if (view instanceof Button) {
                viewType = SAViewUtils.getViewType(viewType, "Button");
            } else if (view instanceof CheckedTextView) {
                viewType = SAViewUtils.getViewType(viewType, "CheckedTextView");
            } else if (view instanceof TextView) {
                viewType = SAViewUtils.getViewType(viewType, "TextView");
            } else if (view instanceof ImageView) {
                viewType = SAViewUtils.getViewType(viewType, "ImageView");
            } else if (view instanceof RatingBar) {
                viewType = SAViewUtils.getViewType(viewType, "RatingBar");
            } else if (view instanceof SeekBar) {
                viewType = SAViewUtils.getViewType(viewType, "SeekBar");
            } else if (view instanceof Spinner) {
                viewType = SAViewUtils.getViewType(viewType, "Spinner");
            } else if (SAViewUtils.instanceOfTabView(view) != null) {
                viewType = SAViewUtils.getViewType(viewType, "TabLayout");
            } else if (SAViewUtils.instanceOfNavigationView(view)) {
                viewType = SAViewUtils.getViewType(viewType, "NavigationView");
            } else if (view instanceof ViewGroup) {
                viewType = SAViewUtils.getViewGroupTypeByReflect(view);
            }
            SnapCache.getInstance().setViewType(view, viewType);
        } else {
            viewType = cacheViewType;
        }
        return viewType;
    }

    public static boolean instanceOfBottomNavigationItemView(Object view) {
        return ReflectUtil.isInstance(view, "com.google.android.material.bottomnavigation.BottomNavigationItemView", "android.support.design.internal.NavigationMenuItemView");
    }

    public static boolean instanceOfNavigationView(Object view) {
        return ReflectUtil.isInstance(view, "android.support.design.widget.NavigationView", "com.google.android.material.navigation.NavigationView");
    }

    public static boolean instanceOfSupportListMenuItemView(Object view) {
        return ReflectUtil.isInstance(view, "android.support.v7.view.menu.ListMenuItemView");
    }

    public static boolean instanceOfAndroidXListMenuItemView(Object view) {
        return ReflectUtil.isInstance(view, "androidx.appcompat.view.menu.ListMenuItemView");
    }

    public static boolean instanceOfActionMenuItem(Object view) {
        return ReflectUtil.isInstance(view, "androidx.appcompat.view.menu.ActionMenuItem");
    }

    public static boolean instanceOfToolbar(Object view) {
        return ReflectUtil.isInstance(view, "androidx.appcompat.widget.Toolbar", "android.support.v7.widget.Toolbar", "android.widget.Toolbar");
    }

    public static Object getMenuItemData(View view) {
        try {
            Method method = view.getClass().getMethod("getItemData", new Class[0]);
            return method.invoke((Object)view, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isViewSelfVisible(View view) {
        if (view == null || view.getWindowVisibility() == 8) {
            return false;
        }
        if (WindowHelper.isDecorView(view.getClass())) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            boolean viewLocalVisiable = view.getLocalVisibleRect(new Rect());
            if (view.getWidth() <= 0 || view.getHeight() <= 0 || view.getAlpha() <= 0.0f || !viewLocalVisiable) {
                return false;
            }
        }
        return view.getVisibility() != 0 && view.getAnimation() != null && view.getAnimation().getFillAfter() || view.getVisibility() == 0;
    }

    public static String getElementSelector(View view) {
        String selectPath;
        String currentPath = SnapCache.getInstance().getSelectPath(view);
        if (currentPath != null) {
            return currentPath;
        }
        View parent_view = null;
        ViewParent viewParent = view.getParent();
        if (viewParent instanceof ViewGroup) {
            parent_view = (View)viewParent;
        }
        String parentPath = null;
        if (parent_view != null) {
            parentPath = SnapCache.getInstance().getSelectPath(parent_view);
        }
        String path = SnapCache.getInstance().getCanonicalName(view.getClass());
        if (parent_view != null) {
            if (parentPath == null) {
                parentPath = SAViewUtils.getElementSelectorOrigin(parent_view);
                SnapCache.getInstance().setSelectPath(parent_view, parentPath);
            }
            StringBuilder sb = new StringBuilder();
            if (parentPath != null && !parentPath.equals("")) {
                sb.append(parentPath);
                sb.append("/");
            }
            int index = SAViewUtils.getChildIndex(viewParent, view);
            sb.append(path);
            sb.append("[");
            sb.append(index);
            sb.append("]");
            selectPath = sb.toString();
        } else {
            selectPath = SAViewUtils.getElementSelectorOrigin(view);
        }
        SnapCache.getInstance().setSelectPath(view, selectPath);
        return selectPath;
    }

    public static int getChildIndex(ViewParent parent, View child) {
        try {
            if (!(parent instanceof ViewGroup)) {
                return -1;
            }
            ViewGroup viewParent = (ViewGroup)parent;
            String childIdName = SAViewUtils.getViewId(child);
            String childClassName = SnapCache.getInstance().getCanonicalName(child.getClass());
            int index = 0;
            for (int i = 0; i < viewParent.getChildCount(); ++i) {
                View brother = viewParent.getChildAt(i);
                if (!Pathfinder.hasClassName(brother, childClassName)) continue;
                String brotherIdName = SAViewUtils.getViewId(brother);
                if (null != childIdName && !childIdName.equals(brotherIdName)) {
                    ++index;
                    continue;
                }
                if (brother == child) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return -1;
        }
    }

    private static String getElementSelectorOrigin(View view) {
        ViewParent viewParent;
        LinkedList<String> viewPath = new LinkedList<String>();
        do {
            viewParent = view.getParent();
            int index = SAViewUtils.getChildIndex(viewParent, view);
            viewPath.add(view.getClass().getCanonicalName() + "[" + index + "]");
            if (!(viewParent instanceof ViewGroup)) continue;
            view = (ViewGroup)viewParent;
        } while (viewParent instanceof ViewGroup);
        Collections.reverse(viewPath);
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 1; i < viewPath.size(); ++i) {
            stringBuffer.append((String)viewPath.get(i));
            if (i == viewPath.size() - 1) continue;
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    public static String getViewId(View view) {
        String idString;
        block3: {
            idString = null;
            try {
                idString = (String)view.getTag(R.id.sensors_analytics_tag_view_id);
                if (TextUtils.isEmpty((CharSequence)idString) && SAViewUtils.isValid(view.getId()) && (idString = SnapCache.getInstance().getViewId(view)) == null) {
                    idString = view.getContext().getResources().getResourceEntryName(view.getId());
                    SnapCache.getInstance().setViewId(view, idString);
                }
            }
            catch (Exception e) {
                if (!SALog.isLogEnabled()) break block3;
                SAViewUtils.exceptionCollect(view);
            }
        }
        return idString;
    }

    private static boolean isValid(int id2) {
        return id2 != -1 && (id2 & 0xFF000000) != 0 && (id2 & 0xFF0000) != 0;
    }

    private static void exceptionCollect(View view) {
        try {
            if (view != null) {
                int count;
                SALog.i(TAG, "viewClass:" + view.getClass());
                SALog.i(TAG, "viewId:" + view.getId());
                ViewParent viewParent = view.getParent();
                if (viewParent != null) {
                    if (viewParent instanceof View) {
                        View tmpParent = (View)viewParent;
                        SALog.i(TAG, "viewParentClass->ID:" + tmpParent.getId());
                    }
                } else if (view instanceof ViewGroup && (count = ((ViewGroup)view).getChildCount()) > 0) {
                    View childView = ((ViewGroup)view).getChildAt(0);
                    SALog.i(TAG, "childView->ID:" + childView.getId());
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private static boolean isOSViewByPackage(String viewName) {
        if (TextUtils.isEmpty((CharSequence)viewName)) {
            return false;
        }
        String viewNameTemp = viewName.replace(".", "##");
        for (String OSViewPackage : sOSViewPackage) {
            if (!viewNameTemp.startsWith(OSViewPackage)) continue;
            return true;
        }
        return false;
    }

    private static String getTabLayoutContent(Object tab) {
        String viewText = null;
        try {
            Class<?> currentTabClass = ReflectUtil.getCurrentClass(new String[]{"android.support.design.widget.TabLayout$Tab", "com.google.android.material.tabs.TabLayout$Tab"});
            if (currentTabClass != null) {
                View customView;
                Object text = null;
                text = ReflectUtil.callMethod(tab, "getText", new Object[0]);
                if (text != null) {
                    viewText = text.toString();
                }
                if ((customView = (View)ReflectUtil.findField(currentTabClass, tab, "mCustomView", "customView")) != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (customView instanceof ViewGroup) {
                        viewText = SAViewUtils.traverseView(stringBuilder, (ViewGroup)customView);
                        if (!TextUtils.isEmpty((CharSequence)viewText)) {
                            viewText = viewText.substring(0, viewText.length() - 1);
                        }
                    } else {
                        viewText = SAViewUtils.getViewContent(customView);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return viewText;
    }

    private static Object instanceOfTabView(View tabView) {
        try {
            if (tabView == null) {
                return null;
            }
            Class<?> currentTabViewClass = ReflectUtil.getCurrentClass(new String[]{"android.support.design.widget.TabLayout$TabView", "com.google.android.material.tabs.TabLayout$TabView"});
            if (currentTabViewClass != null && currentTabViewClass.isAssignableFrom(tabView.getClass())) {
                return ReflectUtil.findField(currentTabViewClass, (Object)tabView, "mTab", "tab");
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return null;
    }

    private static String getViewType(String viewName, String defaultTypeName) {
        if (TextUtils.isEmpty((CharSequence)viewName) || SAViewUtils.isOSViewByPackage(viewName)) {
            return defaultTypeName;
        }
        return viewName;
    }

    public static JSONObject getScreenNameAndTitle(View view) {
        if (view == null) {
            return null;
        }
        JSONObject object = null;
        Activity activity = SAViewUtils.getActivityOfView(view.getContext(), view);
        if (activity == null) {
            activity = AppStateTools.getInstance().getForegroundActivity();
        }
        if (activity != null && activity.getWindow() != null && activity.getWindow().isActive()) {
            Object fragment = SAFragmentUtils.getFragmentFromView(view, activity);
            if (fragment != null) {
                object = SAPageInfoUtils.getFragmentPageInfo(activity, fragment);
            } else {
                object = SAPageInfoUtils.getActivityPageInfo(activity);
                JSONObject rnJson = SAPageInfoUtils.getRNPageInfo();
                JSONUtils.mergeDuplicateProperty(rnJson, object);
            }
        }
        return object;
    }

    public static JSONObject buildTitleAndScreenName(Activity activity) {
        JSONObject propertyJSON = new JSONObject();
        try {
            propertyJSON.put("$screen_name", (Object)activity.getClass().getCanonicalName());
            String activityTitle = SensorsDataUtils.getActivityTitle(activity);
            if (!TextUtils.isEmpty((CharSequence)activityTitle)) {
                propertyJSON.put("$title", (Object)activityTitle);
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
            return new JSONObject();
        }
        return propertyJSON;
    }

    public static boolean isWeexView(View view) {
        if (view == null) {
            return false;
        }
        String className = view.getClass().getName();
        return className.startsWith("com.taobao.weex.ui.view") || className.startsWith("org.apache.weex.ui.view");
    }

    public static boolean isWeexTextView(View view) {
        if (view == null) {
            return false;
        }
        String className = view.getClass().getName();
        return className.equals("com.taobao.weex.ui.view.WXTextView") || className.equals("org.apache.weex.ui.view.WXTextView");
    }
}

