/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.exceptions.InvalidDataException;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtils {
    public static String optionalStringKey(JSONObject o, String k) throws JSONException {
        if (o.has(k) && !o.isNull(k)) {
            return o.getString(k);
        }
        return null;
    }

    private static void addIndentBlank(StringBuilder sb, int indent) {
        try {
            for (int i = 0; i < indent; ++i) {
                sb.append('\t');
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static String formatJson(String jsonStr) {
        try {
            if (null == jsonStr || "".equals(jsonStr)) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            char last = '\u0000';
            char current = '\u0000';
            int indent = 0;
            boolean isInQuotationMarks = false;
            block9: for (int i = 0; i < jsonStr.length(); ++i) {
                last = current;
                current = jsonStr.charAt(i);
                switch (current) {
                    case '\"': {
                        if (last != '\\') {
                            isInQuotationMarks = !isInQuotationMarks;
                        }
                        sb.append(current);
                        continue block9;
                    }
                    case '[': 
                    case '{': {
                        sb.append(current);
                        if (isInQuotationMarks) continue block9;
                        sb.append('\n');
                        JSONUtils.addIndentBlank(sb, ++indent);
                        continue block9;
                    }
                    case ']': 
                    case '}': {
                        if (!isInQuotationMarks) {
                            sb.append('\n');
                            JSONUtils.addIndentBlank(sb, --indent);
                        }
                        sb.append(current);
                        continue block9;
                    }
                    case ',': {
                        sb.append(current);
                        if (last == '\\' || isInQuotationMarks) continue block9;
                        sb.append('\n');
                        JSONUtils.addIndentBlank(sb, indent);
                        continue block9;
                    }
                    case '\\': {
                        continue block9;
                    }
                    default: {
                        sb.append(current);
                    }
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return "";
        }
    }

    public static Map<String, String> json2Map(JSONObject json) {
        if (json != null && json.length() > 0) {
            HashMap<String, String> maps = new HashMap<String, String>();
            Iterator iterator = json.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                maps.put(key, json.optString(key));
            }
            return maps;
        }
        return null;
    }

    public static void mergeDistinctProperty(JSONObject source, JSONObject dest) {
        try {
            if (dest == null || source == null) {
                return;
            }
            Iterator sourceKeys = source.keys();
            while (sourceKeys.hasNext()) {
                String key = (String)sourceKeys.next();
                if (dest.has(key)) continue;
                Object value = source.get(key);
                if (value instanceof Date && !"$time".equals(key)) {
                    dest.put(key, (Object)TimeUtils.formatDate((Date)value, TimeUtils.SDK_LOCALE));
                    continue;
                }
                dest.put(key, value);
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public static void mergeDuplicateProperty(JSONObject source, JSONObject dest) {
        try {
            if (dest == null || source == null) {
                return;
            }
            Iterator sourceKeys = source.keys();
            while (sourceKeys.hasNext()) {
                String key = (String)sourceKeys.next();
                if (!dest.has(key)) continue;
                Object value = source.get(key);
                if (value instanceof Date && !"$time".equals(key)) {
                    dest.put(key, (Object)TimeUtils.formatDate((Date)value, TimeUtils.SDK_LOCALE));
                    continue;
                }
                dest.put(key, value);
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public static JSONObject cloneJsonObject(JSONObject jsonObject) throws InvalidDataException {
        JSONObject cloneProperties;
        if (jsonObject == null) {
            return new JSONObject();
        }
        try {
            SADataHelper.assertPropertyTypes(jsonObject);
            cloneProperties = new JSONObject(jsonObject.toString());
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = jsonObject.get(key);
                if (!(value instanceof Date)) continue;
                cloneProperties.put(key, (Object)new Date(((Date)value).getTime()));
            }
        }
        catch (JSONException e) {
            cloneProperties = jsonObject;
        }
        return cloneProperties;
    }

    public static void mergeJSONObject(JSONObject source, JSONObject dest) {
        try {
            if (source == null) {
                return;
            }
            if (dest == null) {
                dest = new JSONObject();
            }
            Iterator superPropertiesIterator = source.keys();
            while (superPropertiesIterator.hasNext()) {
                String key = (String)superPropertiesIterator.next();
                Object value = source.get(key);
                if (value instanceof Date && !"$time".equals(key)) {
                    dest.put(key, (Object)TimeUtils.formatDate((Date)value, TimeUtils.SDK_LOCALE));
                    continue;
                }
                dest.put(key, value);
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public static JSONObject mergeSuperJSONObject(JSONObject source, JSONObject dest) {
        if (source == null) {
            source = new JSONObject();
        }
        if (dest == null) {
            return source;
        }
        try {
            Iterator sourceIterator = source.keys();
            while (sourceIterator.hasNext()) {
                String key = (String)sourceIterator.next();
                Iterator destIterator = dest.keys();
                while (destIterator.hasNext()) {
                    String destKey = (String)destIterator.next();
                    if (TextUtils.isEmpty((CharSequence)key) || !key.equalsIgnoreCase(destKey)) continue;
                    destIterator.remove();
                }
            }
            JSONUtils.mergeJSONObject(source, dest);
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
        return dest;
    }

    public static boolean isJson(String str) {
        boolean result = false;
        if (!TextUtils.isEmpty((CharSequence)str)) {
            if ((str = str.trim()).startsWith("{") && str.endsWith("}")) {
                result = true;
            } else if (str.startsWith("[") && str.endsWith("]")) {
                result = true;
            }
        }
        return result;
    }
}

