/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.remote;

import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.encrypt.SecreteKey;
import org.json.JSONArray;
import org.json.JSONObject;

public class SensorsDataSDKRemoteConfig {
    static final int REMOTE_EVENT_TYPE_NO_USE = -1;
    private String oldVersion;
    private boolean disableDebugMode = false;
    private int autoTrackMode = -1;
    private boolean disableSDK = false;
    private SecreteKey mSecretKey;
    private JSONArray eventBlacklist;
    private String newVersion;
    private int effectMode;
    private int mAutoTrackEventType;

    String getOldVersion() {
        return this.oldVersion;
    }

    public void setOldVersion(String oldVersion) {
        this.oldVersion = oldVersion;
    }

    boolean isDisableDebugMode() {
        return this.disableDebugMode;
    }

    public void setDisableDebugMode(boolean disableDebugMode) {
        this.disableDebugMode = disableDebugMode;
    }

    boolean isDisableSDK() {
        return this.disableSDK;
    }

    public void setDisableSDK(boolean disableSDK) {
        this.disableSDK = disableSDK;
    }

    public SecreteKey getSecretKey() {
        return this.mSecretKey;
    }

    public void setSecretKey(SecreteKey mSecretKey) {
        this.mSecretKey = mSecretKey;
    }

    int getAutoTrackMode() {
        return this.autoTrackMode;
    }

    public void setAutoTrackMode(int autoTrackMode) {
        this.autoTrackMode = autoTrackMode;
        if (this.autoTrackMode == -1 || this.autoTrackMode == 0) {
            this.mAutoTrackEventType = 0;
            return;
        }
        if ((this.autoTrackMode & 1) == 1) {
            this.mAutoTrackEventType |= 1;
        }
        if ((this.autoTrackMode & 2) == 2) {
            this.mAutoTrackEventType |= 2;
        }
        if ((this.autoTrackMode & 4) == 4) {
            this.mAutoTrackEventType |= 4;
        }
        if ((this.autoTrackMode & 8) == 8) {
            this.mAutoTrackEventType |= 8;
        }
    }

    int getAutoTrackEventType() {
        return this.mAutoTrackEventType;
    }

    boolean isAutoTrackEventTypeIgnored(int eventType) {
        if (this.autoTrackMode == -1) {
            return false;
        }
        if (this.autoTrackMode == 0) {
            return true;
        }
        return (this.mAutoTrackEventType | eventType) != this.mAutoTrackEventType;
    }

    JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("v", (Object)this.oldVersion);
            JSONObject configObject = new JSONObject();
            configObject.put("disableDebugMode", this.disableDebugMode);
            configObject.put("autoTrackMode", this.autoTrackMode);
            configObject.put("disableSDK", this.disableSDK);
            configObject.put("event_blacklist", (Object)this.eventBlacklist);
            configObject.put("nv", (Object)this.newVersion);
            configObject.put("effect_mode", this.effectMode);
            jsonObject.put("configs", (Object)configObject);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return jsonObject;
    }

    public String toString() {
        return "{ v=" + this.oldVersion + ", disableDebugMode=" + this.disableDebugMode + ", disableSDK=" + this.disableSDK + ", autoTrackMode=" + this.autoTrackMode + ", event_blacklist=" + this.eventBlacklist + ", nv=" + this.newVersion + ", effect_mode=" + this.effectMode + "}";
    }

    public JSONArray getEventBlacklist() {
        return this.eventBlacklist;
    }

    public void setEventBlacklist(JSONArray eventArray) {
        this.eventBlacklist = eventArray;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(String newVersion) {
        this.newVersion = newVersion;
    }

    public void setEffectMode(int effectMode) {
        this.effectMode = effectMode;
    }

    public int getEffectMode() {
        return this.effectMode;
    }
}

