/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.remote;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.dialog.SensorsDataDialogUtils;
import com.sensorsdata.analytics.android.sdk.dialog.SensorsDataLoadingDialog;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.internal.beans.ServerUrl;
import com.sensorsdata.analytics.android.sdk.network.HttpCallback;
import com.sensorsdata.analytics.android.sdk.remote.BaseSensorsDataSDKRemoteManager;
import com.sensorsdata.analytics.android.sdk.remote.SensorsDataSDKRemoteConfig;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import org.json.JSONObject;

public class SensorsDataRemoteManagerDebug
extends BaseSensorsDataSDKRemoteManager {
    private static final String TAG = "SA.SensorsDataRemoteManagerDebug";
    private String errorMsg = "";

    public SensorsDataRemoteManagerDebug(SensorsDataAPI sensorsDataAPI, Context context) {
        super(sensorsDataAPI, sensorsDataAPI.getSAContextManager());
        SALog.i(TAG, "remote config: Construct a SensorsDataRemoteManagerDebug");
    }

    @Override
    public void pullSDKConfigFromServer() {
        SALog.i(TAG, "remote config: Running pullSDKConfigFromServer");
    }

    @Override
    public void requestRemoteConfig(BaseSensorsDataSDKRemoteManager.RandomTimeType randomTimeType, boolean enableConfigV) {
        SALog.i(TAG, "remote config: Running requestRemoteConfig");
    }

    @Override
    public void resetPullSDKConfigTimer() {
        SALog.i(TAG, "remote config: Running resetPullSDKConfigTimer");
    }

    @Override
    public void applySDKConfigFromCache() {
        SALog.i(TAG, "remote config: Running applySDKConfigFromCache");
    }

    @Override
    public void setSDKRemoteConfig(SensorsDataSDKRemoteConfig sdkRemoteConfig) {
        try {
            final JSONObject eventProperties = new JSONObject();
            JSONObject remoteConfigJson = sdkRemoteConfig.toJson().put("debug", true);
            String remoteConfigString = remoteConfigJson.toString();
            eventProperties.put("$app_remote_config", (Object)remoteConfigString);
            SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                @Override
                public void run() {
                    SensorsDataAPI.sharedInstance().getSAContextManager().trackEvent(new InputData().setEventName("$AppRemoteConfigChanged").setProperties(eventProperties).setEventType(EventType.TRACK));
                }
            });
            this.mSensorsDataAPI.flush();
            mSDKRemoteConfig = sdkRemoteConfig;
            SALog.i(TAG, "remote config: The remote configuration takes effect immediately");
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public void checkRemoteConfig(final Uri uri, final Activity activity) {
        if (this.verifyRemoteRequestParameter(uri, activity)) {
            SensorsDataDialogUtils.showDialog(activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_common_title), SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_config), SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_common_continue), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    final SensorsDataLoadingDialog loadingDialog = new SensorsDataLoadingDialog((Context)activity);
                    SensorsDataDialogUtils.dialogShowDismissOld(loadingDialog);
                    SensorsDataRemoteManagerDebug.this.requestRemoteConfig(false, new HttpCallback.StringCallback(){

                        @Override
                        public void onFailure(int code, String errorMessage) {
                            loadingDialog.dismiss();
                            SensorsDataDialogUtils.showDialog((Context)activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_fail));
                            SALog.i(SensorsDataRemoteManagerDebug.TAG, "remote config: Remote request was failed,code is " + code + ",errorMessage is" + errorMessage);
                        }

                        @Override
                        public void onResponse(String response) {
                            loadingDialog.dismiss();
                            if (!TextUtils.isEmpty((CharSequence)response)) {
                                SensorsDataSDKRemoteConfig sdkRemoteConfig = SensorsDataRemoteManagerDebug.this.toSDKRemoteConfig(response);
                                String nv = uri.getQueryParameter("nv");
                                if (!sdkRemoteConfig.getNewVersion().equals(nv)) {
                                    SensorsDataDialogUtils.showDialog(activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_version_error), String.format(SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_version_tip), sdkRemoteConfig.getNewVersion(), nv), SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_common_ok), new DialogInterface.OnClickListener(){

                                        public void onClick(DialogInterface dialog, int which) {
                                            SensorsDataDialogUtils.startLaunchActivity((Context)activity);
                                        }
                                    }, null, null);
                                } else {
                                    SensorsDataDialogUtils.showDialog((Context)activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_succeed));
                                    SensorsDataRemoteManagerDebug.this.setSDKRemoteConfig(sdkRemoteConfig);
                                }
                            } else {
                                SensorsDataDialogUtils.showDialog((Context)activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_other_error));
                            }
                            SALog.i(SensorsDataRemoteManagerDebug.TAG, "remote config: Remote request was successful,response data is " + response);
                        }

                        @Override
                        public void onAfter() {
                        }
                    });
                }
            }, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_common_cancel), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SensorsDataDialogUtils.startLaunchActivity((Context)activity);
                }
            });
        } else {
            SensorsDataDialogUtils.showDialog((Context)activity, this.errorMsg);
        }
    }

    private boolean verifyRemoteRequestParameter(Uri uri, Activity activity) {
        boolean isVerify = false;
        String appId = uri.getQueryParameter("app_id");
        String os = uri.getQueryParameter("os");
        String project = uri.getQueryParameter("project");
        String nv = uri.getQueryParameter("nv");
        String localProject = "";
        String serverUrl = this.mSensorsDataAPI.getServerUrl();
        if (!TextUtils.isEmpty((CharSequence)serverUrl)) {
            localProject = new ServerUrl(serverUrl).getProject();
        }
        SALog.i(TAG, "remote config: ServerUrl is " + serverUrl);
        if (!NetworkUtils.isNetworkAvailable(this.mContextManager.getContext())) {
            this.errorMsg = SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_tip_error_network);
        } else if (this.mSensorsDataAPI != null && !this.mSensorsDataAPI.isNetworkRequestEnable()) {
            this.errorMsg = SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_tip_error_disable_network);
            SALog.i(TAG, "enableNetworkRequest is false");
        } else if (this.mDisableDefaultRemoteConfig) {
            this.errorMsg = SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_tip_error_disable_remote);
            SALog.i(TAG, "disableDefaultRemoteConfig is true");
        } else if (!localProject.equals(project)) {
            this.errorMsg = SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_tip_error_project);
        } else if (!"Android".equals(os)) {
            this.errorMsg = SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_tip_error_os);
        } else if (!AppInfoUtils.getProcessName((Context)activity).equals(appId)) {
            this.errorMsg = SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_tip_error_appid);
        } else if (TextUtils.isEmpty((CharSequence)nv)) {
            this.errorMsg = SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_remote_tip_error_qrcode);
        } else {
            isVerify = true;
        }
        SALog.i(TAG, "remote config: Uri is " + uri.toString());
        SALog.i(TAG, "remote config: The verification result is " + isVerify);
        return isVerify;
    }
}

