/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.remote;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Patterns;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.network.HttpCallback;
import com.sensorsdata.analytics.android.sdk.network.HttpMethod;
import com.sensorsdata.analytics.android.sdk.network.RequestHelper;
import com.sensorsdata.analytics.android.sdk.remote.SensorsDataSDKRemoteConfig;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseSensorsDataSDKRemoteManager {
    protected static final String TAG = "SA.SensorsDataSDKRemoteConfigBase";
    protected SAContextManager mContextManager;
    protected boolean mDisableDefaultRemoteConfig;
    protected static volatile SensorsDataSDKRemoteConfig mSDKRemoteConfig;
    protected SensorsDataAPI mSensorsDataAPI;

    protected BaseSensorsDataSDKRemoteManager(SensorsDataAPI sensorsDataAPI, SAContextManager saContextManager) {
        this.mSensorsDataAPI = sensorsDataAPI;
        this.mContextManager = saContextManager;
        this.mDisableDefaultRemoteConfig = sensorsDataAPI.isDisableDefaultRemoteConfig();
    }

    public abstract void pullSDKConfigFromServer();

    public abstract void requestRemoteConfig(RandomTimeType var1, boolean var2);

    public abstract void resetPullSDKConfigTimer();

    public abstract void applySDKConfigFromCache();

    protected abstract void setSDKRemoteConfig(SensorsDataSDKRemoteConfig var1);

    public boolean ignoreEvent(String eventName) {
        if (mSDKRemoteConfig != null && mSDKRemoteConfig.getEventBlacklist() != null) {
            try {
                int size = mSDKRemoteConfig.getEventBlacklist().length();
                for (int i = 0; i < size; ++i) {
                    if (!eventName.equals(mSDKRemoteConfig.getEventBlacklist().get(i))) continue;
                    SALog.i(TAG, "remote config: " + eventName + " is ignored by remote config");
                    return true;
                }
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
            }
        }
        return false;
    }

    protected SensorsDataSDKRemoteConfig toSDKRemoteConfig(String config) {
        SensorsDataSDKRemoteConfig sdkRemoteConfig = new SensorsDataSDKRemoteConfig();
        try {
            if (!TextUtils.isEmpty((CharSequence)config)) {
                JSONObject jsonObject = new JSONObject(config);
                sdkRemoteConfig.setOldVersion(jsonObject.optString("v"));
                String configs = jsonObject.optString("configs");
                if (!TextUtils.isEmpty((CharSequence)configs)) {
                    JSONObject configObject = new JSONObject(configs);
                    sdkRemoteConfig.setDisableDebugMode(configObject.optBoolean("disableDebugMode", false));
                    sdkRemoteConfig.setDisableSDK(configObject.optBoolean("disableSDK", false));
                    sdkRemoteConfig.setAutoTrackMode(configObject.optInt("autoTrackMode", -1));
                    sdkRemoteConfig.setEventBlacklist(configObject.optJSONArray("event_blacklist"));
                    sdkRemoteConfig.setNewVersion(configObject.optString("nv", ""));
                    sdkRemoteConfig.setEffectMode(configObject.optInt("effect_mode", 0));
                } else {
                    sdkRemoteConfig.setDisableDebugMode(false);
                    sdkRemoteConfig.setDisableSDK(false);
                    sdkRemoteConfig.setAutoTrackMode(-1);
                    sdkRemoteConfig.setEventBlacklist(new JSONArray());
                    sdkRemoteConfig.setNewVersion("");
                    sdkRemoteConfig.setEffectMode(0);
                }
                return sdkRemoteConfig;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return sdkRemoteConfig;
    }

    public Boolean isAutoTrackEventTypeIgnored(int autoTrackEventType) {
        try {
            if (mSDKRemoteConfig != null && mSDKRemoteConfig.getAutoTrackMode() != -1) {
                if (mSDKRemoteConfig.getAutoTrackMode() == 0) {
                    return true;
                }
                return mSDKRemoteConfig.isAutoTrackEventTypeIgnored(autoTrackEventType);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return null;
    }

    public static synchronized boolean isSDKDisabledByRemote() {
        try {
            SensorsDataSDKRemoteConfig config = mSDKRemoteConfig;
            if (config == null) {
                return false;
            }
            return config.isDisableSDK();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public Boolean isAutoTrackEnabled() {
        if (mSDKRemoteConfig != null) {
            if (mSDKRemoteConfig.getAutoTrackMode() == 0) {
                SALog.i(TAG, "remote config: AutoTrackMode is closing by remote config");
                return false;
            }
            if (mSDKRemoteConfig.getAutoTrackMode() > 0) {
                return true;
            }
        }
        return null;
    }

    protected String buildRemoteUrl(boolean enableConfigV) {
        Uri uri;
        String project;
        String remoteUrl = null;
        boolean configV = enableConfigV;
        String serverUlr = this.mSensorsDataAPI.getServerUrl();
        String configOptionsRemoteUrl = null;
        if (this.mContextManager.getInternalConfigs().saConfigOptions != null) {
            configOptionsRemoteUrl = this.mContextManager.getInternalConfigs().saConfigOptions.getRemoteConfigUrl();
        }
        if (!TextUtils.isEmpty(configOptionsRemoteUrl) && Patterns.WEB_URL.matcher(configOptionsRemoteUrl).matches()) {
            remoteUrl = configOptionsRemoteUrl;
            SALog.i(TAG, "SAConfigOptions remote url is " + remoteUrl);
        } else if (!TextUtils.isEmpty((CharSequence)serverUlr) && Patterns.WEB_URL.matcher(serverUlr).matches()) {
            int pathPrefix = serverUlr.lastIndexOf("/");
            if (pathPrefix != -1) {
                remoteUrl = serverUlr.substring(0, pathPrefix);
                remoteUrl = remoteUrl + "/config/Android.conf";
            }
            SALog.i(TAG, "SensorsDataAPI remote url is " + remoteUrl);
        } else {
            SALog.i(TAG, String.format(TimeUtils.SDK_LOCALE, "ServerUlr: %s, SAConfigOptions remote url: %s", serverUlr, configOptionsRemoteUrl));
            SALog.i(TAG, "Remote config url verification failed");
            return null;
        }
        if (configV && (SensorsDataUtils.checkVersionIsNew(this.mContextManager.getContext(), this.mSensorsDataAPI.getSDKVersion()) || !this.isSecretKeyValid())) {
            configV = false;
        }
        if (TextUtils.isEmpty((CharSequence)remoteUrl)) {
            SALog.i(TAG, "remote request url is empty");
            return "";
        }
        Uri configUri = Uri.parse((String)remoteUrl);
        Uri.Builder builder = configUri.buildUpon();
        if (!TextUtils.isEmpty((CharSequence)remoteUrl) && configV) {
            String oldVersion = null;
            String newVersion = null;
            SensorsDataSDKRemoteConfig SDKRemoteConfig = mSDKRemoteConfig;
            if (SDKRemoteConfig != null) {
                oldVersion = SDKRemoteConfig.getOldVersion();
                newVersion = SDKRemoteConfig.getNewVersion();
                SALog.i(TAG, "The current config: " + SDKRemoteConfig);
            }
            if (!TextUtils.isEmpty(oldVersion) && TextUtils.isEmpty((CharSequence)configUri.getQueryParameter("v"))) {
                builder.appendQueryParameter("v", oldVersion);
            }
            if (!TextUtils.isEmpty(newVersion) && TextUtils.isEmpty((CharSequence)configUri.getQueryParameter("nv"))) {
                builder.appendQueryParameter("nv", newVersion);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)serverUlr) && TextUtils.isEmpty((CharSequence)configUri.getQueryParameter("project")) && !TextUtils.isEmpty((CharSequence)(project = (uri = Uri.parse((String)serverUlr)).getQueryParameter("project")))) {
            builder.appendQueryParameter("project", project);
        }
        if (TextUtils.isEmpty((CharSequence)configUri.getQueryParameter("app_id"))) {
            String appId = AppInfoUtils.getProcessName(this.mContextManager.getContext());
            builder.appendQueryParameter("app_id", appId);
        }
        builder.build();
        remoteUrl = builder.toString();
        SALog.i(TAG, "Android remote config url is " + remoteUrl);
        return remoteUrl;
    }

    protected void requestRemoteConfig(boolean enableConfigV, HttpCallback.StringCallback callback) {
        try {
            String configUrl = this.buildRemoteUrl(enableConfigV);
            if (TextUtils.isEmpty((CharSequence)configUrl)) {
                return;
            }
            new RequestHelper.Builder(HttpMethod.GET, configUrl).callback(callback).execute();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    protected boolean isSecretKeyValid() {
        if (this.mContextManager.getInternalConfigs().saConfigOptions.isEnableEncrypt() && SAModuleManager.getInstance().hasModuleByName("sensors_analytics_module_encrypt")) {
            String secretKey = (String)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "loadSecretKey", new Object[0]);
            try {
                if (TextUtils.isEmpty((CharSequence)secretKey)) {
                    return false;
                }
                JSONObject jsonObject = new JSONObject(secretKey);
                if (!jsonObject.has("key") || TextUtils.isEmpty((CharSequence)jsonObject.optString("key"))) {
                    return false;
                }
            }
            catch (JSONException e) {
                SALog.printStackTrace((Exception)((Object)e));
                return false;
            }
        }
        return true;
    }

    public static enum RandomTimeType {
        RandomTimeTypeWrite,
        RandomTimeTypeClean,
        RandomTimeTypeNone;

    }
}

