/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.plugin.property;

import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.plugin.property.SAPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertiesFetcher;
import com.sensorsdata.analytics.android.sdk.plugin.property.beans.SAPropertyFilter;
import com.sensorsdata.analytics.android.sdk.plugin.property.impl.InternalCustomPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.impl.RealTimePropertyPlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.impl.ReferrerTitlePlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.impl.SAPresetPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.impl.SASuperPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public final class PropertyPluginManager {
    private static final String TAG = "SA.SAPropertyPluginManager";
    private final Map<String, SAPropertyPlugin> mPluginMap;
    private List<SAPropertyPlugin> mPluginsList = new ArrayList<SAPropertyPlugin>();

    public PropertyPluginManager(SensorsDataAPI sensorsDataAPI, SAContextManager contextManager) {
        this.mPluginMap = Collections.synchronizedMap(new LinkedHashMap());
        this.registerDefaultProperty(sensorsDataAPI, contextManager);
    }

    public synchronized void registerPropertyPlugin(SAPropertyPlugin plugin) {
        try {
            if (plugin == null) {
                return;
            }
            String propertyType = plugin.getName();
            if (!this.mPluginMap.containsKey(propertyType)) {
                this.mPluginMap.put(propertyType, plugin);
                this.sortedPlugin();
            } else {
                SALog.i(TAG, propertyType + " has exist!");
            }
        }
        catch (Exception e) {
            SALog.i(TAG, "register property plugin exception! ", e);
        }
    }

    public synchronized void unregisterPropertyPlugin(SAPropertyPlugin plugin) {
        if (plugin == null) {
            return;
        }
        String propertyType = plugin.getName();
        this.mPluginMap.remove(propertyType);
        this.sortedPlugin();
    }

    public synchronized SAPropertiesFetcher propertiesHandler(SAPropertyFilter filter) {
        try {
            if (this.mPluginsList.size() == 0) {
                return null;
            }
            SAPropertiesFetcher saPropertiesFetcher = new SAPropertiesFetcher();
            saPropertiesFetcher.setProperties(filter.getProperties());
            saPropertiesFetcher.setEventJson("lib", filter.getEventJson("lib"));
            for (SAPropertyPlugin plugin : this.mPluginsList) {
                JSONObject filterJson = new JSONObject();
                JSONUtils.mergeJSONObject(saPropertiesFetcher.getProperties(), filterJson);
                filter.setProperties(filterJson);
                if (!plugin.isMatchedWithFilter(filter)) continue;
                plugin.properties(saPropertiesFetcher);
            }
            SALog.i(TAG, "SAPropertiesFetcher: %s", saPropertiesFetcher);
            return saPropertiesFetcher;
        }
        catch (Exception e) {
            SALog.i(TAG, String.format("Event [%s] error is happened when matching property-plugins", filter.getEvent()), e);
            return null;
        }
    }

    public SAPropertyPlugin getPropertyPlugin(String pluginName) {
        return this.mPluginMap.get(pluginName);
    }

    private void registerDefaultProperty(SensorsDataAPI sensorsDataAPI, SAContextManager contextManager) {
        this.registerPropertyPlugin(new SAPresetPropertyPlugin(contextManager));
        this.registerPropertyPlugin(new SASuperPropertyPlugin(sensorsDataAPI));
        this.registerPropertyPlugin(new ReferrerTitlePlugin());
        this.registerPropertyPlugin(new RealTimePropertyPlugin(contextManager));
        List plugins = contextManager.getInternalConfigs().saConfigOptions.getPropertyPlugins();
        if (plugins != null) {
            for (SAPropertyPlugin plugin : plugins) {
                this.registerPropertyPlugin(plugin);
            }
        }
        this.registerPropertyPlugin(new InternalCustomPropertyPlugin());
    }

    private void sortedPlugin() {
        this.mPluginsList = new ArrayList<SAPropertyPlugin>(this.mPluginMap.values());
        Collections.sort(this.mPluginsList, new Comparator<SAPropertyPlugin>(){

            @Override
            public int compare(SAPropertyPlugin o1, SAPropertyPlugin o2) {
                if (o1.priority().getPriority() >= o2.priority().getPriority()) {
                    return 0;
                }
                return -1;
            }
        });
    }
}

