/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.plugin.encrypt;

import android.content.Context;
import android.content.SharedPreferences;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.StorePlugin;
import com.sensorsdata.analytics.android.sdk.util.SASpUtils;
import java.util.List;

public abstract class DefaultStorePlugin
implements StorePlugin {
    protected final SharedPreferences mStoreSp;
    private final String mFileName;

    public DefaultStorePlugin(Context context, String fileName) {
        this.mStoreSp = SASpUtils.getSharedPreferences(context, fileName, 0);
        this.mFileName = fileName;
    }

    @Override
    public boolean isExists(String key) {
        return this.mStoreSp.contains(this.getKey(key));
    }

    @Override
    public String type() {
        return this.mFileName;
    }

    @Override
    public void upgrade(StorePlugin oldPlugin) {
    }

    @Override
    public void setString(String key, String value) {
        this.mStoreSp.edit().putString(this.getKey(key), value).apply();
    }

    @Override
    public void setBool(String key, boolean value) {
        this.mStoreSp.edit().putBoolean(this.getKey(key), value).apply();
    }

    @Override
    public void setInteger(String key, int value) {
        this.mStoreSp.edit().putInt(this.getKey(key), value).apply();
    }

    @Override
    public void setFloat(String key, float value) {
        this.mStoreSp.edit().putFloat(this.getKey(key), value).apply();
    }

    @Override
    public void setLong(String key, long value) {
        this.mStoreSp.edit().putLong(this.getKey(key), value).apply();
    }

    @Override
    public String getString(String key) {
        if (this.isExists(key)) {
            return this.mStoreSp.getString(this.getKey(key), null);
        }
        return null;
    }

    @Override
    public Boolean getBool(String key) {
        if (this.isExists(key)) {
            return this.mStoreSp.getBoolean(this.getKey(key), false);
        }
        return null;
    }

    @Override
    public Integer getInteger(String key) {
        if (this.isExists(key)) {
            return this.mStoreSp.getInt(this.getKey(key), 0);
        }
        return null;
    }

    @Override
    public Float getFloat(String key) {
        if (this.isExists(key)) {
            return Float.valueOf(this.mStoreSp.getFloat(this.getKey(key), 0.0f));
        }
        return null;
    }

    @Override
    public Long getLong(String key) {
        if (this.isExists(key)) {
            return this.mStoreSp.getLong(this.getKey(key), 0L);
        }
        return null;
    }

    @Override
    public void remove(String key) {
        this.mStoreSp.edit().remove(this.getKey(key)).apply();
    }

    public abstract List<String> storeKeys();

    protected String getKey(String key) {
        return key.replaceFirst(this.type(), "");
    }
}

