/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.jsbridge;

import android.os.Build;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.jsbridge.AppWebViewInterface;
import com.sensorsdata.analytics.android.sdk.jsbridge.H5Helper;
import java.util.Map;

public class JSHookAop {
    private static final String TAG = "SA.JSHookAop";

    public static void loadUrl(View webView, String url) {
        if (webView == null) {
            SALog.i(TAG, "WebView has not initialized.");
            return;
        }
        JSHookAop.setupH5Bridge(webView);
    }

    public static void loadUrl(View webView, String url, Map<String, String> additionalHttpHeaders) {
        if (webView == null) {
            SALog.i(TAG, "WebView has not initialized.");
            return;
        }
        JSHookAop.setupH5Bridge(webView);
    }

    public static void loadData(View webView, String data, String mimeType, String encoding) {
        if (webView == null) {
            SALog.i(TAG, "WebView has not initialized.");
            return;
        }
        JSHookAop.setupH5Bridge(webView);
    }

    public static void loadDataWithBaseURL(View webView, String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        if (webView == null) {
            SALog.i(TAG, "WebView has not initialized.");
            return;
        }
        JSHookAop.setupH5Bridge(webView);
    }

    public static void postUrl(View webView, String url, byte[] postData) {
        if (webView == null) {
            SALog.i(TAG, "WebView has not initialized.");
            return;
        }
        JSHookAop.setupH5Bridge(webView);
    }

    private static void setupH5Bridge(View webView) {
        if (JSHookAop.isSupportJellyBean() && SensorsDataAPI.getConfigOptions() != null && SensorsDataAPI.getConfigOptions().isAutoTrackWebView()) {
            JSHookAop.setupWebView(webView);
        }
        if (JSHookAop.isSupportJellyBean()) {
            SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "addVisualJavascriptInterface", webView);
        }
    }

    private static boolean isSupportJellyBean() {
        if (!(Build.VERSION.SDK_INT >= 17 || SensorsDataAPI.getConfigOptions() != null && SensorsDataAPI.getConfigOptions().isWebViewSupportJellyBean())) {
            SALog.d(TAG, "For applications targeted to API level JELLY_BEAN or below, this feature NOT SUPPORTED");
            return false;
        }
        return true;
    }

    private static void setupWebView(View webView) {
        if (webView != null && webView.getTag(R.id.sensors_analytics_tag_view_webview) == null) {
            webView.setTag(R.id.sensors_analytics_tag_view_webview, new Object());
            H5Helper.addJavascriptInterface(webView, new AppWebViewInterface(webView.getContext().getApplicationContext(), null, false, webView), "SensorsData_APP_New_H5_Bridge");
        }
    }
}

