/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.dialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.dialog.DebugModeSelectDialog;
import com.sensorsdata.analytics.android.sdk.dialog.SchemeActivity;
import com.sensorsdata.analytics.android.sdk.util.NetworkUtils;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import com.sensorsdata.analytics.android.sdk.util.ToastUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class SensorsDataDialogUtils {
    private static final String TAG = "SA.SensorsDataDialogUtils";
    private static Dialog sDialog;
    private static boolean isShowHttpErrorDialog;

    public static void showDialog(Activity activity, String title, String content, String positiveLabel, DialogInterface.OnClickListener positiveOnClickListener, String negativeLabel, DialogInterface.OnClickListener negativeOnClickListener) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            builder.setTitle((CharSequence)title);
        }
        if (!TextUtils.isEmpty((CharSequence)content)) {
            builder.setMessage((CharSequence)content);
        }
        builder.setCancelable(false);
        builder.setNegativeButton((CharSequence)negativeLabel, negativeOnClickListener);
        builder.setPositiveButton((CharSequence)positiveLabel, positiveOnClickListener);
        AlertDialog dialog = builder.create();
        SensorsDataDialogUtils.dialogShowDismissOld((Dialog)dialog);
        dialog.getButton(-2).setAllCaps(false);
        dialog.getButton(-1).setAllCaps(false);
    }

    public static void showPopupWindowDialog(final Activity activity, Uri uri) {
        try {
            Class<?> clazz = Class.forName("com.sensorsdata.sf.ui.utils.PreviewUtil");
            String sfPopupTest = uri.getQueryParameter("sf_popup_test");
            String popupWindowId = uri.getQueryParameter("popup_window_id");
            boolean isSfPopupTest = false;
            if (!TextUtils.isEmpty((CharSequence)sfPopupTest)) {
                isSfPopupTest = Boolean.parseBoolean(sfPopupTest);
            }
            Method[] methods = clazz.getDeclaredMethods();
            Method currentMethod = null;
            Runnable failCallback = null;
            for (Method method : methods) {
                if (!method.getName().equals("showPreview")) continue;
                currentMethod = method;
                if (method.getParameterTypes().length != 4) continue;
                failCallback = new Runnable(){

                    @Override
                    public void run() {
                        if (activity == null) {
                            return;
                        }
                        activity.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                SensorsDataDialogUtils.showDialog((Context)activity, SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_popwindow_fail));
                            }
                        });
                    }
                };
                break;
            }
            if (currentMethod != null) {
                if (failCallback != null) {
                    currentMethod.invoke(null, activity, isSfPopupTest, popupWindowId, failCallback);
                } else {
                    currentMethod.invoke(null, activity, isSfPopupTest, popupWindowId);
                }
                SchemeActivity.isPopWindow = true;
            } else {
                SensorsDataDialogUtils.startLaunchActivity((Context)activity);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            SensorsDataDialogUtils.startLaunchActivity((Context)activity);
        }
    }

    public static void showDebugModeSelectDialog(final Activity activity, final String infoId, final String locationHref, final String project) {
        try {
            DebugModeSelectDialog dialog = new DebugModeSelectDialog((Context)activity, SensorsDataAPI.sharedInstance().getDebugMode());
            dialog.setCanceledOnTouchOutside(false);
            dialog.setOnDebugModeDialogClickListener(new DebugModeSelectDialog.OnDebugModeViewClickListener(){

                @Override
                public void onCancel(Dialog dialog) {
                    dialog.cancel();
                }

                @Override
                public void setDebugMode(Dialog dialog, SensorsDataAPI.DebugMode debugMode) {
                    SensorsDataAPI.sharedInstance().setDebugMode(debugMode);
                    dialog.cancel();
                }
            });
            dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    String serverUrl = SensorsDataAPI.sharedInstance().getServerUrl();
                    SensorsDataAPI.DebugMode mCurrentDebugMode = SensorsDataAPI.sharedInstance().getDebugMode();
                    if (SensorsDataAPI.sharedInstance().isNetworkRequestEnable() && !TextUtils.isEmpty((CharSequence)serverUrl) && !TextUtils.isEmpty((CharSequence)infoId) && mCurrentDebugMode != SensorsDataAPI.DebugMode.DEBUG_OFF) {
                        if (TextUtils.isEmpty((CharSequence)locationHref)) {
                            new SendDebugIdThread(serverUrl, SensorsDataAPI.sharedInstance().getDistinctId(), infoId, "SA.SendDistinctIDThread").start();
                        } else {
                            try {
                                if (!TextUtils.isEmpty((CharSequence)project)) {
                                    String url = locationHref + "?project=" + project;
                                    SALog.i(SensorsDataDialogUtils.TAG, "sf url:" + url);
                                    new SendDebugIdThread(url, SensorsDataAPI.sharedInstance().getDistinctId(), infoId, "SA.SendDistinctIDThread").start();
                                }
                            }
                            catch (Exception e) {
                                SALog.printStackTrace(e);
                            }
                        }
                    }
                    String currentDebugToastMsg = "";
                    if (mCurrentDebugMode == SensorsDataAPI.DebugMode.DEBUG_OFF) {
                        currentDebugToastMsg = SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_debug_tip_off);
                    } else if (mCurrentDebugMode == SensorsDataAPI.DebugMode.DEBUG_ONLY) {
                        currentDebugToastMsg = SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_debug_tip_only);
                    } else if (mCurrentDebugMode == SensorsDataAPI.DebugMode.DEBUG_AND_TRACK) {
                        currentDebugToastMsg = SADisplayUtil.getStringResource((Context)activity, R.string.sensors_analytics_debug_tip_track);
                    }
                    ToastUtil.showLong((Context)activity, currentDebugToastMsg);
                    SALog.info(SensorsDataDialogUtils.TAG, "The App current DebugMode is \uff1a" + (Object)((Object)mCurrentDebugMode), null);
                    SensorsDataDialogUtils.startLaunchActivity((Context)activity);
                }
            });
            SensorsDataDialogUtils.dialogShowDismissOld(dialog);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static void showHttpErrorDialog(Activity context, String msg) {
        block6: {
            try {
                if (TextUtils.isEmpty((CharSequence)msg) || !isShowHttpErrorDialog || context == null) {
                    return;
                }
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)context);
                builder.setTitle((CharSequence)SADisplayUtil.getStringResource((Context)context, R.string.sensors_analytics_common_title));
                builder.setMessage((CharSequence)msg);
                builder.setCancelable(false);
                builder.setNegativeButton((CharSequence)SADisplayUtil.getStringResource((Context)context, R.string.sensors_analytics_common_ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
                builder.setPositiveButton((CharSequence)SADisplayUtil.getStringResource((Context)context, R.string.sensors_analytics_common_no), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        isShowHttpErrorDialog = false;
                    }
                });
                AlertDialog dialog = builder.create();
                SensorsDataDialogUtils.dialogShowDismissOld((Dialog)dialog);
                try {
                    dialog.getButton(-2).setTextColor(-16777216);
                    dialog.getButton(-2).setBackgroundColor(-1);
                    dialog.getButton(-2).setAllCaps(false);
                    dialog.getButton(-1).setTextColor(-65536);
                    dialog.getButton(-1).setBackgroundColor(-1);
                    dialog.getButton(-1).setAllCaps(false);
                    if (Build.VERSION.SDK_INT >= 16) {
                        dialog.getButton(-2).setBackground((Drawable)SensorsDataDialogUtils.getDrawable());
                        dialog.getButton(-1).setBackground((Drawable)SensorsDataDialogUtils.getDrawable());
                        break block6;
                    }
                    dialog.getButton(-2).setBackgroundDrawable((Drawable)SensorsDataDialogUtils.getDrawable());
                    dialog.getButton(-1).setBackgroundDrawable((Drawable)SensorsDataDialogUtils.getDrawable());
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
        }
    }

    public static StateListDrawable getDrawable() {
        GradientDrawable pressDrawable = new GradientDrawable();
        pressDrawable.setShape(0);
        pressDrawable.setColor(Color.parseColor((String)"#dddddd"));
        GradientDrawable normalDrawable = new GradientDrawable();
        normalDrawable.setShape(0);
        normalDrawable.setColor(-1);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842908}, (Drawable)pressDrawable);
        stateListDrawable.addState(new int[0], (Drawable)normalDrawable);
        return stateListDrawable;
    }

    public static void showDialog(final Context context, String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)SADisplayUtil.getStringResource(context, R.string.sensors_analytics_common_title)).setMessage((CharSequence)message).setCancelable(false).setPositiveButton((CharSequence)SADisplayUtil.getStringResource(context, R.string.sensors_analytics_common_ok), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SensorsDataDialogUtils.startLaunchActivity(context);
            }
        });
        AlertDialog dialog = builder.create();
        SensorsDataDialogUtils.dialogShowDismissOld((Dialog)dialog);
        try {
            dialog.getButton(-1).setTextColor(-65536);
            dialog.getButton(-1).setBackgroundColor(-1);
            dialog.getButton(-1).setAllCaps(false);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static void startLaunchActivity(Context context) {
        try {
            if (SensorsDataDialogUtils.isSchemeActivity(context)) {
                PackageManager packageManager = context.getPackageManager();
                Intent intent = packageManager.getLaunchIntentForPackage(context.getPackageName());
                context.startActivity(intent);
                ((SchemeActivity)context).finish();
                SALog.i(TAG, "startLaunchActivity");
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static boolean isSchemeActivity(Context context) {
        Object scheme_activity_sign;
        if (context == null) {
            return false;
        }
        String name = context.getClass().getName();
        if (TextUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        if (name.endsWith(SchemeActivity.class.getSimpleName()) && (scheme_activity_sign = ReflectUtil.findFieldRecur(context, "SCHEME_ACTIVITY_SIGN")) instanceof String) {
            return TextUtils.equals((CharSequence)((String)scheme_activity_sign), (CharSequence)"#*#scheme_activity_sign#*#");
        }
        return false;
    }

    public static void dialogShowDismissOld(Dialog dialog) {
        try {
            if (sDialog != null && sDialog.isShowing()) {
                try {
                    sDialog.dismiss();
                    SALog.i(TAG, "Dialog dismiss");
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
            sDialog = dialog;
            if (dialog != null) {
                dialog.show();
                dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialog) {
                        sDialog = null;
                    }
                });
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    static {
        isShowHttpErrorDialog = true;
    }

    private static class SendDebugIdThread
    extends Thread {
        private String distinctId;
        private String infoId;
        private String serverUrl;

        SendDebugIdThread(String serverUrl, String distinctId, String infoId, String name) {
            super(name);
            this.distinctId = distinctId;
            this.infoId = infoId;
            this.serverUrl = serverUrl;
        }

        @Override
        public void run() {
            super.run();
            this.sendHttpRequest(this.serverUrl, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendHttpRequest(String serverUrl, boolean isRedirects) {
            ByteArrayOutputStream out = null;
            OutputStream out2 = null;
            BufferedOutputStream bout = null;
            HttpURLConnection connection = null;
            try {
                String location;
                URL url = new URL(String.format(serverUrl + "&info_id=%s", this.infoId));
                SALog.info(SensorsDataDialogUtils.TAG, String.format("DebugMode URL:%s", url), null);
                connection = (HttpURLConnection)url.openConnection();
                if (connection == null) {
                    SALog.info(SensorsDataDialogUtils.TAG, String.format("can not connect %s,shouldn't happen", url.toString()), null);
                    this.closeStream(out, out2, bout, connection);
                    return;
                }
                SAConfigOptions configOptions = SensorsDataAPI.getConfigOptions();
                if (configOptions != null && configOptions.getSSLSocketFactory() != null && connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(configOptions.getSSLSocketFactory());
                }
                connection.setInstanceFollowRedirects(false);
                out = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(out);
                String requestBody = "{\"distinct_id\": \"" + this.distinctId + "\"}";
                writer.write(requestBody);
                writer.flush();
                SALog.info(SensorsDataDialogUtils.TAG, String.format("DebugMode request body : %s", requestBody), null);
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-type", "text/plain");
                out2 = connection.getOutputStream();
                bout = new BufferedOutputStream(out2);
                bout.write(out.toString().getBytes("UTF-8"));
                bout.flush();
                out.close();
                int responseCode = connection.getResponseCode();
                SALog.info(SensorsDataDialogUtils.TAG, String.format(TimeUtils.SDK_LOCALE, "DebugMode ResponseCode: %d", responseCode), null);
                if (!isRedirects && NetworkUtils.needRedirects(responseCode) && !TextUtils.isEmpty((CharSequence)(location = NetworkUtils.getLocation(connection, serverUrl)))) {
                    this.closeStream(out, out2, bout, connection);
                    this.sendHttpRequest(location, true);
                }
                this.closeStream(out, out2, bout, connection);
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
            finally {
                this.closeStream(out, out2, bout, connection);
            }
        }

        private void closeStream(ByteArrayOutputStream out, OutputStream out2, BufferedOutputStream bout, HttpURLConnection connection) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
            if (out2 != null) {
                try {
                    out2.close();
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        }
    }
}

