/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.dialog;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPIEmptyImplementation;
import com.sensorsdata.analytics.android.sdk.dialog.SensorsDataDialogUtils;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;

public class SchemeActivity
extends Activity {
    private static final String TAG = "SA.SchemeActivity";
    public static final String SCHEME_ACTIVITY_SIGN = "#*#scheme_activity_sign#*#";
    public static boolean isPopWindow = false;
    private boolean isStartApp = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        SALog.i(TAG, "onCreate");
        try {
            this.requestWindowFeature(1);
            if (Build.VERSION.SDK_INT >= 14) {
                this.setTheme(16974123);
            } else {
                this.setTheme(16973836);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        if (SensorsDataAPI.sharedInstance() instanceof SensorsDataAPIEmptyImplementation) {
            SALog.i(TAG, "onCreate SensorsDataAPIEmptyImplementation");
            SensorsDataDialogUtils.startLaunchActivity((Context)this);
        } else {
            SALog.i(TAG, "onCreate handleSchemeUrl");
            SensorsDataUtils.handleSchemeUrl(this, this.getIntent());
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        try {
            SALog.i(TAG, "onNewIntent intent = " + intent);
            if (SensorsDataAPI.sharedInstance() instanceof SensorsDataAPIEmptyImplementation) {
                SALog.i(TAG, "onNewIntent SensorsDataAPIEmptyImplementation");
                SensorsDataDialogUtils.startLaunchActivity((Context)this);
            } else {
                SALog.i(TAG, "onNewIntent handleSchemeUrl");
                SensorsDataUtils.handleSchemeUrl(this, this.getIntent());
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    protected void onResume() {
        super.onResume();
        SALog.i(TAG, "onResume");
        if (this.isStartApp) {
            this.isStartApp = false;
            SensorsDataDialogUtils.startLaunchActivity((Context)this);
        }
    }

    protected void onPause() {
        super.onPause();
        SALog.i(TAG, "onPause");
        if (isPopWindow) {
            isPopWindow = false;
            this.isStartApp = true;
        }
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }
}

