/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.util.SADisplayUtil;

class DebugModeSelectDialog
extends Dialog
implements View.OnClickListener {
    private Context mContext;
    private OnDebugModeViewClickListener onDebugModeDialogClickListener;
    private SensorsDataAPI.DebugMode currentDebugMode;

    DebugModeSelectDialog(Context context, SensorsDataAPI.DebugMode debugMode) {
        super(context);
        this.mContext = context;
        this.currentDebugMode = debugMode;
    }

    void setOnDebugModeDialogClickListener(OnDebugModeViewClickListener onDebugModeDialogClickListener) {
        this.onDebugModeDialogClickListener = onDebugModeDialogClickListener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.sensors_analytics_debug_mode_dialog_content);
        this.initView();
        Window window = this.getWindow();
        if (window != null) {
            WindowManager.LayoutParams p = window.getAttributes();
            p.width = SADisplayUtil.dip2px(this.getContext(), 270.0f);
            p.height = SADisplayUtil.dip2px(this.getContext(), 240.0f);
            window.setAttributes(p);
            GradientDrawable bg = new GradientDrawable();
            bg.setShape(0);
            bg.setColor(-1);
            bg.setCornerRadius((float)SADisplayUtil.dip2px(this.getContext(), 7.0f));
            window.setBackgroundDrawable((Drawable)bg);
        }
    }

    private void initView() {
        TextView debugModeTitle = (TextView)this.findViewById(R.id.sensors_analytics_debug_mode_title);
        debugModeTitle.setText((CharSequence)SADisplayUtil.getStringResource(this.mContext, R.string.sensors_analytics_debug_view_title));
        TextView debugModeCancel = (TextView)this.findViewById(R.id.sensors_analytics_debug_mode_cancel);
        debugModeCancel.setText((CharSequence)SADisplayUtil.getStringResource(this.mContext, R.string.sensors_analytics_common_cancel));
        debugModeCancel.setOnClickListener((View.OnClickListener)this);
        debugModeCancel.setFocusable(true);
        TextView debugModeOnly = (TextView)this.findViewById(R.id.sensors_analytics_debug_mode_only);
        debugModeOnly.setText((CharSequence)SADisplayUtil.getStringResource(this.mContext, R.string.sensors_analytics_debug_only));
        debugModeOnly.setOnClickListener((View.OnClickListener)this);
        debugModeOnly.setFocusable(true);
        TextView debugModeTrack = (TextView)this.findViewById(R.id.sensors_analytics_debug_mode_track);
        debugModeTrack.setText((CharSequence)SADisplayUtil.getStringResource(this.mContext, R.string.sensors_analytics_debug_and_track));
        debugModeTrack.setOnClickListener((View.OnClickListener)this);
        debugModeTrack.setFocusable(true);
        String msg = SADisplayUtil.getStringResource(this.mContext, R.string.sensors_analytics_debug_name_default);
        if (this.currentDebugMode == SensorsDataAPI.DebugMode.DEBUG_ONLY) {
            msg = SADisplayUtil.getStringResource(this.mContext, R.string.sensors_analytics_debug_name_only);
        } else if (this.currentDebugMode == SensorsDataAPI.DebugMode.DEBUG_AND_TRACK) {
            msg = SADisplayUtil.getStringResource(this.mContext, R.string.sensors_analytics_debug_name_track);
        }
        TextView debugModeMessage = (TextView)this.findViewById(R.id.sensors_analytics_debug_mode_message);
        debugModeMessage.setText((CharSequence)msg);
        if (Build.VERSION.SDK_INT >= 16) {
            debugModeCancel.setBackground((Drawable)this.getDrawable());
            debugModeOnly.setBackground((Drawable)this.getDrawable());
            debugModeTrack.setBackground((Drawable)this.getDrawable());
        } else {
            debugModeCancel.setBackgroundDrawable((Drawable)this.getDrawable());
            debugModeOnly.setBackgroundDrawable((Drawable)this.getDrawable());
            debugModeTrack.setBackgroundDrawable((Drawable)this.getDrawable());
        }
    }

    private StateListDrawable getDrawable() {
        GradientDrawable pressDrawable = new GradientDrawable();
        pressDrawable.setShape(0);
        pressDrawable.setColor(Color.parseColor((String)"#dddddd"));
        GradientDrawable normalDrawable = new GradientDrawable();
        normalDrawable.setShape(0);
        normalDrawable.setColor(-1);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)pressDrawable);
        stateListDrawable.addState(new int[]{16842908}, (Drawable)pressDrawable);
        stateListDrawable.addState(new int[0], (Drawable)normalDrawable);
        return stateListDrawable;
    }

    public void onClick(View v) {
        if (this.onDebugModeDialogClickListener == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.sensors_analytics_debug_mode_track) {
            this.onDebugModeDialogClickListener.setDebugMode(this, SensorsDataAPI.DebugMode.DEBUG_AND_TRACK);
        } else if (id2 == R.id.sensors_analytics_debug_mode_only) {
            this.onDebugModeDialogClickListener.setDebugMode(this, SensorsDataAPI.DebugMode.DEBUG_ONLY);
        } else if (id2 == R.id.sensors_analytics_debug_mode_cancel) {
            this.onDebugModeDialogClickListener.onCancel(this);
        }
    }

    static interface OnDebugModeViewClickListener {
        public void onCancel(Dialog var1);

        public void setDebugMode(Dialog var1, SensorsDataAPI.DebugMode var2);
    }
}

