/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.data.adapter;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.business.instantevent.InstantEventUtils;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.data.adapter.EncryptDataOperation;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TransportEncryption
extends EncryptDataOperation {
    private Object mSupportTransport = null;

    TransportEncryption(Context context) {
        super(context);
        this.mDbEncrypt = false;
    }

    @Override
    int insertData(Uri uri, JSONObject jsonObject) {
        try {
            if (this.deleteDataLowMemory(uri) != 0) {
                return -2;
            }
            int instant_event = InstantEventUtils.isInstantEvent(jsonObject);
            ContentValues cv = new ContentValues();
            String eventJson = this.encryptValue(jsonObject.toString());
            cv.put("data", eventJson + "\t" + eventJson.hashCode());
            cv.put("created_at", Long.valueOf(System.currentTimeMillis()));
            cv.put("is_instant_event", Integer.valueOf(instant_event));
            this.contentResolver.insert(uri, cv);
        }
        catch (Throwable e) {
            SALog.i(this.TAG, e.getMessage());
        }
        return 0;
    }

    @Override
    String[] queryData(Uri uri, int limit) {
        return this.queryData(uri, false, limit);
    }

    @Override
    String[] queryData(Uri uri, boolean is_instant_event, int limit) {
        try {
            String gzipType;
            String[] eventsData = super.queryData(uri, is_instant_event, limit);
            if (eventsData != null && eventsData.length >= 3 && "1".equals(gzipType = eventsData[2]) && this.isSupportTransport()) {
                String eventIds = eventsData[0];
                String data = (String)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "encryptEventData", eventsData[1]);
                gzipType = "13";
                try {
                    if (!TextUtils.isEmpty((CharSequence)data) && data.contains("payloads")) {
                        JSONArray jsonArray = new JSONArray();
                        JSONObject dataJSON = new JSONObject(data);
                        dataJSON.put("flush_time", System.currentTimeMillis());
                        jsonArray.put((Object)dataJSON);
                        return new String[]{eventIds, jsonArray.toString(), gzipType};
                    }
                }
                catch (JSONException e) {
                    SALog.printStackTrace((Exception)((Object)e));
                }
            }
            return eventsData;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return null;
        }
    }

    private boolean isSupportTransport() {
        if (this.mSupportTransport == null) {
            this.mSupportTransport = SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "supportTransportEncrypt", new Object[0]);
        }
        return this.mSupportTransport != null && (Boolean)this.mSupportTransport != false;
    }

    private String encryptValue(String value) {
        String encryptValue = "";
        if (this.isSupportTransport()) {
            encryptValue = (String)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "storeEvent", value);
        }
        return TextUtils.isEmpty((CharSequence)encryptValue) ? value : "{\"payloads\": \"" + encryptValue + "\"}";
    }
}

