/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.data.adapter;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteBlobTooBigException;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.business.instantevent.InstantEventUtils;
import com.sensorsdata.analytics.android.sdk.data.adapter.DataOperation;
import org.json.JSONArray;
import org.json.JSONObject;

class EventDataOperation
extends DataOperation {
    EventDataOperation(Context context) {
        super(context);
        this.TAG = "EventDataOperation";
    }

    @Override
    int insertData(Uri uri, JSONObject jsonObject) {
        try {
            if (this.deleteDataLowMemory(uri) != 0) {
                return -2;
            }
            int instant_event = InstantEventUtils.isInstantEvent(jsonObject);
            ContentValues cv = new ContentValues();
            String eventJson = jsonObject.toString();
            cv.put("data", eventJson + "\t" + eventJson.hashCode());
            cv.put("created_at", Long.valueOf(System.currentTimeMillis()));
            cv.put("is_instant_event", Integer.valueOf(instant_event));
            this.contentResolver.insert(uri, cv);
        }
        catch (Throwable e) {
            SALog.i(this.TAG, e.getMessage());
        }
        return 0;
    }

    @Override
    int insertData(Uri uri, ContentValues contentValues) {
        try {
            if (this.deleteDataLowMemory(uri) != 0) {
                return -2;
            }
            this.contentResolver.insert(uri, contentValues);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return 0;
    }

    @Override
    String[] queryData(Uri uri, int limit) {
        return this.queryData(uri, false, limit);
    }

    @Override
    String[] queryData(Uri uri, boolean is_instant_event, int limit) {
        try {
            return this.queryDataInner(uri, is_instant_event, limit);
        }
        catch (SQLiteBlobTooBigException bigException) {
            SALog.i(this.TAG, "Could not pull records for SensorsData out of database events. SQLiteBlobTooBigException ", bigException);
            return this.handleBigException(uri, is_instant_event);
        }
        catch (SQLiteException e) {
            SALog.i(this.TAG, "Could not pull records for SensorsData out of database events. Waiting to send.", e);
            return null;
        }
    }

    @Override
    void deleteData(Uri uri, String id2) {
        super.deleteData(uri, id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] queryDataInner(Uri uri, boolean is_instant_event, int limit) {
        Cursor cursor = null;
        String data = null;
        String eventIds = null;
        JSONArray idArray = new JSONArray();
        try {
            String instant_event = "0";
            if (is_instant_event) {
                instant_event = "1";
            }
            if ((cursor = this.contentResolver.query(uri, null, "is_instant_event=?", new String[]{instant_event}, "created_at ASC LIMIT " + limit)) != null) {
                StringBuilder dataBuilder = new StringBuilder();
                String flush_time = ",\"_flush_time\":";
                String suffix = ",";
                dataBuilder.append("[");
                while (cursor.moveToNext()) {
                    if (cursor.isLast()) {
                        suffix = "]";
                    }
                    String eventId = cursor.getString(cursor.getColumnIndexOrThrow("_id"));
                    idArray.put((Object)eventId);
                    try {
                        String keyData = cursor.getString(cursor.getColumnIndexOrThrow("data"));
                        if (TextUtils.isEmpty((CharSequence)(keyData = this.parseData(keyData)))) continue;
                        dataBuilder.append(keyData, 0, keyData.length() - 1).append(",\"_flush_time\":").append(System.currentTimeMillis()).append("}").append(suffix);
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
                data = dataBuilder.toString();
                if (idArray.length() > 0) {
                    eventIds = idArray.toString();
                }
            }
        }
        catch (Throwable error) {
            SALog.i(this.TAG, error.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (eventIds != null) {
            return new String[]{eventIds, data, "1"};
        }
        return null;
    }

    private String[] handleBigException(Uri uri, boolean is_instant_event) {
        try {
            return this.queryDataInner(uri, is_instant_event, 1);
        }
        catch (SQLiteBlobTooBigException bigException) {
            this.deleteData(uri, this.getFirstRowId(uri, is_instant_event ? "1" : "0"));
            SALog.printStackTrace((Exception)((Object)bigException));
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return null;
    }
}

