/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.data.adapter;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class DataOperation {
    String TAG = "EventDataOperation";
    ContentResolver contentResolver;
    private File mDatabaseFile;
    private final Context mContext;

    DataOperation(Context context) {
        this.mContext = context;
        this.contentResolver = context.getContentResolver();
    }

    abstract int insertData(Uri var1, JSONObject var2);

    abstract int insertData(Uri var1, ContentValues var2);

    abstract String[] queryData(Uri var1, int var2);

    abstract String[] queryData(Uri var1, boolean var2, int var3);

    int queryDataCount(Uri uri, int select) {
        String[] selectionArgs = null;
        switch (select) {
            case 0: {
                selectionArgs = new String[]{"0"};
                break;
            }
            case 1: {
                selectionArgs = new String[]{"1"};
                break;
            }
        }
        if (selectionArgs != null) {
            return this.queryDataCount(uri, new String[]{"_id"}, "is_instant_event=?", selectionArgs, null);
        }
        return this.queryDataCount(uri, new String[]{"_id"}, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int queryDataCount(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        try (Cursor cursor = null;){
            cursor = this.contentResolver.query(uri, projection, selection, selectionArgs, sortOrder);
            if (cursor != null) {
                int n = cursor.getCount();
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFirstRowId(Uri uri, String instant_event) {
        try (Cursor cursor = null;){
            cursor = this.contentResolver.query(uri, new String[]{"_id"}, "is_instant_event=?", new String[]{instant_event}, "created_at ASC LIMIT 1");
            if (cursor != null) {
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("_id"));
                return string2;
            }
        }
        return "";
    }

    void deleteData(Uri uri, String id2) {
        try {
            if ("DB_DELETE_ALL".equals(id2)) {
                SALog.i(this.TAG, "deleteData DB_DELETE_ALL");
                this.contentResolver.delete(uri, null, null);
            } else {
                this.contentResolver.delete(uri, "_id <= ?", new String[]{id2});
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public void deleteData(Uri uri, JSONArray ids) {
        try {
            SALog.i(this.TAG, "deleteData ids = " + ids);
            this.mContext.getContentResolver().delete(uri, "_id in " + this.buildIds(ids), null);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    String parseData(String keyData) {
        try {
            if (TextUtils.isEmpty((CharSequence)keyData)) {
                return "";
            }
            int index = keyData.lastIndexOf("\t");
            if (index > -1) {
                String crc = keyData.substring(index).replaceFirst("\t", "");
                if (TextUtils.isEmpty((CharSequence)(keyData = keyData.substring(0, index))) || TextUtils.isEmpty((CharSequence)crc) || !crc.equals(String.valueOf(keyData.hashCode()))) {
                    return "";
                }
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
        return keyData;
    }

    int deleteDataLowMemory(Uri uri) {
        if (this.belowMemThreshold()) {
            SALog.i(this.TAG, "There is not enough space left on the device to store events, so will delete 100 oldest events");
            String[] eventsData = this.queryData(uri, 100);
            if (eventsData == null) {
                return -2;
            }
            String lastId = eventsData[0];
            this.deleteData(uri, lastId);
            if (this.queryDataCount(uri, 2) <= 0) {
                return -2;
            }
        }
        return 0;
    }

    private long getMaxCacheSize(Context context) {
        try {
            return SensorsDataAPI.sharedInstance(context).getMaxCacheSize();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return 0x2000000L;
        }
    }

    private boolean belowMemThreshold() {
        if (this.mDatabaseFile == null) {
            this.mDatabaseFile = this.mContext.getDatabasePath("sensorsdata");
        }
        if (this.mDatabaseFile.exists()) {
            return this.mDatabaseFile.length() >= this.getMaxCacheSize(this.mContext);
        }
        return false;
    }

    private String buildIds(JSONArray idArray) throws JSONException {
        StringBuilder idArgs = new StringBuilder();
        idArgs.append("(");
        if (idArray != null && idArray.length() > 0) {
            for (int index = 0; index < idArray.length(); ++index) {
                idArgs.append(idArray.get(index)).append(",");
            }
            idArgs.replace(idArgs.length() - 1, idArgs.length(), "");
        }
        idArgs.append(")");
        return idArgs.toString();
    }
}

