/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.data;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.sensorsdata.analytics.android.sdk.SALog;

class SensorsDataDBHelper
extends SQLiteOpenHelper {
    private static final String TAG = "SA.SQLiteOpenHelper";
    private static final String CREATE_EVENTS_TABLE = String.format("CREATE TABLE IF NOT EXISTS %s (_id INTEGER PRIMARY KEY AUTOINCREMENT, %s TEXT NOT NULL, %s INTEGER NOT NULL, %s INTEGER NOT NULL DEFAULT 0);", "events", "data", "created_at", "is_instant_event");
    private static final String EVENTS_TIME_INDEX = String.format("CREATE INDEX IF NOT EXISTS time_idx ON %s (%s);", "events", "created_at");
    private static final String CHANNEL_EVENT_PERSISTENT_TABLE = String.format("CREATE TABLE IF NOT EXISTS %s (%s TEXT PRIMARY KEY, %s INTEGER)", "t_channel", "event_name", "result");
    private static final String CREATE_EVENTS_CACHE_TABLE = String.format("CREATE TABLE IF NOT EXISTS %s (_id INTEGER PRIMARY KEY AUTOINCREMENT, %s TEXT NOT NULL, %s INTEGER NOT NULL);", "events_cache", "data", "created_at");

    SensorsDataDBHelper(Context context) {
        super(context, "sensorsdata", null, 7);
    }

    public void onCreate(SQLiteDatabase db) {
        SALog.i(TAG, "Creating a new Sensors Analytics DB");
        this.createTable(db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        SALog.i(TAG, "Upgrading app, replacing Sensors Analytics DB, oldVersion:" + oldVersion + ", newVersion:" + newVersion);
        try {
            if (oldVersion < 4) {
                db.execSQL(String.format("DROP TABLE IF EXISTS %s", "events"));
            }
            this.createTable(db);
            if (oldVersion >= 4 && oldVersion <= 5 && !this.checkColumnExist(db, "events", "is_instant_event")) {
                String sql = "ALTER TABLE events ADD COLUMN  is_instant_event INTEGER NOT NULL DEFAULT 0";
                db.execSQL(sql);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private void createTable(SQLiteDatabase db) {
        db.execSQL(CREATE_EVENTS_TABLE);
        db.execSQL(EVENTS_TIME_INDEX);
        db.execSQL(CHANNEL_EVENT_PERSISTENT_TABLE);
        db.execSQL(CREATE_EVENTS_CACHE_TABLE);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkColumnExist(SQLiteDatabase db, String tableName, String columnName) {
        boolean result = false;
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("SELECT * FROM " + tableName + " LIMIT 0", null);
            result = cursor != null && cursor.getColumnIndex(columnName) != -1;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        finally {
            try {
                if (null != cursor && !cursor.isClosed()) {
                    cursor.close();
                }
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
        }
        return result;
    }
}

