/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.business.timer;

import android.os.SystemClock;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.business.timer.EventTimer;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import java.util.HashMap;
import java.util.Map;

public class EventTimerManager {
    private final Map<String, EventTimer> mTrackTimer = new HashMap<String, EventTimer>();

    public static synchronized EventTimerManager getInstance() {
        return SingletonHolder.mInstance;
    }

    private EventTimerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventTimer(String eventName, EventTimer eventTimer) {
        Map<String, EventTimer> map = this.mTrackTimer;
        synchronized (map) {
            this.mTrackTimer.put(eventName, eventTimer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimer(String eventName) {
        Map<String, EventTimer> map = this.mTrackTimer;
        synchronized (map) {
            this.mTrackTimer.remove(eventName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEndTime(String eventName, long endTime) {
        Map<String, EventTimer> map = this.mTrackTimer;
        synchronized (map) {
            EventTimer eventTimer = this.mTrackTimer.get(eventName);
            if (eventTimer != null) {
                eventTimer.setEndTime(endTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimerState(String eventName, long startTime, boolean isPause) {
        try {
            SADataHelper.assertEventName(eventName);
            Map<String, EventTimer> map = this.mTrackTimer;
            synchronized (map) {
                EventTimer eventTimer = this.mTrackTimer.get(eventName);
                if (eventTimer != null && eventTimer.isPaused() != isPause) {
                    eventTimer.setTimerState(isPause, startTime);
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTimer getEventTimer(String eventName) {
        EventTimer eventTimer;
        Map<String, EventTimer> map = this.mTrackTimer;
        synchronized (map) {
            eventTimer = this.mTrackTimer.get(eventName);
            this.mTrackTimer.remove(eventName);
        }
        return eventTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTimers() {
        try {
            Map<String, EventTimer> map = this.mTrackTimer;
            synchronized (map) {
                this.mTrackTimer.clear();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appBecomeActive() {
        Map<String, EventTimer> map = this.mTrackTimer;
        synchronized (map) {
            try {
                for (Map.Entry<String, EventTimer> entry : this.mTrackTimer.entrySet()) {
                    EventTimer eventTimer;
                    if (entry == null || (eventTimer = entry.getValue()) == null) continue;
                    eventTimer.setStartTime(SystemClock.elapsedRealtime());
                }
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appEnterBackground() {
        Map<String, EventTimer> map = this.mTrackTimer;
        synchronized (map) {
            try {
                for (Map.Entry<String, EventTimer> entry : this.mTrackTimer.entrySet()) {
                    EventTimer eventTimer;
                    if (entry == null || "$AppEnd".equals(entry.getKey()) || (eventTimer = entry.getValue()) == null || eventTimer.isPaused()) continue;
                    long eventAccumulatedDuration = eventTimer.getEventAccumulatedDuration() + SystemClock.elapsedRealtime() - eventTimer.getStartTime();
                    eventTimer.setEventAccumulatedDuration(eventAccumulatedDuration);
                    eventTimer.setStartTime(SystemClock.elapsedRealtime());
                }
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
        }
    }

    private static class SingletonHolder {
        private static final EventTimerManager mInstance = new EventTimerManager();

        private SingletonHolder() {
        }
    }
}

