/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.business.timer;

import android.os.SystemClock;
import com.sensorsdata.analytics.android.sdk.SALog;
import java.util.concurrent.TimeUnit;

public class EventTimer {
    private final TimeUnit timeUnit;
    private long startTime;
    private long endTime;
    private long eventAccumulatedDuration;
    private boolean isPaused = false;

    public EventTimer(TimeUnit timeUnit, long startTime) {
        this.startTime = startTime;
        this.timeUnit = timeUnit;
        this.eventAccumulatedDuration = 0L;
        this.endTime = -1L;
    }

    public float duration() {
        this.endTime = this.isPaused ? this.startTime : (this.endTime < 0L ? SystemClock.elapsedRealtime() : this.endTime);
        long duration = this.endTime - this.startTime + this.eventAccumulatedDuration;
        try {
            if (duration < 0L || duration > 86400000L) {
                return 0.0f;
            }
            float durationFloat = this.timeUnit == TimeUnit.MILLISECONDS ? (float)duration : (this.timeUnit == TimeUnit.SECONDS ? (float)duration / 1000.0f : (this.timeUnit == TimeUnit.MINUTES ? (float)duration / 1000.0f / 60.0f : (this.timeUnit == TimeUnit.HOURS ? (float)duration / 1000.0f / 60.0f / 60.0f : (float)duration)));
            return durationFloat < 0.0f ? 0.0f : (float)Math.round(durationFloat * 1000.0f) / 1000.0f;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return 0.0f;
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getEventAccumulatedDuration() {
        return this.eventAccumulatedDuration;
    }

    public void setEventAccumulatedDuration(long eventAccumulatedDuration) {
        this.eventAccumulatedDuration = eventAccumulatedDuration;
    }

    public void setTimerState(boolean isPaused, long elapsedRealtime) {
        this.isPaused = isPaused;
        if (isPaused) {
            this.eventAccumulatedDuration = this.eventAccumulatedDuration + elapsedRealtime - this.startTime;
        }
        this.startTime = elapsedRealtime;
    }

    public boolean isPaused() {
        return this.isPaused;
    }
}

