/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.business.session;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.SAStoreManager;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionRelatedManager {
    private static volatile SessionRelatedManager mSessionRelatedManager = null;
    private final String SHARED_PREF_SESSION_CUTDATA = "sensorsdata.session.cutdata";
    public final String EVENT_SESSION_ID = "$event_session_id";
    private final String KEY_SESSION_ID = "sessionID";
    private final String KEY_START_TIME = "startTime";
    private final String KEY_LAST_EVENT_TIME = "lastEventTime";
    private long SESSION_LAST_INTERVAL_TIME = 300000L;
    private final long SESSION_START_INTERVAL_TIME = 43200000L;
    private String mSessionID;
    private long mStartTime;
    private long mLastEventTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SessionRelatedManager getInstance() {
        if (null != mSessionRelatedManager) return mSessionRelatedManager;
        Class<SessionRelatedManager> clazz = SessionRelatedManager.class;
        synchronized (SessionRelatedManager.class) {
            if (null != mSessionRelatedManager) return mSessionRelatedManager;
            mSessionRelatedManager = new SessionRelatedManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mSessionRelatedManager;
        }
    }

    private SessionRelatedManager() {
        try {
            this.setSessionLastIntervalTime(SensorsDataAPI.getConfigOptions().getEventSessionTimeout());
            if (!SensorsDataAPI.getConfigOptions().isEnableSession()) {
                this.deleteSessionData();
            } else {
                this.readSessionData();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public void handleEventOfSession(String eventName, JSONObject property, long time) {
        if (!SensorsDataAPI.getConfigOptions().isEnableSession()) {
            return;
        }
        try {
            if ("$AppEnd".equals(eventName)) {
                if (time > this.mLastEventTime) {
                    this.mLastEventTime = time;
                }
                return;
            }
            this.handleSessionState(time);
            property.put("$event_session_id", (Object)this.mSessionID);
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    private void updateSessionLastTime(long eventTime) {
        this.mLastEventTime = eventTime;
        SAStoreManager.getInstance().setString("sensorsdata.session.cutdata", this.getSessionDataPack());
    }

    private void deleteSessionData() {
        this.mSessionID = null;
        this.mStartTime = -1L;
        this.mLastEventTime = -1L;
        SAStoreManager.getInstance().remove("sensorsdata.session.cutdata");
    }

    private synchronized void createSessionData(long eventTime, boolean isUpdateSessionStartTime) {
        this.mSessionID = UUID.randomUUID().toString();
        if (isUpdateSessionStartTime) {
            this.mStartTime = eventTime;
        }
        this.mLastEventTime = Math.max(eventTime, this.mLastEventTime);
        SAStoreManager.getInstance().setString("sensorsdata.session.cutdata", this.getSessionDataPack());
    }

    private void readSessionData() {
        String sessionJson = SAStoreManager.getInstance().getString("sensorsdata.session.cutdata", "");
        if (TextUtils.isEmpty((CharSequence)sessionJson)) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(sessionJson);
            if (jsonObject.has("sessionID")) {
                this.mSessionID = jsonObject.optString("sessionID");
            }
            if (jsonObject.has("startTime")) {
                this.mStartTime = jsonObject.optLong("startTime");
            }
            if (jsonObject.has("lastEventTime")) {
                this.mLastEventTime = jsonObject.optLong("lastEventTime");
            }
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    private synchronized void handleSessionState(long eventTime) {
        if (eventTime <= 0L) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mSessionID) || eventTime - this.mLastEventTime > this.SESSION_LAST_INTERVAL_TIME || eventTime - this.mStartTime > 43200000L) {
            this.createSessionData(eventTime, true);
        } else {
            this.updateSessionLastTime(eventTime);
        }
    }

    public void refreshSessionByTimer(long refreshTime) {
        if (refreshTime - this.mLastEventTime > this.SESSION_LAST_INTERVAL_TIME) {
            this.createSessionData(refreshTime, TextUtils.isEmpty((CharSequence)this.mSessionID));
        }
    }

    private String getSessionDataPack() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("sessionID", (Object)this.mSessionID);
            jsonObject.put("startTime", this.mStartTime);
            jsonObject.put("lastEventTime", this.mLastEventTime);
            return jsonObject.toString();
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
            return "";
        }
    }

    public String getSessionID() {
        return this.mSessionID;
    }

    private void setSessionLastIntervalTime(int intervalTime) {
        if (intervalTime > 0) {
            this.SESSION_LAST_INTERVAL_TIME = (long)intervalTime * 1000L;
        }
    }
}

