/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.business;

import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.business.timer.EventTimerManager;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.util.AppStateTools;

public class DefaultAppState
implements AppStateTools.AppState {
    private final SensorsDataAPI mSensorsDataInstance;
    private boolean resumeFromBackground = false;
    private boolean mIsResumeScreenOrientation = false;

    public DefaultAppState(SensorsDataAPI instance) {
        this.mSensorsDataInstance = instance;
    }

    @Override
    public void onForeground() {
        try {
            EventTimerManager.getInstance().appBecomeActive();
            if (this.resumeFromBackground) {
                this.mSensorsDataInstance.getSAContextManager().getRemoteManager().applySDKConfigFromCache();
                if (this.mIsResumeScreenOrientation) {
                    this.mSensorsDataInstance.resumeTrackScreenOrientation();
                }
                try {
                    SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "resumeHeatMapService", new Object[0]);
                    SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "resumeVisualService", new Object[0]);
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
            this.mSensorsDataInstance.getSAContextManager().getRemoteManager().pullSDKConfigFromServer();
            this.resumeFromBackground = true;
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    @Override
    public void onBackground() {
        try {
            if (this.mSensorsDataInstance.getSAContextManager().getOrientationDetector() != null && this.mSensorsDataInstance.getSAContextManager().getOrientationDetector().isEnableState()) {
                this.mSensorsDataInstance.stopTrackScreenOrientation();
                this.mIsResumeScreenOrientation = true;
            } else {
                this.mIsResumeScreenOrientation = false;
            }
            this.mSensorsDataInstance.getSAContextManager().getRemoteManager().resetPullSDKConfigTimer();
            SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "stopHeatMapService", new Object[0]);
            SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "stopVisualService", new Object[0]);
            EventTimerManager.getInstance().appEnterBackground();
            this.mSensorsDataInstance.clearLastScreenUrl();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }
}

