/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core;

import android.content.Context;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.AnalyticsMessages;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SensorsDataScreenOrientationDetector;
import com.sensorsdata.analytics.android.sdk.core.SACoreHelper;
import com.sensorsdata.analytics.android.sdk.core.event.EventProcessor;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.core.event.TrackEventProcessor;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbAdapter;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentFirstDay;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.internal.beans.InternalConfigOptions;
import com.sensorsdata.analytics.android.sdk.listener.SAEventListener;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.SAStoreManager;
import com.sensorsdata.analytics.android.sdk.plugin.property.PropertyPluginManager;
import com.sensorsdata.analytics.android.sdk.remote.BaseSensorsDataSDKRemoteManager;
import com.sensorsdata.analytics.android.sdk.remote.SensorsDataRemoteManager;
import com.sensorsdata.analytics.android.sdk.useridentity.UserIdentityAPI;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class SAContextManager {
    private Context mContext;
    private List<SAEventListener> mEventListenerList;
    private SensorsDataScreenOrientationDetector mOrientationDetector;
    private SensorsDataAPI mSensorsDataAPI;
    private PersistentFirstDay mFirstDay;
    private PropertyPluginManager mPluginManager;
    private EventProcessor mTrackEventProcessor;
    private InternalConfigOptions mInternalConfigs;
    private AnalyticsMessages mMessages;
    BaseSensorsDataSDKRemoteManager mRemoteManager;
    UserIdentityAPI mUserIdentityAPI;

    public SAContextManager() {
    }

    public SAContextManager(SensorsDataAPI sensorsDataAPI, InternalConfigOptions internalConfigs) {
        try {
            this.mSensorsDataAPI = sensorsDataAPI;
            this.mInternalConfigs = internalConfigs;
            this.mContext = internalConfigs.context.getApplicationContext();
            DbAdapter.getInstance(this);
            this.mMessages = AnalyticsMessages.getInstance(this.mContext, sensorsDataAPI, this.mInternalConfigs);
            this.mTrackEventProcessor = new TrackEventProcessor(this);
            this.mFirstDay = PersistentLoader.getInstance().getFirstDayPst();
            this.mPluginManager = new PropertyPluginManager(sensorsDataAPI, this);
            SAStoreManager.getInstance().registerPlugins(this.mInternalConfigs.saConfigOptions.getStorePlugins(), this.mContext);
            SAStoreManager.getInstance().upgrade();
            this.executeDelayTask();
            SAModuleManager.getInstance().installService(this);
            this.mRemoteManager = new SensorsDataRemoteManager(sensorsDataAPI, this);
            this.mRemoteManager.applySDKConfigFromCache();
            internalConfigs.context = this.mContext;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private void executeDelayTask() {
        SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

            @Override
            public void run() {
                String anonymousId = ((SAContextManager)SAContextManager.this).mInternalConfigs.saConfigOptions.getAnonymousId();
                if (!TextUtils.isEmpty((CharSequence)anonymousId)) {
                    SAContextManager.this.getUserIdentityAPI().identify(anonymousId);
                }
            }
        });
    }

    public List<SAEventListener> getEventListenerList() {
        return this.mEventListenerList;
    }

    public void addEventListener(SAEventListener eventListener) {
        try {
            if (this.mEventListenerList == null) {
                this.mEventListenerList = new ArrayList<SAEventListener>();
            }
            this.mEventListenerList.add(eventListener);
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public void removeEventListener(SAEventListener eventListener) {
        try {
            if (this.mEventListenerList != null && this.mEventListenerList.contains(eventListener)) {
                this.mEventListenerList.remove(eventListener);
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public BaseSensorsDataSDKRemoteManager getRemoteManager() {
        return this.mRemoteManager;
    }

    public void setRemoteManager(BaseSensorsDataSDKRemoteManager mRemoteManager) {
        this.mRemoteManager = mRemoteManager;
    }

    public synchronized UserIdentityAPI getUserIdentityAPI() {
        if (this.mUserIdentityAPI == null) {
            this.mUserIdentityAPI = new UserIdentityAPI(this);
        }
        return this.mUserIdentityAPI;
    }

    public SensorsDataAPI getSensorsDataAPI() {
        return this.mSensorsDataAPI;
    }

    public boolean isFirstDay(long eventTime) {
        String firstDay = (String)this.mFirstDay.get();
        if (firstDay == null) {
            this.mFirstDay.commit(TimeUtils.formatTime(System.currentTimeMillis(), "yyyy-MM-dd"));
            return true;
        }
        try {
            String current = TimeUtils.formatTime(eventTime, "yyyy-MM-dd");
            return firstDay.equals(current);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return true;
        }
    }

    public PropertyPluginManager getPluginManager() {
        return this.mPluginManager;
    }

    public void trackEvent(InputData inputData) {
        try {
            this.checkAppStart("");
            this.mTrackEventProcessor.trackEvent(inputData);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public void checkAppStart(final String appStart) {
        if (SAStoreManager.getInstance().isExists("app_start_data")) {
            SACoreHelper.getInstance().trackQueueEvent(new Runnable(){

                @Override
                public void run() {
                    try {
                        String startData = appStart;
                        if (TextUtils.isEmpty((CharSequence)startData)) {
                            startData = SAStoreManager.getInstance().getString("app_start_data", "");
                        }
                        if (!TextUtils.isEmpty((CharSequence)startData)) {
                            JSONObject properties = new JSONObject(startData);
                            SAContextManager.this.mTrackEventProcessor.trackEvent(new InputData().setEventName("$AppStart").setProperties(SADataHelper.appendLibMethodAutoTrack(properties)).setEventType(EventType.TRACK));
                            SAStoreManager.getInstance().remove("app_start_data");
                        }
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            });
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public InternalConfigOptions getInternalConfigs() {
        return this.mInternalConfigs;
    }

    public AnalyticsMessages getAnalyticsMessages() {
        return this.mMessages;
    }

    public SensorsDataScreenOrientationDetector getOrientationDetector() {
        return this.mOrientationDetector;
    }

    public void setOrientationDetector(SensorsDataScreenOrientationDetector mOrientationDetector) {
        this.mOrientationDetector = mOrientationDetector;
    }
}

