/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk;

import com.sensorsdata.analytics.android.sdk.SALog;
import java.util.concurrent.LinkedBlockingQueue;

public class TrackTaskManager {
    private static TrackTaskManager trackTaskManager;
    private final LinkedBlockingQueue<Runnable> mTrackEventTasks = new LinkedBlockingQueue();

    private TrackTaskManager() {
    }

    public static synchronized TrackTaskManager getInstance() {
        try {
            if (null == trackTaskManager) {
                trackTaskManager = new TrackTaskManager();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return trackTaskManager;
    }

    public void addTrackEventTask(Runnable trackEvenTask) {
        try {
            this.mTrackEventTasks.put(trackEvenTask);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public Runnable takeTrackEventTask() {
        try {
            return this.mTrackEventTasks.take();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return null;
        }
    }

    public Runnable pollTrackEventTask() {
        try {
            return this.mTrackEventTasks.poll();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return null;
        }
    }

    public boolean isEmpty() {
        return this.mTrackEventTasks.isEmpty();
    }
}

