/*
 * Created by dengshiwei on 2025/09/01.
 * Copyright 2015－2025 Sensors Data Inc.
 */

package com.sensorsdata.analytics.android.sdk.data.adapter;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;

import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.mediator.Modules;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DataManagerOperation extends DataOperation {
    private final Uri uriDataManager = Uri.parse("content://com.sensorsdata.manager.SensorsDataContentProvider/events");
    private EventDataOperation mEventDataOperation;
    private boolean isEncrypt;

    DataManagerOperation(Context context, boolean isEncrypt) {
        super(context);
        this.isEncrypt = isEncrypt;
        mEventDataOperation = new EventDataOperation(context);
    }

    @Override
    int insertData(Uri uri, JSONObject jsonObject) {
        try {
            if (deleteDataLowMemory(uriDataManager) != 0) {
                return DbParams.DB_OUT_OF_MEMORY_ERROR;
            }
            if (this.isEncrypt) {
                jsonObject = SAModuleManager.getInstance().invokeModuleFunction(Modules.Encrypt.MODULE_NAME, Modules.Encrypt.METHOD_ENCRYPT_EVENT_DATA, jsonObject);
            }
            ContentValues cv = new ContentValues();
            cv.put(DbParams.KEY_DATA, jsonObject.toString() + "\t" + jsonObject.toString().hashCode());
            cv.put(DbParams.KEY_CREATED_AT, System.currentTimeMillis());
            try {
                contentResolver.insert(uriDataManager, cv);
                sendCacheData();
            } catch (Exception exception) { // 出现异常或 ContentProvider 不存在时
                SALog.printStackTrace(exception);
                mEventDataOperation.insertData(DbParams.getInstance().getEventCacheUri(), cv);
            }
        } catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return 0;
    }

    @Override
    int insertData(Uri uri, ContentValues contentValues) {
        return 0;
    }

    @Override
    String[] queryData(Uri uri, int limit) {
        return null;
    }

    @Override
    String[] queryData(Uri uri, boolean is_instant_event, int limit) {
        return new String[0];
    }

    /**
     * 发送缓存数据到公共服务
     */
    private void sendCacheData() {
        Cursor cursor = null;
        Uri eventCache = DbParams.getInstance().getEventCacheUri();
        JSONArray idArray = null;
        try {
            cursor = contentResolver.query(eventCache, null, null, null, DbParams.KEY_CREATED_AT + " ASC");
            if (cursor != null && cursor.getCount() > 0) {
                idArray = new JSONArray();
                while (cursor.moveToNext()) {
                    String keyData = cursor.getString(cursor.getColumnIndexOrThrow(DbParams.KEY_DATA));
                    String KEY_CREATED_AT = cursor.getString(cursor.getColumnIndexOrThrow(DbParams.KEY_DATA));
                    ContentValues cv = new ContentValues();
                    cv.put(DbParams.KEY_DATA, keyData);
                    cv.put(DbParams.KEY_CREATED_AT, KEY_CREATED_AT);
                    contentResolver.insert(uriDataManager, cv);
                    idArray.put(cursor.getString(cursor.getColumnIndexOrThrow("_id")));
                }
            }
        } catch (Exception exception) {
            SALog.printStackTrace(exception);
        } finally {
            try {
                if (idArray != null) {
                    String whereCause = String.format("DELETE FROM %s WHERE _id in %s", DbParams.TABLE_EVENTS_CACHE, buildIds(idArray));
                    contentResolver.delete(eventCache, whereCause, null);
                }
            } catch (Exception e) {
                SALog.printStackTrace(e);
            }
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /**
     * 构造 SQL 中的 id 集合
     *
     * @param idArray id 集合
     * @return SQL 中 id 语句
     */
    private String buildIds(JSONArray idArray) throws JSONException {
        StringBuilder idArgs = new StringBuilder();
        idArgs.append("(");
        if (idArray != null && idArray.length() > 0) {
            for (int index = 0; index < idArray.length(); index++) {
                idArgs.append(idArray.get(index)).append(",");
            }
            idArgs.replace(idArgs.length() - 1, idArgs.length(), "");
        }
        idArgs.append(")");
        return idArgs.toString();
    }
}
